/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.rds.model.DBClusterSnapshot;
import software.amazon.awssdk.services.rds.model.DBClusterSnapshotListCopier;
import software.amazon.awssdk.services.rds.model.RDSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBClusterSnapshotsResponse
extends RDSResponse
implements ToCopyableBuilder<Builder, DescribeDBClusterSnapshotsResponse> {
    private final String marker;
    private final List<DBClusterSnapshot> dbClusterSnapshots;

    private DescribeDBClusterSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusterSnapshots = builder.dbClusterSnapshots;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBClusterSnapshot> dbClusterSnapshots() {
        return this.dbClusterSnapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterSnapshots());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBClusterSnapshotsResponse)) {
            return false;
        }
        DescribeDBClusterSnapshotsResponse other = (DescribeDBClusterSnapshotsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.dbClusterSnapshots(), other.dbClusterSnapshots());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDBClusterSnapshotsResponse").add("Marker", (Object)this.marker()).add("DBClusterSnapshots", this.dbClusterSnapshots()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "DBClusterSnapshots": {
                return Optional.of(clazz.cast(this.dbClusterSnapshots()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBClusterSnapshot> dbClusterSnapshots;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBClusterSnapshotsResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbClusterSnapshots(model.dbClusterSnapshots);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBClusterSnapshot.Builder> getDBClusterSnapshots() {
            return this.dbClusterSnapshots != null ? (Collection)this.dbClusterSnapshots.stream().map(DBClusterSnapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbClusterSnapshots(Collection<DBClusterSnapshot> dbClusterSnapshots) {
            this.dbClusterSnapshots = DBClusterSnapshotListCopier.copy(dbClusterSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshots(DBClusterSnapshot ... dbClusterSnapshots) {
            this.dbClusterSnapshots(Arrays.asList(dbClusterSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshots(Consumer<DBClusterSnapshot.Builder> ... dbClusterSnapshots) {
            this.dbClusterSnapshots(Stream.of(dbClusterSnapshots).map(c -> (DBClusterSnapshot)((DBClusterSnapshot.Builder)DBClusterSnapshot.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDBClusterSnapshots(Collection<DBClusterSnapshot.BuilderImpl> dbClusterSnapshots) {
            this.dbClusterSnapshots = DBClusterSnapshotListCopier.copyFromBuilder(dbClusterSnapshots);
        }

        @Override
        public DescribeDBClusterSnapshotsResponse build() {
            return new DescribeDBClusterSnapshotsResponse(this);
        }
    }

    public static interface Builder
    extends RDSResponse.Builder,
    CopyableBuilder<Builder, DescribeDBClusterSnapshotsResponse> {
        public Builder marker(String var1);

        public Builder dbClusterSnapshots(Collection<DBClusterSnapshot> var1);

        public Builder dbClusterSnapshots(DBClusterSnapshot ... var1);

        public Builder dbClusterSnapshots(Consumer<DBClusterSnapshot.Builder> ... var1);
    }
}

