/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.ModifyDBSubnetGroupRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyDBSubnetGroupRequestMarshaller
implements Marshaller<Request<ModifyDBSubnetGroupRequest>, ModifyDBSubnetGroupRequest> {
    public Request<ModifyDBSubnetGroupRequest> marshall(ModifyDBSubnetGroupRequest modifyDBSubnetGroupRequest) {
        SdkInternalList subnetIdsList;
        if (modifyDBSubnetGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBSubnetGroupRequest, "RDSClient");
        request.addParameter("Action", "ModifyDBSubnetGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBSubnetGroupRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)modifyDBSubnetGroupRequest.dbSubnetGroupName()));
        }
        if (modifyDBSubnetGroupRequest.dbSubnetGroupDescription() != null) {
            request.addParameter("DBSubnetGroupDescription", StringUtils.fromString((String)modifyDBSubnetGroupRequest.dbSubnetGroupDescription()));
        }
        if (!(subnetIdsList = (SdkInternalList)modifyDBSubnetGroupRequest.subnetIds()).isEmpty() || !subnetIdsList.isAutoConstruct()) {
            int subnetIdsListIndex = 1;
            for (String subnetIdsListValue : subnetIdsList) {
                if (subnetIdsListValue != null) {
                    request.addParameter("SubnetIds.SubnetIdentifier." + subnetIdsListIndex, StringUtils.fromString((String)subnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        return request;
    }
}

