/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.FailoverDBClusterRequest;
import software.amazon.awssdk.util.StringUtils;

public class FailoverDBClusterRequestMarshaller
implements Marshaller<Request<FailoverDBClusterRequest>, FailoverDBClusterRequest> {
    public Request<FailoverDBClusterRequest> marshall(FailoverDBClusterRequest failoverDBClusterRequest) {
        if (failoverDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)failoverDBClusterRequest, "RDSClient");
        request.addParameter("Action", "FailoverDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (failoverDBClusterRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)failoverDBClusterRequest.dbClusterIdentifier()));
        }
        if (failoverDBClusterRequest.targetDBInstanceIdentifier() != null) {
            request.addParameter("TargetDBInstanceIdentifier", StringUtils.fromString((String)failoverDBClusterRequest.targetDBInstanceIdentifier()));
        }
        return request;
    }
}

