/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.DescribeDBInstancesRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeDBInstancesRequestMarshaller
implements Marshaller<Request<DescribeDBInstancesRequest>, DescribeDBInstancesRequest> {
    public Request<DescribeDBInstancesRequest> marshall(DescribeDBInstancesRequest describeDBInstancesRequest) {
        SdkInternalList filtersList;
        if (describeDBInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBInstancesRequest, "RDSClient");
        request.addParameter("Action", "DescribeDBInstances");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBInstancesRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)describeDBInstancesRequest.dbInstanceIdentifier()));
        }
        if (!(filtersList = (SdkInternalList)describeDBInstancesRequest.filters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.values()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDBInstancesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBInstancesRequest.maxRecords()));
        }
        if (describeDBInstancesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBInstancesRequest.marker()));
        }
        return request;
    }
}

