/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.DBSnapshotAttribute;

public class DBSnapshotAttributeUnmarshaller
implements Unmarshaller<DBSnapshotAttribute, StaxUnmarshallerContext> {
    private static DBSnapshotAttributeUnmarshaller INSTANCE;

    public DBSnapshotAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DBSnapshotAttribute.Builder dbSnapshotAttribute = DBSnapshotAttribute.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AttributeName", targetDepth)) {
                    dbSnapshotAttribute.attributeName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AttributeValues", targetDepth)) {
                    dbSnapshotAttribute.attributeValues(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("AttributeValues/AttributeValue", targetDepth)) continue;
                dbSnapshotAttribute.attributeValues(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DBSnapshotAttribute)dbSnapshotAttribute.build();
    }

    public static DBSnapshotAttributeUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DBSnapshotAttributeUnmarshaller();
        }
        return INSTANCE;
    }
}

