/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.CopyDBClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CopyDBClusterSnapshotRequestMarshaller
implements Marshaller<Request<CopyDBClusterSnapshotRequest>, CopyDBClusterSnapshotRequest> {
    public Request<CopyDBClusterSnapshotRequest> marshall(CopyDBClusterSnapshotRequest copyDBClusterSnapshotRequest) {
        SdkInternalList tagsList;
        if (copyDBClusterSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copyDBClusterSnapshotRequest, "RDSClient");
        request.addParameter("Action", "CopyDBClusterSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyDBClusterSnapshotRequest.sourceDBClusterSnapshotIdentifier() != null) {
            request.addParameter("SourceDBClusterSnapshotIdentifier", StringUtils.fromString((String)copyDBClusterSnapshotRequest.sourceDBClusterSnapshotIdentifier()));
        }
        if (copyDBClusterSnapshotRequest.targetDBClusterSnapshotIdentifier() != null) {
            request.addParameter("TargetDBClusterSnapshotIdentifier", StringUtils.fromString((String)copyDBClusterSnapshotRequest.targetDBClusterSnapshotIdentifier()));
        }
        if (copyDBClusterSnapshotRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)copyDBClusterSnapshotRequest.kmsKeyId()));
        }
        if (copyDBClusterSnapshotRequest.preSignedUrl() != null) {
            request.addParameter("PreSignedUrl", StringUtils.fromString((String)copyDBClusterSnapshotRequest.preSignedUrl()));
        }
        if (copyDBClusterSnapshotRequest.copyTags() != null) {
            request.addParameter("CopyTags", StringUtils.fromBoolean((Boolean)copyDBClusterSnapshotRequest.copyTags()));
        }
        if (!(tagsList = (SdkInternalList)copyDBClusterSnapshotRequest.tags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

