/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.rds.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RestoreDBClusterFromSnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RestoreDBClusterFromSnapshotRequest> {
    private final List<String> availabilityZones;
    private final String dbClusterIdentifier;
    private final String snapshotIdentifier;
    private final String engine;
    private final String engineVersion;
    private final Integer port;
    private final String dbSubnetGroupName;
    private final String databaseName;
    private final String optionGroupName;
    private final List<String> vpcSecurityGroupIds;
    private final List<Tag> tags;
    private final String kmsKeyId;
    private final Boolean enableIAMDatabaseAuthentication;

    private RestoreDBClusterFromSnapshotRequest(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.port = builder.port;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.databaseName = builder.databaseName;
        this.optionGroupName = builder.optionGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Integer port() {
        return this.port;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterIdentifier() == null ? 0 : this.dbClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.snapshotIdentifier() == null ? 0 : this.snapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.dbSubnetGroupName() == null ? 0 : this.dbSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.databaseName() == null ? 0 : this.databaseName().hashCode());
        hashCode = 31 * hashCode + (this.optionGroupName() == null ? 0 : this.optionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.vpcSecurityGroupIds() == null ? 0 : this.vpcSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.enableIAMDatabaseAuthentication() == null ? 0 : this.enableIAMDatabaseAuthentication().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDBClusterFromSnapshotRequest)) {
            return false;
        }
        RestoreDBClusterFromSnapshotRequest other = (RestoreDBClusterFromSnapshotRequest)((Object)obj);
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        if (other.dbClusterIdentifier() == null ^ this.dbClusterIdentifier() == null) {
            return false;
        }
        if (other.dbClusterIdentifier() != null && !other.dbClusterIdentifier().equals(this.dbClusterIdentifier())) {
            return false;
        }
        if (other.snapshotIdentifier() == null ^ this.snapshotIdentifier() == null) {
            return false;
        }
        if (other.snapshotIdentifier() != null && !other.snapshotIdentifier().equals(this.snapshotIdentifier())) {
            return false;
        }
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.dbSubnetGroupName() == null ^ this.dbSubnetGroupName() == null) {
            return false;
        }
        if (other.dbSubnetGroupName() != null && !other.dbSubnetGroupName().equals(this.dbSubnetGroupName())) {
            return false;
        }
        if (other.databaseName() == null ^ this.databaseName() == null) {
            return false;
        }
        if (other.databaseName() != null && !other.databaseName().equals(this.databaseName())) {
            return false;
        }
        if (other.optionGroupName() == null ^ this.optionGroupName() == null) {
            return false;
        }
        if (other.optionGroupName() != null && !other.optionGroupName().equals(this.optionGroupName())) {
            return false;
        }
        if (other.vpcSecurityGroupIds() == null ^ this.vpcSecurityGroupIds() == null) {
            return false;
        }
        if (other.vpcSecurityGroupIds() != null && !other.vpcSecurityGroupIds().equals(this.vpcSecurityGroupIds())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.enableIAMDatabaseAuthentication() == null ^ this.enableIAMDatabaseAuthentication() == null) {
            return false;
        }
        return other.enableIAMDatabaseAuthentication() == null || other.enableIAMDatabaseAuthentication().equals(this.enableIAMDatabaseAuthentication());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        if (this.dbClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.dbClusterIdentifier()).append(",");
        }
        if (this.snapshotIdentifier() != null) {
            sb.append("SnapshotIdentifier: ").append(this.snapshotIdentifier()).append(",");
        }
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.dbSubnetGroupName() != null) {
            sb.append("DBSubnetGroupName: ").append(this.dbSubnetGroupName()).append(",");
        }
        if (this.databaseName() != null) {
            sb.append("DatabaseName: ").append(this.databaseName()).append(",");
        }
        if (this.optionGroupName() != null) {
            sb.append("OptionGroupName: ").append(this.optionGroupName()).append(",");
        }
        if (this.vpcSecurityGroupIds() != null) {
            sb.append("VpcSecurityGroupIds: ").append(this.vpcSecurityGroupIds()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.enableIAMDatabaseAuthentication() != null) {
            sb.append("EnableIAMDatabaseAuthentication: ").append(this.enableIAMDatabaseAuthentication()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> availabilityZones = new SdkInternalList();
        private String dbClusterIdentifier;
        private String snapshotIdentifier;
        private String engine;
        private String engineVersion;
        private Integer port;
        private String dbSubnetGroupName;
        private String databaseName;
        private String optionGroupName;
        private List<String> vpcSecurityGroupIds = new SdkInternalList();
        private List<Tag> tags = new SdkInternalList();
        private String kmsKeyId;
        private Boolean enableIAMDatabaseAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDBClusterFromSnapshotRequest model) {
            this.setAvailabilityZones(model.availabilityZones);
            this.setDBClusterIdentifier(model.dbClusterIdentifier);
            this.setSnapshotIdentifier(model.snapshotIdentifier);
            this.setEngine(model.engine);
            this.setEngineVersion(model.engineVersion);
            this.setPort(model.port);
            this.setDBSubnetGroupName(model.dbSubnetGroupName);
            this.setDatabaseName(model.databaseName);
            this.setOptionGroupName(model.optionGroupName);
            this.setVpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.setTags(model.tags);
            this.setKmsKeyId(model.kmsKeyId);
            this.setEnableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            if (this.availabilityZones == null) {
                this.availabilityZones = new SdkInternalList(availabilityZones.length);
            }
            for (String e : availabilityZones) {
                this.availabilityZones.add(e);
            }
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @SafeVarargs
        public final void setAvailabilityZones(String ... availabilityZones) {
            if (this.availabilityZones == null) {
                this.availabilityZones = new SdkInternalList(availabilityZones.length);
            }
            for (String e : availabilityZones) {
                this.availabilityZones.add(e);
            }
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDBSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDBSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            if (this.vpcSecurityGroupIds == null) {
                this.vpcSecurityGroupIds = new SdkInternalList(vpcSecurityGroupIds.length);
            }
            for (String e : vpcSecurityGroupIds) {
                this.vpcSecurityGroupIds.add(e);
            }
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @SafeVarargs
        public final void setVpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            if (this.vpcSecurityGroupIds == null) {
                this.vpcSecurityGroupIds = new SdkInternalList(vpcSecurityGroupIds.length);
            }
            for (String e : vpcSecurityGroupIds) {
                this.vpcSecurityGroupIds.add(e);
            }
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public RestoreDBClusterFromSnapshotRequest build() {
            return new RestoreDBClusterFromSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RestoreDBClusterFromSnapshotRequest> {
        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder snapshotIdentifier(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder port(Integer var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder databaseName(String var1);

        public Builder optionGroupName(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder kmsKeyId(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);
    }
}

