/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PurchaseReservedDBInstancesOfferingRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PurchaseReservedDBInstancesOfferingRequest> {
    private final String reservedDBInstancesOfferingId;
    private final String reservedDBInstanceId;
    private final Integer dbInstanceCount;
    private final List<Tag> tags;

    private PurchaseReservedDBInstancesOfferingRequest(BuilderImpl builder) {
        this.reservedDBInstancesOfferingId = builder.reservedDBInstancesOfferingId;
        this.reservedDBInstanceId = builder.reservedDBInstanceId;
        this.dbInstanceCount = builder.dbInstanceCount;
        this.tags = builder.tags;
    }

    public String reservedDBInstancesOfferingId() {
        return this.reservedDBInstancesOfferingId;
    }

    public String reservedDBInstanceId() {
        return this.reservedDBInstanceId;
    }

    public Integer dbInstanceCount() {
        return this.dbInstanceCount;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reservedDBInstancesOfferingId() == null ? 0 : this.reservedDBInstancesOfferingId().hashCode());
        hashCode = 31 * hashCode + (this.reservedDBInstanceId() == null ? 0 : this.reservedDBInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.dbInstanceCount() == null ? 0 : this.dbInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedDBInstancesOfferingRequest)) {
            return false;
        }
        PurchaseReservedDBInstancesOfferingRequest other = (PurchaseReservedDBInstancesOfferingRequest)((Object)obj);
        if (other.reservedDBInstancesOfferingId() == null ^ this.reservedDBInstancesOfferingId() == null) {
            return false;
        }
        if (other.reservedDBInstancesOfferingId() != null && !other.reservedDBInstancesOfferingId().equals(this.reservedDBInstancesOfferingId())) {
            return false;
        }
        if (other.reservedDBInstanceId() == null ^ this.reservedDBInstanceId() == null) {
            return false;
        }
        if (other.reservedDBInstanceId() != null && !other.reservedDBInstanceId().equals(this.reservedDBInstanceId())) {
            return false;
        }
        if (other.dbInstanceCount() == null ^ this.dbInstanceCount() == null) {
            return false;
        }
        if (other.dbInstanceCount() != null && !other.dbInstanceCount().equals(this.dbInstanceCount())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.reservedDBInstancesOfferingId() != null) {
            sb.append("ReservedDBInstancesOfferingId: ").append(this.reservedDBInstancesOfferingId()).append(",");
        }
        if (this.reservedDBInstanceId() != null) {
            sb.append("ReservedDBInstanceId: ").append(this.reservedDBInstanceId()).append(",");
        }
        if (this.dbInstanceCount() != null) {
            sb.append("DBInstanceCount: ").append(this.dbInstanceCount()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String reservedDBInstancesOfferingId;
        private String reservedDBInstanceId;
        private Integer dbInstanceCount;
        private List<Tag> tags = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedDBInstancesOfferingRequest model) {
            this.setReservedDBInstancesOfferingId(model.reservedDBInstancesOfferingId);
            this.setReservedDBInstanceId(model.reservedDBInstanceId);
            this.setDBInstanceCount(model.dbInstanceCount);
            this.setTags(model.tags);
        }

        public final String getReservedDBInstancesOfferingId() {
            return this.reservedDBInstancesOfferingId;
        }

        @Override
        public final Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
            return this;
        }

        public final void setReservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
        }

        public final String getReservedDBInstanceId() {
            return this.reservedDBInstanceId;
        }

        @Override
        public final Builder reservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
            return this;
        }

        public final void setReservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
        }

        public final Integer getDBInstanceCount() {
            return this.dbInstanceCount;
        }

        @Override
        public final Builder dbInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
            return this;
        }

        public final void setDBInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public PurchaseReservedDBInstancesOfferingRequest build() {
            return new PurchaseReservedDBInstancesOfferingRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PurchaseReservedDBInstancesOfferingRequest> {
        public Builder reservedDBInstancesOfferingId(String var1);

        public Builder reservedDBInstanceId(String var1);

        public Builder dbInstanceCount(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

