/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.rds.model.AttributeValueListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyDBClusterSnapshotAttributeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyDBClusterSnapshotAttributeRequest> {
    private final String dbClusterSnapshotIdentifier;
    private final String attributeName;
    private final List<String> valuesToAdd;
    private final List<String> valuesToRemove;

    private ModifyDBClusterSnapshotAttributeRequest(BuilderImpl builder) {
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.attributeName = builder.attributeName;
        this.valuesToAdd = builder.valuesToAdd;
        this.valuesToRemove = builder.valuesToRemove;
    }

    public String dbClusterSnapshotIdentifier() {
        return this.dbClusterSnapshotIdentifier;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public List<String> valuesToAdd() {
        return this.valuesToAdd;
    }

    public List<String> valuesToRemove() {
        return this.valuesToRemove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbClusterSnapshotIdentifier() == null ? 0 : this.dbClusterSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.attributeName() == null ? 0 : this.attributeName().hashCode());
        hashCode = 31 * hashCode + (this.valuesToAdd() == null ? 0 : this.valuesToAdd().hashCode());
        hashCode = 31 * hashCode + (this.valuesToRemove() == null ? 0 : this.valuesToRemove().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDBClusterSnapshotAttributeRequest)) {
            return false;
        }
        ModifyDBClusterSnapshotAttributeRequest other = (ModifyDBClusterSnapshotAttributeRequest)((Object)obj);
        if (other.dbClusterSnapshotIdentifier() == null ^ this.dbClusterSnapshotIdentifier() == null) {
            return false;
        }
        if (other.dbClusterSnapshotIdentifier() != null && !other.dbClusterSnapshotIdentifier().equals(this.dbClusterSnapshotIdentifier())) {
            return false;
        }
        if (other.attributeName() == null ^ this.attributeName() == null) {
            return false;
        }
        if (other.attributeName() != null && !other.attributeName().equals(this.attributeName())) {
            return false;
        }
        if (other.valuesToAdd() == null ^ this.valuesToAdd() == null) {
            return false;
        }
        if (other.valuesToAdd() != null && !other.valuesToAdd().equals(this.valuesToAdd())) {
            return false;
        }
        if (other.valuesToRemove() == null ^ this.valuesToRemove() == null) {
            return false;
        }
        return other.valuesToRemove() == null || other.valuesToRemove().equals(this.valuesToRemove());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbClusterSnapshotIdentifier() != null) {
            sb.append("DBClusterSnapshotIdentifier: ").append(this.dbClusterSnapshotIdentifier()).append(",");
        }
        if (this.attributeName() != null) {
            sb.append("AttributeName: ").append(this.attributeName()).append(",");
        }
        if (this.valuesToAdd() != null) {
            sb.append("ValuesToAdd: ").append(this.valuesToAdd()).append(",");
        }
        if (this.valuesToRemove() != null) {
            sb.append("ValuesToRemove: ").append(this.valuesToRemove()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbClusterSnapshotIdentifier;
        private String attributeName;
        private List<String> valuesToAdd = new SdkInternalList();
        private List<String> valuesToRemove = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDBClusterSnapshotAttributeRequest model) {
            this.setDBClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            this.setAttributeName(model.attributeName);
            this.setValuesToAdd(model.valuesToAdd);
            this.setValuesToRemove(model.valuesToRemove);
        }

        public final String getDBClusterSnapshotIdentifier() {
            return this.dbClusterSnapshotIdentifier;
        }

        @Override
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final void setDBClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final Collection<String> getValuesToAdd() {
            return this.valuesToAdd;
        }

        @Override
        public final Builder valuesToAdd(Collection<String> valuesToAdd) {
            this.valuesToAdd = AttributeValueListCopier.copy(valuesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesToAdd(String ... valuesToAdd) {
            if (this.valuesToAdd == null) {
                this.valuesToAdd = new SdkInternalList(valuesToAdd.length);
            }
            for (String e : valuesToAdd) {
                this.valuesToAdd.add(e);
            }
            return this;
        }

        public final void setValuesToAdd(Collection<String> valuesToAdd) {
            this.valuesToAdd = AttributeValueListCopier.copy(valuesToAdd);
        }

        @SafeVarargs
        public final void setValuesToAdd(String ... valuesToAdd) {
            if (this.valuesToAdd == null) {
                this.valuesToAdd = new SdkInternalList(valuesToAdd.length);
            }
            for (String e : valuesToAdd) {
                this.valuesToAdd.add(e);
            }
        }

        public final Collection<String> getValuesToRemove() {
            return this.valuesToRemove;
        }

        @Override
        public final Builder valuesToRemove(Collection<String> valuesToRemove) {
            this.valuesToRemove = AttributeValueListCopier.copy(valuesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesToRemove(String ... valuesToRemove) {
            if (this.valuesToRemove == null) {
                this.valuesToRemove = new SdkInternalList(valuesToRemove.length);
            }
            for (String e : valuesToRemove) {
                this.valuesToRemove.add(e);
            }
            return this;
        }

        public final void setValuesToRemove(Collection<String> valuesToRemove) {
            this.valuesToRemove = AttributeValueListCopier.copy(valuesToRemove);
        }

        @SafeVarargs
        public final void setValuesToRemove(String ... valuesToRemove) {
            if (this.valuesToRemove == null) {
                this.valuesToRemove = new SdkInternalList(valuesToRemove.length);
            }
            for (String e : valuesToRemove) {
                this.valuesToRemove.add(e);
            }
        }

        public ModifyDBClusterSnapshotAttributeRequest build() {
            return new ModifyDBClusterSnapshotAttributeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyDBClusterSnapshotAttributeRequest> {
        public Builder dbClusterSnapshotIdentifier(String var1);

        public Builder attributeName(String var1);

        public Builder valuesToAdd(Collection<String> var1);

        public Builder valuesToAdd(String ... var1);

        public Builder valuesToRemove(Collection<String> var1);

        public Builder valuesToRemove(String ... var1);
    }
}

