/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rbin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rbin.model.LockConfiguration;
import software.amazon.awssdk.services.rbin.model.RbinRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LockRuleRequest
extends RbinRequest
implements ToCopyableBuilder<Builder, LockRuleRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(LockRuleRequest.getter(LockRuleRequest::identifier)).setter(LockRuleRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<LockConfiguration> LOCK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LockConfiguration").getter(LockRuleRequest.getter(LockRuleRequest::lockConfiguration)).setter(LockRuleRequest.setter(Builder::lockConfiguration)).constructor(LockConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, LOCK_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("identifier", IDENTIFIER_FIELD);
            this.put("LockConfiguration", LOCK_CONFIGURATION_FIELD);
        }
    });
    private final String identifier;
    private final LockConfiguration lockConfiguration;

    private LockRuleRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.lockConfiguration = builder.lockConfiguration;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final LockConfiguration lockConfiguration() {
        return this.lockConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LockRuleRequest)) {
            return false;
        }
        LockRuleRequest other = (LockRuleRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.lockConfiguration(), other.lockConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"LockRuleRequest").add("Identifier", (Object)this.identifier()).add("LockConfiguration", (Object)this.lockConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "LockConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lockConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LockRuleRequest, T> g) {
        return obj -> g.apply((LockRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RbinRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private LockConfiguration lockConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LockRuleRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.lockConfiguration(model.lockConfiguration);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final LockConfiguration.Builder getLockConfiguration() {
            return this.lockConfiguration != null ? this.lockConfiguration.toBuilder() : null;
        }

        public final void setLockConfiguration(LockConfiguration.BuilderImpl lockConfiguration) {
            this.lockConfiguration = lockConfiguration != null ? lockConfiguration.build() : null;
        }

        @Override
        public final Builder lockConfiguration(LockConfiguration lockConfiguration) {
            this.lockConfiguration = lockConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public LockRuleRequest build() {
            return new LockRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RbinRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, LockRuleRequest> {
        public Builder identifier(String var1);

        public Builder lockConfiguration(LockConfiguration var1);

        default public Builder lockConfiguration(Consumer<LockConfiguration.Builder> lockConfiguration) {
            return this.lockConfiguration((LockConfiguration)((LockConfiguration.Builder)LockConfiguration.builder().applyMutation(lockConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

