/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rbin;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.rbin.DefaultRbinClientBuilder;
import software.amazon.awssdk.services.rbin.RbinClientBuilder;
import software.amazon.awssdk.services.rbin.model.ConflictException;
import software.amazon.awssdk.services.rbin.model.CreateRuleRequest;
import software.amazon.awssdk.services.rbin.model.CreateRuleResponse;
import software.amazon.awssdk.services.rbin.model.DeleteRuleRequest;
import software.amazon.awssdk.services.rbin.model.DeleteRuleResponse;
import software.amazon.awssdk.services.rbin.model.GetRuleRequest;
import software.amazon.awssdk.services.rbin.model.GetRuleResponse;
import software.amazon.awssdk.services.rbin.model.InternalServerException;
import software.amazon.awssdk.services.rbin.model.ListRulesRequest;
import software.amazon.awssdk.services.rbin.model.ListRulesResponse;
import software.amazon.awssdk.services.rbin.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.rbin.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.rbin.model.LockRuleRequest;
import software.amazon.awssdk.services.rbin.model.LockRuleResponse;
import software.amazon.awssdk.services.rbin.model.RbinException;
import software.amazon.awssdk.services.rbin.model.ResourceNotFoundException;
import software.amazon.awssdk.services.rbin.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.rbin.model.TagResourceRequest;
import software.amazon.awssdk.services.rbin.model.TagResourceResponse;
import software.amazon.awssdk.services.rbin.model.UnlockRuleRequest;
import software.amazon.awssdk.services.rbin.model.UnlockRuleResponse;
import software.amazon.awssdk.services.rbin.model.UntagResourceRequest;
import software.amazon.awssdk.services.rbin.model.UntagResourceResponse;
import software.amazon.awssdk.services.rbin.model.UpdateRuleRequest;
import software.amazon.awssdk.services.rbin.model.UpdateRuleResponse;
import software.amazon.awssdk.services.rbin.model.ValidationException;
import software.amazon.awssdk.services.rbin.paginators.ListRulesIterable;

@SdkPublicApi
@ThreadSafe
public interface RbinClient
extends SdkClient {
    public static final String SERVICE_NAME = "rbin";
    public static final String SERVICE_METADATA_ID = "rbin";

    public static RbinClient create() {
        return (RbinClient)RbinClient.builder().build();
    }

    public static RbinClientBuilder builder() {
        return new DefaultRbinClientBuilder();
    }

    default public CreateRuleResponse createRule(CreateRuleRequest createRuleRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, RbinException {
        throw new UnsupportedOperationException();
    }

    default public CreateRuleResponse createRule(Consumer<CreateRuleRequest.Builder> createRuleRequest) throws ValidationException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, RbinException {
        return this.createRule((CreateRuleRequest)((Object)((CreateRuleRequest.Builder)CreateRuleRequest.builder().applyMutation(createRuleRequest)).build()));
    }

    default public DeleteRuleResponse deleteRule(DeleteRuleRequest deleteRuleRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, RbinException {
        throw new UnsupportedOperationException();
    }

    default public DeleteRuleResponse deleteRule(Consumer<DeleteRuleRequest.Builder> deleteRuleRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, RbinException {
        return this.deleteRule((DeleteRuleRequest)((Object)((DeleteRuleRequest.Builder)DeleteRuleRequest.builder().applyMutation(deleteRuleRequest)).build()));
    }

    default public GetRuleResponse getRule(GetRuleRequest getRuleRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, RbinException {
        throw new UnsupportedOperationException();
    }

    default public GetRuleResponse getRule(Consumer<GetRuleRequest.Builder> getRuleRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, RbinException {
        return this.getRule((GetRuleRequest)((Object)((GetRuleRequest.Builder)GetRuleRequest.builder().applyMutation(getRuleRequest)).build()));
    }

    default public ListRulesResponse listRules(ListRulesRequest listRulesRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, RbinException {
        throw new UnsupportedOperationException();
    }

    default public ListRulesResponse listRules(Consumer<ListRulesRequest.Builder> listRulesRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, RbinException {
        return this.listRules((ListRulesRequest)((Object)((ListRulesRequest.Builder)ListRulesRequest.builder().applyMutation(listRulesRequest)).build()));
    }

    default public ListRulesIterable listRulesPaginator(ListRulesRequest listRulesRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, RbinException {
        throw new UnsupportedOperationException();
    }

    default public ListRulesIterable listRulesPaginator(Consumer<ListRulesRequest.Builder> listRulesRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, RbinException {
        return this.listRulesPaginator((ListRulesRequest)((Object)((ListRulesRequest.Builder)ListRulesRequest.builder().applyMutation(listRulesRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, RbinException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, RbinException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public LockRuleResponse lockRule(LockRuleRequest lockRuleRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, RbinException {
        throw new UnsupportedOperationException();
    }

    default public LockRuleResponse lockRule(Consumer<LockRuleRequest.Builder> lockRuleRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, RbinException {
        return this.lockRule((LockRuleRequest)((Object)((LockRuleRequest.Builder)LockRuleRequest.builder().applyMutation(lockRuleRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, RbinException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, RbinException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UnlockRuleResponse unlockRule(UnlockRuleRequest unlockRuleRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, RbinException {
        throw new UnsupportedOperationException();
    }

    default public UnlockRuleResponse unlockRule(Consumer<UnlockRuleRequest.Builder> unlockRuleRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, RbinException {
        return this.unlockRule((UnlockRuleRequest)((Object)((UnlockRuleRequest.Builder)UnlockRuleRequest.builder().applyMutation(unlockRuleRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, RbinException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, RbinException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateRuleResponse updateRule(UpdateRuleRequest updateRuleRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, RbinException {
        throw new UnsupportedOperationException();
    }

    default public UpdateRuleResponse updateRule(Consumer<UpdateRuleRequest.Builder> updateRuleRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, RbinException {
        return this.updateRule((UpdateRuleRequest)((Object)((UpdateRuleRequest.Builder)UpdateRuleRequest.builder().applyMutation(updateRuleRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"rbin");
    }
}

