/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamClient;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse;

public class GetResourceShareInvitationsIterable
implements SdkIterable<GetResourceShareInvitationsResponse> {
    private final RamClient client;
    private final GetResourceShareInvitationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetResourceShareInvitationsIterable(RamClient client, GetResourceShareInvitationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetResourceShareInvitationsResponseFetcher();
    }

    public Iterator<GetResourceShareInvitationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetResourceShareInvitationsIterable resume(GetResourceShareInvitationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetResourceShareInvitationsIterable(this.client, (GetResourceShareInvitationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetResourceShareInvitationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetResourceShareInvitationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetResourceShareInvitationsResponseFetcher
    implements SyncPageFetcher<GetResourceShareInvitationsResponse> {
        private GetResourceShareInvitationsResponseFetcher() {
        }

        public boolean hasNextPage(GetResourceShareInvitationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetResourceShareInvitationsResponse nextPage(GetResourceShareInvitationsResponse previousPage) {
            if (previousPage == null) {
                return GetResourceShareInvitationsIterable.this.client.getResourceShareInvitations(GetResourceShareInvitationsIterable.this.firstRequest);
            }
            return GetResourceShareInvitationsIterable.this.client.getResourceShareInvitations((GetResourceShareInvitationsRequest)((Object)GetResourceShareInvitationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

