/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceRegionScope {
    REGIONAL("REGIONAL"),
    GLOBAL("GLOBAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceRegionScope> VALUE_MAP;
    private final String value;

    private ResourceRegionScope(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceRegionScope fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceRegionScope> knownValues() {
        EnumSet<ResourceRegionScope> knownValues = EnumSet.allOf(ResourceRegionScope.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceRegionScope.class, ResourceRegionScope::toString);
    }
}

