/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.ResourceShareAssociation;
import software.amazon.awssdk.services.ram.model.ResourceShareAssociationListCopier;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceShareInvitation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceShareInvitation> {
    private static final SdkField<String> RESOURCE_SHARE_INVITATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceShareInvitationArn").getter(ResourceShareInvitation.getter(ResourceShareInvitation::resourceShareInvitationArn)).setter(ResourceShareInvitation.setter(Builder::resourceShareInvitationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareInvitationArn").build()}).build();
    private static final SdkField<String> RESOURCE_SHARE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceShareName").getter(ResourceShareInvitation.getter(ResourceShareInvitation::resourceShareName)).setter(ResourceShareInvitation.setter(Builder::resourceShareName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareName").build()}).build();
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceShareArn").getter(ResourceShareInvitation.getter(ResourceShareInvitation::resourceShareArn)).setter(ResourceShareInvitation.setter(Builder::resourceShareArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()}).build();
    private static final SdkField<String> SENDER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("senderAccountId").getter(ResourceShareInvitation.getter(ResourceShareInvitation::senderAccountId)).setter(ResourceShareInvitation.setter(Builder::senderAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderAccountId").build()}).build();
    private static final SdkField<String> RECEIVER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("receiverAccountId").getter(ResourceShareInvitation.getter(ResourceShareInvitation::receiverAccountId)).setter(ResourceShareInvitation.setter(Builder::receiverAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("receiverAccountId").build()}).build();
    private static final SdkField<Instant> INVITATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("invitationTimestamp").getter(ResourceShareInvitation.getter(ResourceShareInvitation::invitationTimestamp)).setter(ResourceShareInvitation.setter(Builder::invitationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invitationTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ResourceShareInvitation.getter(ResourceShareInvitation::statusAsString)).setter(ResourceShareInvitation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<ResourceShareAssociation>> RESOURCE_SHARE_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceShareAssociations").getter(ResourceShareInvitation.getter(ResourceShareInvitation::resourceShareAssociations)).setter(ResourceShareInvitation.setter(Builder::resourceShareAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceShareAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECEIVER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("receiverArn").getter(ResourceShareInvitation.getter(ResourceShareInvitation::receiverArn)).setter(ResourceShareInvitation.setter(Builder::receiverArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("receiverArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_INVITATION_ARN_FIELD, RESOURCE_SHARE_NAME_FIELD, RESOURCE_SHARE_ARN_FIELD, SENDER_ACCOUNT_ID_FIELD, RECEIVER_ACCOUNT_ID_FIELD, INVITATION_TIMESTAMP_FIELD, STATUS_FIELD, RESOURCE_SHARE_ASSOCIATIONS_FIELD, RECEIVER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceShareInvitation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceShareInvitationArn;
    private final String resourceShareName;
    private final String resourceShareArn;
    private final String senderAccountId;
    private final String receiverAccountId;
    private final Instant invitationTimestamp;
    private final String status;
    private final List<ResourceShareAssociation> resourceShareAssociations;
    private final String receiverArn;

    private ResourceShareInvitation(BuilderImpl builder) {
        this.resourceShareInvitationArn = builder.resourceShareInvitationArn;
        this.resourceShareName = builder.resourceShareName;
        this.resourceShareArn = builder.resourceShareArn;
        this.senderAccountId = builder.senderAccountId;
        this.receiverAccountId = builder.receiverAccountId;
        this.invitationTimestamp = builder.invitationTimestamp;
        this.status = builder.status;
        this.resourceShareAssociations = builder.resourceShareAssociations;
        this.receiverArn = builder.receiverArn;
    }

    public final String resourceShareInvitationArn() {
        return this.resourceShareInvitationArn;
    }

    public final String resourceShareName() {
        return this.resourceShareName;
    }

    public final String resourceShareArn() {
        return this.resourceShareArn;
    }

    public final String senderAccountId() {
        return this.senderAccountId;
    }

    public final String receiverAccountId() {
        return this.receiverAccountId;
    }

    public final Instant invitationTimestamp() {
        return this.invitationTimestamp;
    }

    public final ResourceShareInvitationStatus status() {
        return ResourceShareInvitationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Deprecated
    public final boolean hasResourceShareAssociations() {
        return this.resourceShareAssociations != null && !(this.resourceShareAssociations instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<ResourceShareAssociation> resourceShareAssociations() {
        return this.resourceShareAssociations;
    }

    public final String receiverArn() {
        return this.receiverArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareInvitationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiverAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceShareAssociations() ? this.resourceShareAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.receiverArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceShareInvitation)) {
            return false;
        }
        ResourceShareInvitation other = (ResourceShareInvitation)obj;
        return Objects.equals(this.resourceShareInvitationArn(), other.resourceShareInvitationArn()) && Objects.equals(this.resourceShareName(), other.resourceShareName()) && Objects.equals(this.resourceShareArn(), other.resourceShareArn()) && Objects.equals(this.senderAccountId(), other.senderAccountId()) && Objects.equals(this.receiverAccountId(), other.receiverAccountId()) && Objects.equals(this.invitationTimestamp(), other.invitationTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasResourceShareAssociations() == other.hasResourceShareAssociations() && Objects.equals(this.resourceShareAssociations(), other.resourceShareAssociations()) && Objects.equals(this.receiverArn(), other.receiverArn());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceShareInvitation").add("ResourceShareInvitationArn", (Object)this.resourceShareInvitationArn()).add("ResourceShareName", (Object)this.resourceShareName()).add("ResourceShareArn", (Object)this.resourceShareArn()).add("SenderAccountId", (Object)this.senderAccountId()).add("ReceiverAccountId", (Object)this.receiverAccountId()).add("InvitationTimestamp", (Object)this.invitationTimestamp()).add("Status", (Object)this.statusAsString()).add("ResourceShareAssociations", this.hasResourceShareAssociations() ? this.resourceShareAssociations() : null).add("ReceiverArn", (Object)this.receiverArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareInvitationArn": {
                return Optional.ofNullable(clazz.cast(this.resourceShareInvitationArn()));
            }
            case "resourceShareName": {
                return Optional.ofNullable(clazz.cast(this.resourceShareName()));
            }
            case "resourceShareArn": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArn()));
            }
            case "senderAccountId": {
                return Optional.ofNullable(clazz.cast(this.senderAccountId()));
            }
            case "receiverAccountId": {
                return Optional.ofNullable(clazz.cast(this.receiverAccountId()));
            }
            case "invitationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.invitationTimestamp()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "resourceShareAssociations": {
                return Optional.ofNullable(clazz.cast(this.resourceShareAssociations()));
            }
            case "receiverArn": {
                return Optional.ofNullable(clazz.cast(this.receiverArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceShareInvitationArn", RESOURCE_SHARE_INVITATION_ARN_FIELD);
        map.put("resourceShareName", RESOURCE_SHARE_NAME_FIELD);
        map.put("resourceShareArn", RESOURCE_SHARE_ARN_FIELD);
        map.put("senderAccountId", SENDER_ACCOUNT_ID_FIELD);
        map.put("receiverAccountId", RECEIVER_ACCOUNT_ID_FIELD);
        map.put("invitationTimestamp", INVITATION_TIMESTAMP_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("resourceShareAssociations", RESOURCE_SHARE_ASSOCIATIONS_FIELD);
        map.put("receiverArn", RECEIVER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceShareInvitation, T> g) {
        return obj -> g.apply((ResourceShareInvitation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceShareInvitationArn;
        private String resourceShareName;
        private String resourceShareArn;
        private String senderAccountId;
        private String receiverAccountId;
        private Instant invitationTimestamp;
        private String status;
        private List<ResourceShareAssociation> resourceShareAssociations = DefaultSdkAutoConstructList.getInstance();
        private String receiverArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceShareInvitation model) {
            this.resourceShareInvitationArn(model.resourceShareInvitationArn);
            this.resourceShareName(model.resourceShareName);
            this.resourceShareArn(model.resourceShareArn);
            this.senderAccountId(model.senderAccountId);
            this.receiverAccountId(model.receiverAccountId);
            this.invitationTimestamp(model.invitationTimestamp);
            this.status(model.status);
            this.resourceShareAssociations(model.resourceShareAssociations);
            this.receiverArn(model.receiverArn);
        }

        public final String getResourceShareInvitationArn() {
            return this.resourceShareInvitationArn;
        }

        public final void setResourceShareInvitationArn(String resourceShareInvitationArn) {
            this.resourceShareInvitationArn = resourceShareInvitationArn;
        }

        @Override
        public final Builder resourceShareInvitationArn(String resourceShareInvitationArn) {
            this.resourceShareInvitationArn = resourceShareInvitationArn;
            return this;
        }

        public final String getResourceShareName() {
            return this.resourceShareName;
        }

        public final void setResourceShareName(String resourceShareName) {
            this.resourceShareName = resourceShareName;
        }

        @Override
        public final Builder resourceShareName(String resourceShareName) {
            this.resourceShareName = resourceShareName;
            return this;
        }

        public final String getResourceShareArn() {
            return this.resourceShareArn;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final String getSenderAccountId() {
            return this.senderAccountId;
        }

        public final void setSenderAccountId(String senderAccountId) {
            this.senderAccountId = senderAccountId;
        }

        @Override
        public final Builder senderAccountId(String senderAccountId) {
            this.senderAccountId = senderAccountId;
            return this;
        }

        public final String getReceiverAccountId() {
            return this.receiverAccountId;
        }

        public final void setReceiverAccountId(String receiverAccountId) {
            this.receiverAccountId = receiverAccountId;
        }

        @Override
        public final Builder receiverAccountId(String receiverAccountId) {
            this.receiverAccountId = receiverAccountId;
            return this;
        }

        public final Instant getInvitationTimestamp() {
            return this.invitationTimestamp;
        }

        public final void setInvitationTimestamp(Instant invitationTimestamp) {
            this.invitationTimestamp = invitationTimestamp;
        }

        @Override
        public final Builder invitationTimestamp(Instant invitationTimestamp) {
            this.invitationTimestamp = invitationTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceShareInvitationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Deprecated
        public final List<ResourceShareAssociation.Builder> getResourceShareAssociations() {
            List<ResourceShareAssociation.Builder> result = ResourceShareAssociationListCopier.copyToBuilder(this.resourceShareAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setResourceShareAssociations(Collection<ResourceShareAssociation.BuilderImpl> resourceShareAssociations) {
            this.resourceShareAssociations = ResourceShareAssociationListCopier.copyFromBuilder(resourceShareAssociations);
        }

        @Override
        @Deprecated
        public final Builder resourceShareAssociations(Collection<ResourceShareAssociation> resourceShareAssociations) {
            this.resourceShareAssociations = ResourceShareAssociationListCopier.copy(resourceShareAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder resourceShareAssociations(ResourceShareAssociation ... resourceShareAssociations) {
            this.resourceShareAssociations(Arrays.asList(resourceShareAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder resourceShareAssociations(Consumer<ResourceShareAssociation.Builder> ... resourceShareAssociations) {
            this.resourceShareAssociations(Stream.of(resourceShareAssociations).map(c -> (ResourceShareAssociation)((ResourceShareAssociation.Builder)ResourceShareAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReceiverArn() {
            return this.receiverArn;
        }

        public final void setReceiverArn(String receiverArn) {
            this.receiverArn = receiverArn;
        }

        @Override
        public final Builder receiverArn(String receiverArn) {
            this.receiverArn = receiverArn;
            return this;
        }

        public ResourceShareInvitation build() {
            return new ResourceShareInvitation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceShareInvitation> {
        public Builder resourceShareInvitationArn(String var1);

        public Builder resourceShareName(String var1);

        public Builder resourceShareArn(String var1);

        public Builder senderAccountId(String var1);

        public Builder receiverAccountId(String var1);

        public Builder invitationTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(ResourceShareInvitationStatus var1);

        @Deprecated
        public Builder resourceShareAssociations(Collection<ResourceShareAssociation> var1);

        @Deprecated
        public Builder resourceShareAssociations(ResourceShareAssociation ... var1);

        @Deprecated
        public Builder resourceShareAssociations(Consumer<ResourceShareAssociation.Builder> ... var1);

        public Builder receiverArn(String var1);
    }
}

