/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.PermissionFeatureSet;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.services.ram.model.ResourceShareAssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPermissionAssociationsRequest
extends RamRequest
implements ToCopyableBuilder<Builder, ListPermissionAssociationsRequest> {
    private static final SdkField<String> PERMISSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permissionArn").getter(ListPermissionAssociationsRequest.getter(ListPermissionAssociationsRequest::permissionArn)).setter(ListPermissionAssociationsRequest.setter(Builder::permissionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionArn").build()}).build();
    private static final SdkField<Integer> PERMISSION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("permissionVersion").getter(ListPermissionAssociationsRequest.getter(ListPermissionAssociationsRequest::permissionVersion)).setter(ListPermissionAssociationsRequest.setter(Builder::permissionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionVersion").build()}).build();
    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationStatus").getter(ListPermissionAssociationsRequest.getter(ListPermissionAssociationsRequest::associationStatusAsString)).setter(ListPermissionAssociationsRequest.setter(Builder::associationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationStatus").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ListPermissionAssociationsRequest.getter(ListPermissionAssociationsRequest::resourceType)).setter(ListPermissionAssociationsRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> FEATURE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("featureSet").getter(ListPermissionAssociationsRequest.getter(ListPermissionAssociationsRequest::featureSetAsString)).setter(ListPermissionAssociationsRequest.setter(Builder::featureSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureSet").build()}).build();
    private static final SdkField<Boolean> DEFAULT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("defaultVersion").getter(ListPermissionAssociationsRequest.getter(ListPermissionAssociationsRequest::defaultVersion)).setter(ListPermissionAssociationsRequest.setter(Builder::defaultVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersion").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPermissionAssociationsRequest.getter(ListPermissionAssociationsRequest::nextToken)).setter(ListPermissionAssociationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListPermissionAssociationsRequest.getter(ListPermissionAssociationsRequest::maxResults)).setter(ListPermissionAssociationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_ARN_FIELD, PERMISSION_VERSION_FIELD, ASSOCIATION_STATUS_FIELD, RESOURCE_TYPE_FIELD, FEATURE_SET_FIELD, DEFAULT_VERSION_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPermissionAssociationsRequest.memberNameToFieldInitializer();
    private final String permissionArn;
    private final Integer permissionVersion;
    private final String associationStatus;
    private final String resourceType;
    private final String featureSet;
    private final Boolean defaultVersion;
    private final String nextToken;
    private final Integer maxResults;

    private ListPermissionAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.permissionArn = builder.permissionArn;
        this.permissionVersion = builder.permissionVersion;
        this.associationStatus = builder.associationStatus;
        this.resourceType = builder.resourceType;
        this.featureSet = builder.featureSet;
        this.defaultVersion = builder.defaultVersion;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String permissionArn() {
        return this.permissionArn;
    }

    public final Integer permissionVersion() {
        return this.permissionVersion;
    }

    public final ResourceShareAssociationStatus associationStatus() {
        return ResourceShareAssociationStatus.fromValue(this.associationStatus);
    }

    public final String associationStatusAsString() {
        return this.associationStatus;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final PermissionFeatureSet featureSet() {
        return PermissionFeatureSet.fromValue(this.featureSet);
    }

    public final String featureSetAsString() {
        return this.featureSet;
    }

    public final Boolean defaultVersion() {
        return this.defaultVersion;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureSetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionAssociationsRequest)) {
            return false;
        }
        ListPermissionAssociationsRequest other = (ListPermissionAssociationsRequest)((Object)obj);
        return Objects.equals(this.permissionArn(), other.permissionArn()) && Objects.equals(this.permissionVersion(), other.permissionVersion()) && Objects.equals(this.associationStatusAsString(), other.associationStatusAsString()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.featureSetAsString(), other.featureSetAsString()) && Objects.equals(this.defaultVersion(), other.defaultVersion()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListPermissionAssociationsRequest").add("PermissionArn", (Object)this.permissionArn()).add("PermissionVersion", (Object)this.permissionVersion()).add("AssociationStatus", (Object)this.associationStatusAsString()).add("ResourceType", (Object)this.resourceType()).add("FeatureSet", (Object)this.featureSetAsString()).add("DefaultVersion", (Object)this.defaultVersion()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "permissionArn": {
                return Optional.ofNullable(clazz.cast(this.permissionArn()));
            }
            case "permissionVersion": {
                return Optional.ofNullable(clazz.cast(this.permissionVersion()));
            }
            case "associationStatus": {
                return Optional.ofNullable(clazz.cast(this.associationStatusAsString()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "featureSet": {
                return Optional.ofNullable(clazz.cast(this.featureSetAsString()));
            }
            case "defaultVersion": {
                return Optional.ofNullable(clazz.cast(this.defaultVersion()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("permissionArn", PERMISSION_ARN_FIELD);
        map.put("permissionVersion", PERMISSION_VERSION_FIELD);
        map.put("associationStatus", ASSOCIATION_STATUS_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("featureSet", FEATURE_SET_FIELD);
        map.put("defaultVersion", DEFAULT_VERSION_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionAssociationsRequest, T> g) {
        return obj -> g.apply((ListPermissionAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private String permissionArn;
        private Integer permissionVersion;
        private String associationStatus;
        private String resourceType;
        private String featureSet;
        private Boolean defaultVersion;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionAssociationsRequest model) {
            super(model);
            this.permissionArn(model.permissionArn);
            this.permissionVersion(model.permissionVersion);
            this.associationStatus(model.associationStatus);
            this.resourceType(model.resourceType);
            this.featureSet(model.featureSet);
            this.defaultVersion(model.defaultVersion);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getPermissionArn() {
            return this.permissionArn;
        }

        public final void setPermissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
        }

        @Override
        public final Builder permissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
            return this;
        }

        public final Integer getPermissionVersion() {
            return this.permissionVersion;
        }

        public final void setPermissionVersion(Integer permissionVersion) {
            this.permissionVersion = permissionVersion;
        }

        @Override
        public final Builder permissionVersion(Integer permissionVersion) {
            this.permissionVersion = permissionVersion;
            return this;
        }

        public final String getAssociationStatus() {
            return this.associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        public final Builder associationStatus(ResourceShareAssociationStatus associationStatus) {
            this.associationStatus(associationStatus == null ? null : associationStatus.toString());
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getFeatureSet() {
            return this.featureSet;
        }

        public final void setFeatureSet(String featureSet) {
            this.featureSet = featureSet;
        }

        @Override
        public final Builder featureSet(String featureSet) {
            this.featureSet = featureSet;
            return this;
        }

        @Override
        public final Builder featureSet(PermissionFeatureSet featureSet) {
            this.featureSet(featureSet == null ? null : featureSet.toString());
            return this;
        }

        public final Boolean getDefaultVersion() {
            return this.defaultVersion;
        }

        public final void setDefaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        @Override
        public final Builder defaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPermissionAssociationsRequest build() {
            return new ListPermissionAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPermissionAssociationsRequest> {
        public Builder permissionArn(String var1);

        public Builder permissionVersion(Integer var1);

        public Builder associationStatus(String var1);

        public Builder associationStatus(ResourceShareAssociationStatus var1);

        public Builder resourceType(String var1);

        public Builder featureSet(String var1);

        public Builder featureSet(PermissionFeatureSet var1);

        public Builder defaultVersion(Boolean var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

