/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PermissionTypeFilter {
    ALL("ALL"),
    AWS_MANAGED("AWS_MANAGED"),
    CUSTOMER_MANAGED("CUSTOMER_MANAGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PermissionTypeFilter> VALUE_MAP;
    private final String value;

    private PermissionTypeFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PermissionTypeFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PermissionTypeFilter> knownValues() {
        EnumSet<PermissionTypeFilter> knownValues = EnumSet.allOf(PermissionTypeFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PermissionTypeFilter.class, PermissionTypeFilter::toString);
    }
}

