/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PermissionStatus {
    ATTACHABLE("ATTACHABLE"),
    UNATTACHABLE("UNATTACHABLE"),
    DELETING("DELETING"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PermissionStatus> VALUE_MAP;
    private final String value;

    private PermissionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PermissionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PermissionStatus> knownValues() {
        EnumSet<PermissionStatus> knownValues = EnumSet.allOf(PermissionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PermissionStatus.class, PermissionStatus::toString);
    }
}

