/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.RamResponse;
import software.amazon.awssdk.services.ram.model.ResourceShare;
import software.amazon.awssdk.services.ram.model.ResourceShareListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceSharesResponse
extends RamResponse
implements ToCopyableBuilder<Builder, GetResourceSharesResponse> {
    private static final SdkField<List<ResourceShare>> RESOURCE_SHARES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceShares").getter(GetResourceSharesResponse.getter(GetResourceSharesResponse::resourceShares)).setter(GetResourceSharesResponse.setter(Builder::resourceShares)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShares").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceShare::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetResourceSharesResponse.getter(GetResourceSharesResponse::nextToken)).setter(GetResourceSharesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourceSharesResponse.memberNameToFieldInitializer();
    private final List<ResourceShare> resourceShares;
    private final String nextToken;

    private GetResourceSharesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceShares = builder.resourceShares;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResourceShares() {
        return this.resourceShares != null && !(this.resourceShares instanceof SdkAutoConstructList);
    }

    public final List<ResourceShare> resourceShares() {
        return this.resourceShares;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceShares() ? this.resourceShares() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceSharesResponse)) {
            return false;
        }
        GetResourceSharesResponse other = (GetResourceSharesResponse)((Object)obj);
        return this.hasResourceShares() == other.hasResourceShares() && Objects.equals(this.resourceShares(), other.resourceShares()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceSharesResponse").add("ResourceShares", this.hasResourceShares() ? this.resourceShares() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShares": {
                return Optional.ofNullable(clazz.cast(this.resourceShares()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceShares", RESOURCE_SHARES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceSharesResponse, T> g) {
        return obj -> g.apply((GetResourceSharesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamResponse.BuilderImpl
    implements Builder {
        private List<ResourceShare> resourceShares = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceSharesResponse model) {
            super(model);
            this.resourceShares(model.resourceShares);
            this.nextToken(model.nextToken);
        }

        public final List<ResourceShare.Builder> getResourceShares() {
            List<ResourceShare.Builder> result = ResourceShareListCopier.copyToBuilder(this.resourceShares);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceShares(Collection<ResourceShare.BuilderImpl> resourceShares) {
            this.resourceShares = ResourceShareListCopier.copyFromBuilder(resourceShares);
        }

        @Override
        public final Builder resourceShares(Collection<ResourceShare> resourceShares) {
            this.resourceShares = ResourceShareListCopier.copy(resourceShares);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShares(ResourceShare ... resourceShares) {
            this.resourceShares(Arrays.asList(resourceShares));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShares(Consumer<ResourceShare.Builder> ... resourceShares) {
            this.resourceShares(Stream.of(resourceShares).map(c -> (ResourceShare)((ResourceShare.Builder)ResourceShare.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetResourceSharesResponse build() {
            return new GetResourceSharesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceSharesResponse> {
        public Builder resourceShares(Collection<ResourceShare> var1);

        public Builder resourceShares(ResourceShare ... var1);

        public Builder resourceShares(Consumer<ResourceShare.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

