/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamAsyncClient;
import software.amazon.awssdk.services.ram.internal.UserAgentUtils;
import software.amazon.awssdk.services.ram.model.ListPermissionVersionsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionVersionsResponse;

public class ListPermissionVersionsPublisher
implements SdkPublisher<ListPermissionVersionsResponse> {
    private final RamAsyncClient client;
    private final ListPermissionVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPermissionVersionsPublisher(RamAsyncClient client, ListPermissionVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPermissionVersionsPublisher(RamAsyncClient client, ListPermissionVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPermissionVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPermissionVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPermissionVersionsResponseFetcher
    implements AsyncPageFetcher<ListPermissionVersionsResponse> {
        private ListPermissionVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPermissionVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPermissionVersionsResponse> nextPage(ListPermissionVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionVersionsPublisher.this.client.listPermissionVersions(ListPermissionVersionsPublisher.this.firstRequest);
            }
            return ListPermissionVersionsPublisher.this.client.listPermissionVersions((ListPermissionVersionsRequest)((Object)ListPermissionVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

