/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.services.ram.model.ResourceRegionScopeFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPendingInvitationResourcesRequest
extends RamRequest
implements ToCopyableBuilder<Builder, ListPendingInvitationResourcesRequest> {
    private static final SdkField<String> RESOURCE_SHARE_INVITATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceShareInvitationArn").getter(ListPendingInvitationResourcesRequest.getter(ListPendingInvitationResourcesRequest::resourceShareInvitationArn)).setter(ListPendingInvitationResourcesRequest.setter(Builder::resourceShareInvitationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareInvitationArn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPendingInvitationResourcesRequest.getter(ListPendingInvitationResourcesRequest::nextToken)).setter(ListPendingInvitationResourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListPendingInvitationResourcesRequest.getter(ListPendingInvitationResourcesRequest::maxResults)).setter(ListPendingInvitationResourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> RESOURCE_REGION_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceRegionScope").getter(ListPendingInvitationResourcesRequest.getter(ListPendingInvitationResourcesRequest::resourceRegionScopeAsString)).setter(ListPendingInvitationResourcesRequest.setter(Builder::resourceRegionScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRegionScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_INVITATION_ARN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RESOURCE_REGION_SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceShareInvitationArn", RESOURCE_SHARE_INVITATION_ARN_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("resourceRegionScope", RESOURCE_REGION_SCOPE_FIELD);
        }
    });
    private final String resourceShareInvitationArn;
    private final String nextToken;
    private final Integer maxResults;
    private final String resourceRegionScope;

    private ListPendingInvitationResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceShareInvitationArn = builder.resourceShareInvitationArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resourceRegionScope = builder.resourceRegionScope;
    }

    public final String resourceShareInvitationArn() {
        return this.resourceShareInvitationArn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ResourceRegionScopeFilter resourceRegionScope() {
        return ResourceRegionScopeFilter.fromValue(this.resourceRegionScope);
    }

    public final String resourceRegionScopeAsString() {
        return this.resourceRegionScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareInvitationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRegionScopeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPendingInvitationResourcesRequest)) {
            return false;
        }
        ListPendingInvitationResourcesRequest other = (ListPendingInvitationResourcesRequest)((Object)obj);
        return Objects.equals(this.resourceShareInvitationArn(), other.resourceShareInvitationArn()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.resourceRegionScopeAsString(), other.resourceRegionScopeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListPendingInvitationResourcesRequest").add("ResourceShareInvitationArn", (Object)this.resourceShareInvitationArn()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ResourceRegionScope", (Object)this.resourceRegionScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareInvitationArn": {
                return Optional.ofNullable(clazz.cast(this.resourceShareInvitationArn()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "resourceRegionScope": {
                return Optional.ofNullable(clazz.cast(this.resourceRegionScopeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPendingInvitationResourcesRequest, T> g) {
        return obj -> g.apply((ListPendingInvitationResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private String resourceShareInvitationArn;
        private String nextToken;
        private Integer maxResults;
        private String resourceRegionScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPendingInvitationResourcesRequest model) {
            super(model);
            this.resourceShareInvitationArn(model.resourceShareInvitationArn);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.resourceRegionScope(model.resourceRegionScope);
        }

        public final String getResourceShareInvitationArn() {
            return this.resourceShareInvitationArn;
        }

        public final void setResourceShareInvitationArn(String resourceShareInvitationArn) {
            this.resourceShareInvitationArn = resourceShareInvitationArn;
        }

        @Override
        public final Builder resourceShareInvitationArn(String resourceShareInvitationArn) {
            this.resourceShareInvitationArn = resourceShareInvitationArn;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getResourceRegionScope() {
            return this.resourceRegionScope;
        }

        public final void setResourceRegionScope(String resourceRegionScope) {
            this.resourceRegionScope = resourceRegionScope;
        }

        @Override
        public final Builder resourceRegionScope(String resourceRegionScope) {
            this.resourceRegionScope = resourceRegionScope;
            return this;
        }

        @Override
        public final Builder resourceRegionScope(ResourceRegionScopeFilter resourceRegionScope) {
            this.resourceRegionScope(resourceRegionScope == null ? null : resourceRegionScope.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPendingInvitationResourcesRequest build() {
            return new ListPendingInvitationResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPendingInvitationResourcesRequest> {
        public Builder resourceShareInvitationArn(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder resourceRegionScope(String var1);

        public Builder resourceRegionScope(ResourceRegionScopeFilter var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

