/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.services.ram.model.ResourceOwner;
import software.amazon.awssdk.services.ram.model.ResourceShareArnListCopier;
import software.amazon.awssdk.services.ram.model.ResourceShareStatus;
import software.amazon.awssdk.services.ram.model.TagFilter;
import software.amazon.awssdk.services.ram.model.TagFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceSharesRequest
extends RamRequest
implements ToCopyableBuilder<Builder, GetResourceSharesRequest> {
    private static final SdkField<List<String>> RESOURCE_SHARE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceShareArns").getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::resourceShareArns)).setter(GetResourceSharesRequest.setter(Builder::resourceShareArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_SHARE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceShareStatus").getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::resourceShareStatusAsString)).setter(GetResourceSharesRequest.setter(Builder::resourceShareStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareStatus").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceOwner").getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::resourceOwnerAsString)).setter(GetResourceSharesRequest.setter(Builder::resourceOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwner").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::name)).setter(GetResourceSharesRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<TagFilter>> TAG_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tagFilters").getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::tagFilters)).setter(GetResourceSharesRequest.setter(Builder::tagFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::nextToken)).setter(GetResourceSharesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::maxResults)).setter(GetResourceSharesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> PERMISSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permissionArn").getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::permissionArn)).setter(GetResourceSharesRequest.setter(Builder::permissionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionArn").build()}).build();
    private static final SdkField<Integer> PERMISSION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("permissionVersion").getter(GetResourceSharesRequest.getter(GetResourceSharesRequest::permissionVersion)).setter(GetResourceSharesRequest.setter(Builder::permissionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARNS_FIELD, RESOURCE_SHARE_STATUS_FIELD, RESOURCE_OWNER_FIELD, NAME_FIELD, TAG_FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, PERMISSION_ARN_FIELD, PERMISSION_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceShareArns", RESOURCE_SHARE_ARNS_FIELD);
            this.put("resourceShareStatus", RESOURCE_SHARE_STATUS_FIELD);
            this.put("resourceOwner", RESOURCE_OWNER_FIELD);
            this.put("name", NAME_FIELD);
            this.put("tagFilters", TAG_FILTERS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("permissionArn", PERMISSION_ARN_FIELD);
            this.put("permissionVersion", PERMISSION_VERSION_FIELD);
        }
    });
    private final List<String> resourceShareArns;
    private final String resourceShareStatus;
    private final String resourceOwner;
    private final String name;
    private final List<TagFilter> tagFilters;
    private final String nextToken;
    private final Integer maxResults;
    private final String permissionArn;
    private final Integer permissionVersion;

    private GetResourceSharesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceShareArns = builder.resourceShareArns;
        this.resourceShareStatus = builder.resourceShareStatus;
        this.resourceOwner = builder.resourceOwner;
        this.name = builder.name;
        this.tagFilters = builder.tagFilters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.permissionArn = builder.permissionArn;
        this.permissionVersion = builder.permissionVersion;
    }

    public final boolean hasResourceShareArns() {
        return this.resourceShareArns != null && !(this.resourceShareArns instanceof SdkAutoConstructList);
    }

    public final List<String> resourceShareArns() {
        return this.resourceShareArns;
    }

    public final ResourceShareStatus resourceShareStatus() {
        return ResourceShareStatus.fromValue(this.resourceShareStatus);
    }

    public final String resourceShareStatusAsString() {
        return this.resourceShareStatus;
    }

    public final ResourceOwner resourceOwner() {
        return ResourceOwner.fromValue(this.resourceOwner);
    }

    public final String resourceOwnerAsString() {
        return this.resourceOwner;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTagFilters() {
        return this.tagFilters != null && !(this.tagFilters instanceof SdkAutoConstructList);
    }

    public final List<TagFilter> tagFilters() {
        return this.tagFilters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String permissionArn() {
        return this.permissionArn;
    }

    public final Integer permissionVersion() {
        return this.permissionVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceShareArns() ? this.resourceShareArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagFilters() ? this.tagFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceSharesRequest)) {
            return false;
        }
        GetResourceSharesRequest other = (GetResourceSharesRequest)((Object)obj);
        return this.hasResourceShareArns() == other.hasResourceShareArns() && Objects.equals(this.resourceShareArns(), other.resourceShareArns()) && Objects.equals(this.resourceShareStatusAsString(), other.resourceShareStatusAsString()) && Objects.equals(this.resourceOwnerAsString(), other.resourceOwnerAsString()) && Objects.equals(this.name(), other.name()) && this.hasTagFilters() == other.hasTagFilters() && Objects.equals(this.tagFilters(), other.tagFilters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.permissionArn(), other.permissionArn()) && Objects.equals(this.permissionVersion(), other.permissionVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceSharesRequest").add("ResourceShareArns", this.hasResourceShareArns() ? this.resourceShareArns() : null).add("ResourceShareStatus", (Object)this.resourceShareStatusAsString()).add("ResourceOwner", (Object)this.resourceOwnerAsString()).add("Name", (Object)this.name()).add("TagFilters", this.hasTagFilters() ? this.tagFilters() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("PermissionArn", (Object)this.permissionArn()).add("PermissionVersion", (Object)this.permissionVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareArns": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArns()));
            }
            case "resourceShareStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceShareStatusAsString()));
            }
            case "resourceOwner": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tagFilters": {
                return Optional.ofNullable(clazz.cast(this.tagFilters()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "permissionArn": {
                return Optional.ofNullable(clazz.cast(this.permissionArn()));
            }
            case "permissionVersion": {
                return Optional.ofNullable(clazz.cast(this.permissionVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceSharesRequest, T> g) {
        return obj -> g.apply((GetResourceSharesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private List<String> resourceShareArns = DefaultSdkAutoConstructList.getInstance();
        private String resourceShareStatus;
        private String resourceOwner;
        private String name;
        private List<TagFilter> tagFilters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;
        private String permissionArn;
        private Integer permissionVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceSharesRequest model) {
            super(model);
            this.resourceShareArns(model.resourceShareArns);
            this.resourceShareStatus(model.resourceShareStatus);
            this.resourceOwner(model.resourceOwner);
            this.name(model.name);
            this.tagFilters(model.tagFilters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.permissionArn(model.permissionArn);
            this.permissionVersion(model.permissionVersion);
        }

        public final Collection<String> getResourceShareArns() {
            if (this.resourceShareArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceShareArns;
        }

        public final void setResourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
        }

        @Override
        public final Builder resourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareArns(String ... resourceShareArns) {
            this.resourceShareArns(Arrays.asList(resourceShareArns));
            return this;
        }

        public final String getResourceShareStatus() {
            return this.resourceShareStatus;
        }

        public final void setResourceShareStatus(String resourceShareStatus) {
            this.resourceShareStatus = resourceShareStatus;
        }

        @Override
        public final Builder resourceShareStatus(String resourceShareStatus) {
            this.resourceShareStatus = resourceShareStatus;
            return this;
        }

        @Override
        public final Builder resourceShareStatus(ResourceShareStatus resourceShareStatus) {
            this.resourceShareStatus(resourceShareStatus == null ? null : resourceShareStatus.toString());
            return this;
        }

        public final String getResourceOwner() {
            return this.resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public final Builder resourceOwner(ResourceOwner resourceOwner) {
            this.resourceOwner(resourceOwner == null ? null : resourceOwner.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<TagFilter.Builder> getTagFilters() {
            List<TagFilter.Builder> result = TagFiltersCopier.copyToBuilder(this.tagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagFilters(Collection<TagFilter.BuilderImpl> tagFilters) {
            this.tagFilters = TagFiltersCopier.copyFromBuilder(tagFilters);
        }

        @Override
        public final Builder tagFilters(Collection<TagFilter> tagFilters) {
            this.tagFilters = TagFiltersCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(TagFilter ... tagFilters) {
            this.tagFilters(Arrays.asList(tagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(Consumer<TagFilter.Builder> ... tagFilters) {
            this.tagFilters(Stream.of(tagFilters).map(c -> (TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getPermissionArn() {
            return this.permissionArn;
        }

        public final void setPermissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
        }

        @Override
        public final Builder permissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
            return this;
        }

        public final Integer getPermissionVersion() {
            return this.permissionVersion;
        }

        public final void setPermissionVersion(Integer permissionVersion) {
            this.permissionVersion = permissionVersion;
        }

        @Override
        public final Builder permissionVersion(Integer permissionVersion) {
            this.permissionVersion = permissionVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceSharesRequest build() {
            return new GetResourceSharesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceSharesRequest> {
        public Builder resourceShareArns(Collection<String> var1);

        public Builder resourceShareArns(String ... var1);

        public Builder resourceShareStatus(String var1);

        public Builder resourceShareStatus(ResourceShareStatus var1);

        public Builder resourceOwner(String var1);

        public Builder resourceOwner(ResourceOwner var1);

        public Builder name(String var1);

        public Builder tagFilters(Collection<TagFilter> var1);

        public Builder tagFilters(TagFilter ... var1);

        public Builder tagFilters(Consumer<TagFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder permissionArn(String var1);

        public Builder permissionVersion(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

