/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.PermissionStatus;
import software.amazon.awssdk.services.ram.model.RamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeletePermissionResponse
extends RamResponse
implements ToCopyableBuilder<Builder, DeletePermissionResponse> {
    private static final SdkField<Boolean> RETURN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("returnValue").getter(DeletePermissionResponse.getter(DeletePermissionResponse::returnValue)).setter(DeletePermissionResponse.setter(Builder::returnValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnValue").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(DeletePermissionResponse.getter(DeletePermissionResponse::clientToken)).setter(DeletePermissionResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> PERMISSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permissionStatus").getter(DeletePermissionResponse.getter(DeletePermissionResponse::permissionStatusAsString)).setter(DeletePermissionResponse.setter(Builder::permissionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETURN_VALUE_FIELD, CLIENT_TOKEN_FIELD, PERMISSION_STATUS_FIELD));
    private final Boolean returnValue;
    private final String clientToken;
    private final String permissionStatus;

    private DeletePermissionResponse(BuilderImpl builder) {
        super(builder);
        this.returnValue = builder.returnValue;
        this.clientToken = builder.clientToken;
        this.permissionStatus = builder.permissionStatus;
    }

    public final Boolean returnValue() {
        return this.returnValue;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final PermissionStatus permissionStatus() {
        return PermissionStatus.fromValue(this.permissionStatus);
    }

    public final String permissionStatusAsString() {
        return this.permissionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePermissionResponse)) {
            return false;
        }
        DeletePermissionResponse other = (DeletePermissionResponse)((Object)obj);
        return Objects.equals(this.returnValue(), other.returnValue()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.permissionStatusAsString(), other.permissionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeletePermissionResponse").add("ReturnValue", (Object)this.returnValue()).add("ClientToken", (Object)this.clientToken()).add("PermissionStatus", (Object)this.permissionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "returnValue": {
                return Optional.ofNullable(clazz.cast(this.returnValue()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "permissionStatus": {
                return Optional.ofNullable(clazz.cast(this.permissionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePermissionResponse, T> g) {
        return obj -> g.apply((DeletePermissionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamResponse.BuilderImpl
    implements Builder {
        private Boolean returnValue;
        private String clientToken;
        private String permissionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePermissionResponse model) {
            super(model);
            this.returnValue(model.returnValue);
            this.clientToken(model.clientToken);
            this.permissionStatus(model.permissionStatus);
        }

        public final Boolean getReturnValue() {
            return this.returnValue;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getPermissionStatus() {
            return this.permissionStatus;
        }

        public final void setPermissionStatus(String permissionStatus) {
            this.permissionStatus = permissionStatus;
        }

        @Override
        public final Builder permissionStatus(String permissionStatus) {
            this.permissionStatus = permissionStatus;
            return this;
        }

        @Override
        public final Builder permissionStatus(PermissionStatus permissionStatus) {
            this.permissionStatus(permissionStatus == null ? null : permissionStatus.toString());
            return this;
        }

        @Override
        public DeletePermissionResponse build() {
            return new DeletePermissionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeletePermissionResponse> {
        public Builder returnValue(Boolean var1);

        public Builder clientToken(String var1);

        public Builder permissionStatus(String var1);

        public Builder permissionStatus(PermissionStatus var1);
    }
}

