/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateResourceSharePermissionRequest extends RamRequest implements
        ToCopyableBuilder<DisassociateResourceSharePermissionRequest.Builder, DisassociateResourceSharePermissionRequest> {
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceShareArn").getter(getter(DisassociateResourceSharePermissionRequest::resourceShareArn))
            .setter(setter(Builder::resourceShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()).build();

    private static final SdkField<String> PERMISSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permissionArn").getter(getter(DisassociateResourceSharePermissionRequest::permissionArn))
            .setter(setter(Builder::permissionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(DisassociateResourceSharePermissionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARN_FIELD,
            PERMISSION_ARN_FIELD, CLIENT_TOKEN_FIELD));

    private final String resourceShareArn;

    private final String permissionArn;

    private final String clientToken;

    private DisassociateResourceSharePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.resourceShareArn = builder.resourceShareArn;
        this.permissionArn = builder.permissionArn;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     * (ARN)</a> of the resource share that you want to remove the managed permission from.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     *         Name (ARN)</a> of the resource share that you want to remove the managed permission from.
     */
    public final String resourceShareArn() {
        return resourceShareArn;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     * (ARN)</a> of the managed permission to disassociate from the resource share. Changes to permissions take effect
     * immediately.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     *         Name (ARN)</a> of the managed permission to disassociate from the resource share. Changes to permissions
     *         take effect immediately.
     */
    public final String permissionArn() {
        return permissionArn;
    }

    /**
     * <p>
     * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This
     * lets you safely retry the request without accidentally performing the same operation a second time. Passing the
     * same value to a later call to an operation requires that you also pass the same value for all other parameters.
     * We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of
     * value.</a>.
     * </p>
     * <p>
     * If you don't provide this value, then Amazon Web Services generates a random one for you.
     * </p>
     * <p>
     * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails
     * with an <code>IdempotentParameterMismatch</code> error.
     * </p>
     * 
     * @return Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         This lets you safely retry the request without accidentally performing the same operation a second time.
     *         Passing the same value to a later call to an operation requires that you also pass the same value for all
     *         other parameters. We recommend that you use a <a
     *         href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
     *         <p>
     *         If you don't provide this value, then Amazon Web Services generates a random one for you.
     *         </p>
     *         <p>
     *         If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
     *         retry fails with an <code>IdempotentParameterMismatch</code> error.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(permissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateResourceSharePermissionRequest)) {
            return false;
        }
        DisassociateResourceSharePermissionRequest other = (DisassociateResourceSharePermissionRequest) obj;
        return Objects.equals(resourceShareArn(), other.resourceShareArn())
                && Objects.equals(permissionArn(), other.permissionArn()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateResourceSharePermissionRequest").add("ResourceShareArn", resourceShareArn())
                .add("PermissionArn", permissionArn()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceShareArn":
            return Optional.ofNullable(clazz.cast(resourceShareArn()));
        case "permissionArn":
            return Optional.ofNullable(clazz.cast(permissionArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateResourceSharePermissionRequest, T> g) {
        return obj -> g.apply((DisassociateResourceSharePermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateResourceSharePermissionRequest> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of the resource share that you want to remove the managed permission from.
         * </p>
         * 
         * @param resourceShareArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        Resource Name (ARN)</a> of the resource share that you want to remove the managed permission from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArn(String resourceShareArn);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of the managed permission to disassociate from the resource share. Changes to permissions take
         * effect immediately.
         * </p>
         * 
         * @param permissionArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        Resource Name (ARN)</a> of the managed permission to disassociate from the resource share. Changes to
         *        permissions take effect immediately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionArn(String permissionArn);

        /**
         * <p>
         * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This
         * lets you safely retry the request without accidentally performing the same operation a second time. Passing
         * the same value to a later call to an operation requires that you also pass the same value for all other
         * parameters. We recommend that you use a <a
         * href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.
         * </p>
         * <p>
         * If you don't provide this value, then Amazon Web Services generates a random one for you.
         * </p>
         * <p>
         * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry
         * fails with an <code>IdempotentParameterMismatch</code> error.
         * </p>
         * 
         * @param clientToken
         *        Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the
         *        request. This lets you safely retry the request without accidentally performing the same operation a
         *        second time. Passing the same value to a later call to an operation requires that you also pass the
         *        same value for all other parameters. We recommend that you use a <a
         *        href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
         *        <p>
         *        If you don't provide this value, then Amazon Web Services generates a random one for you.
         *        </p>
         *        <p>
         *        If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
         *        retry fails with an <code>IdempotentParameterMismatch</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RamRequest.BuilderImpl implements Builder {
        private String resourceShareArn;

        private String permissionArn;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateResourceSharePermissionRequest model) {
            super(model);
            resourceShareArn(model.resourceShareArn);
            permissionArn(model.permissionArn);
            clientToken(model.clientToken);
        }

        public final String getResourceShareArn() {
            return resourceShareArn;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final String getPermissionArn() {
            return permissionArn;
        }

        public final void setPermissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
        }

        @Override
        public final Builder permissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateResourceSharePermissionRequest build() {
            return new DisassociateResourceSharePermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
