/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamClient;
import software.amazon.awssdk.services.ram.model.ListPermissionAssociationsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionAssociationsResponse;

public class ListPermissionAssociationsIterable
implements SdkIterable<ListPermissionAssociationsResponse> {
    private final RamClient client;
    private final ListPermissionAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPermissionAssociationsIterable(RamClient client, ListPermissionAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPermissionAssociationsResponseFetcher();
    }

    public Iterator<ListPermissionAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPermissionAssociationsResponseFetcher
    implements SyncPageFetcher<ListPermissionAssociationsResponse> {
        private ListPermissionAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPermissionAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPermissionAssociationsResponse nextPage(ListPermissionAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionAssociationsIterable.this.client.listPermissionAssociations(ListPermissionAssociationsIterable.this.firstRequest);
            }
            return ListPermissionAssociationsIterable.this.client.listPermissionAssociations((ListPermissionAssociationsRequest)((Object)ListPermissionAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

