/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamAsyncClient;
import software.amazon.awssdk.services.ram.model.ListPermissionAssociationsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionAssociationsResponse;

public class ListPermissionAssociationsPublisher
implements SdkPublisher<ListPermissionAssociationsResponse> {
    private final RamAsyncClient client;
    private final ListPermissionAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPermissionAssociationsPublisher(RamAsyncClient client, ListPermissionAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPermissionAssociationsPublisher(RamAsyncClient client, ListPermissionAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPermissionAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPermissionAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPermissionAssociationsResponseFetcher
    implements AsyncPageFetcher<ListPermissionAssociationsResponse> {
        private ListPermissionAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPermissionAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPermissionAssociationsResponse> nextPage(ListPermissionAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionAssociationsPublisher.this.client.listPermissionAssociations(ListPermissionAssociationsPublisher.this.firstRequest);
            }
            return ListPermissionAssociationsPublisher.this.client.listPermissionAssociations((ListPermissionAssociationsRequest)((Object)ListPermissionAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

