/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamAsyncClient;
import software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest;
import software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse;

public class ListPendingInvitationResourcesPublisher
implements SdkPublisher<ListPendingInvitationResourcesResponse> {
    private final RamAsyncClient client;
    private final ListPendingInvitationResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPendingInvitationResourcesPublisher(RamAsyncClient client, ListPendingInvitationResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPendingInvitationResourcesPublisher(RamAsyncClient client, ListPendingInvitationResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPendingInvitationResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPendingInvitationResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPendingInvitationResourcesResponseFetcher
    implements AsyncPageFetcher<ListPendingInvitationResourcesResponse> {
        private ListPendingInvitationResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListPendingInvitationResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPendingInvitationResourcesResponse> nextPage(ListPendingInvitationResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListPendingInvitationResourcesPublisher.this.client.listPendingInvitationResources(ListPendingInvitationResourcesPublisher.this.firstRequest);
            }
            return ListPendingInvitationResourcesPublisher.this.client.listPendingInvitationResources((ListPendingInvitationResourcesRequest)((Object)ListPendingInvitationResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

