/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.ResourceShareFeatureSet;
import software.amazon.awssdk.services.ram.model.ResourceShareStatus;
import software.amazon.awssdk.services.ram.model.Tag;
import software.amazon.awssdk.services.ram.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceShare
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceShare> {
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceShareArn").getter(ResourceShare.getter(ResourceShare::resourceShareArn)).setter(ResourceShare.setter(Builder::resourceShareArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ResourceShare.getter(ResourceShare::name)).setter(ResourceShare.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OWNING_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningAccountId").getter(ResourceShare.getter(ResourceShare::owningAccountId)).setter(ResourceShare.setter(Builder::owningAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningAccountId").build()}).build();
    private static final SdkField<Boolean> ALLOW_EXTERNAL_PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowExternalPrincipals").getter(ResourceShare.getter(ResourceShare::allowExternalPrincipals)).setter(ResourceShare.setter(Builder::allowExternalPrincipals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowExternalPrincipals").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ResourceShare.getter(ResourceShare::statusAsString)).setter(ResourceShare.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(ResourceShare.getter(ResourceShare::statusMessage)).setter(ResourceShare.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(ResourceShare.getter(ResourceShare::tags)).setter(ResourceShare.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ResourceShare.getter(ResourceShare::creationTime)).setter(ResourceShare.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTime").getter(ResourceShare.getter(ResourceShare::lastUpdatedTime)).setter(ResourceShare.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> FEATURE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("featureSet").getter(ResourceShare.getter(ResourceShare::featureSetAsString)).setter(ResourceShare.setter(Builder::featureSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureSet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARN_FIELD, NAME_FIELD, OWNING_ACCOUNT_ID_FIELD, ALLOW_EXTERNAL_PRINCIPALS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, TAGS_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, FEATURE_SET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceShareArn;
    private final String name;
    private final String owningAccountId;
    private final Boolean allowExternalPrincipals;
    private final String status;
    private final String statusMessage;
    private final List<Tag> tags;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;
    private final String featureSet;

    private ResourceShare(BuilderImpl builder) {
        this.resourceShareArn = builder.resourceShareArn;
        this.name = builder.name;
        this.owningAccountId = builder.owningAccountId;
        this.allowExternalPrincipals = builder.allowExternalPrincipals;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.featureSet = builder.featureSet;
    }

    public String resourceShareArn() {
        return this.resourceShareArn;
    }

    public String name() {
        return this.name;
    }

    public String owningAccountId() {
        return this.owningAccountId;
    }

    public Boolean allowExternalPrincipals() {
        return this.allowExternalPrincipals;
    }

    public ResourceShareStatus status() {
        return ResourceShareStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public ResourceShareFeatureSet featureSet() {
        return ResourceShareFeatureSet.fromValue(this.featureSet);
    }

    public String featureSetAsString() {
        return this.featureSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowExternalPrincipals());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureSetAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceShare)) {
            return false;
        }
        ResourceShare other = (ResourceShare)obj;
        return Objects.equals(this.resourceShareArn(), other.resourceShareArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owningAccountId(), other.owningAccountId()) && Objects.equals(this.allowExternalPrincipals(), other.allowExternalPrincipals()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.featureSetAsString(), other.featureSetAsString());
    }

    public String toString() {
        return ToString.builder((String)"ResourceShare").add("ResourceShareArn", (Object)this.resourceShareArn()).add("Name", (Object)this.name()).add("OwningAccountId", (Object)this.owningAccountId()).add("AllowExternalPrincipals", (Object)this.allowExternalPrincipals()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("Tags", this.hasTags() ? this.tags() : null).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("FeatureSet", (Object)this.featureSetAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareArn": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owningAccountId": {
                return Optional.ofNullable(clazz.cast(this.owningAccountId()));
            }
            case "allowExternalPrincipals": {
                return Optional.ofNullable(clazz.cast(this.allowExternalPrincipals()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "featureSet": {
                return Optional.ofNullable(clazz.cast(this.featureSetAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceShare, T> g) {
        return obj -> g.apply((ResourceShare)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceShareArn;
        private String name;
        private String owningAccountId;
        private Boolean allowExternalPrincipals;
        private String status;
        private String statusMessage;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private Instant lastUpdatedTime;
        private String featureSet;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceShare model) {
            this.resourceShareArn(model.resourceShareArn);
            this.name(model.name);
            this.owningAccountId(model.owningAccountId);
            this.allowExternalPrincipals(model.allowExternalPrincipals);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.tags(model.tags);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.featureSet(model.featureSet);
        }

        public final String getResourceShareArn() {
            return this.resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwningAccountId() {
            return this.owningAccountId;
        }

        @Override
        public final Builder owningAccountId(String owningAccountId) {
            this.owningAccountId = owningAccountId;
            return this;
        }

        public final void setOwningAccountId(String owningAccountId) {
            this.owningAccountId = owningAccountId;
        }

        public final Boolean getAllowExternalPrincipals() {
            return this.allowExternalPrincipals;
        }

        @Override
        public final Builder allowExternalPrincipals(Boolean allowExternalPrincipals) {
            this.allowExternalPrincipals = allowExternalPrincipals;
            return this;
        }

        public final void setAllowExternalPrincipals(Boolean allowExternalPrincipals) {
            this.allowExternalPrincipals = allowExternalPrincipals;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getFeatureSet() {
            return this.featureSet;
        }

        @Override
        public final Builder featureSet(String featureSet) {
            this.featureSet = featureSet;
            return this;
        }

        @Override
        public final Builder featureSet(ResourceShareFeatureSet featureSet) {
            this.featureSet(featureSet == null ? null : featureSet.toString());
            return this;
        }

        public final void setFeatureSet(String featureSet) {
            this.featureSet = featureSet;
        }

        public ResourceShare build() {
            return new ResourceShare(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceShare> {
        public Builder resourceShareArn(String var1);

        public Builder name(String var1);

        public Builder owningAccountId(String var1);

        public Builder allowExternalPrincipals(Boolean var1);

        public Builder status(String var1);

        public Builder status(ResourceShareStatus var1);

        public Builder statusMessage(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder featureSet(String var1);

        public Builder featureSet(ResourceShareFeatureSet var1);
    }
}

