/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.RamResponse;
import software.amazon.awssdk.services.ram.model.ResourceShare;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceShareResponse
extends RamResponse
implements ToCopyableBuilder<Builder, CreateResourceShareResponse> {
    private static final SdkField<ResourceShare> RESOURCE_SHARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceShare").getter(CreateResourceShareResponse.getter(CreateResourceShareResponse::resourceShare)).setter(CreateResourceShareResponse.setter(Builder::resourceShare)).constructor(ResourceShare::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShare").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateResourceShareResponse.getter(CreateResourceShareResponse::clientToken)).setter(CreateResourceShareResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_FIELD, CLIENT_TOKEN_FIELD));
    private final ResourceShare resourceShare;
    private final String clientToken;

    private CreateResourceShareResponse(BuilderImpl builder) {
        super(builder);
        this.resourceShare = builder.resourceShare;
        this.clientToken = builder.clientToken;
    }

    public ResourceShare resourceShare() {
        return this.resourceShare;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShare());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceShareResponse)) {
            return false;
        }
        CreateResourceShareResponse other = (CreateResourceShareResponse)((Object)obj);
        return Objects.equals(this.resourceShare(), other.resourceShare()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateResourceShareResponse").add("ResourceShare", (Object)this.resourceShare()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShare": {
                return Optional.ofNullable(clazz.cast(this.resourceShare()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceShareResponse, T> g) {
        return obj -> g.apply((CreateResourceShareResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamResponse.BuilderImpl
    implements Builder {
        private ResourceShare resourceShare;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceShareResponse model) {
            super(model);
            this.resourceShare(model.resourceShare);
            this.clientToken(model.clientToken);
        }

        public final ResourceShare.Builder getResourceShare() {
            return this.resourceShare != null ? this.resourceShare.toBuilder() : null;
        }

        @Override
        public final Builder resourceShare(ResourceShare resourceShare) {
            this.resourceShare = resourceShare;
            return this;
        }

        public final void setResourceShare(ResourceShare.BuilderImpl resourceShare) {
            this.resourceShare = resourceShare != null ? resourceShare.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateResourceShareResponse build() {
            return new CreateResourceShareResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResourceShareResponse> {
        public Builder resourceShare(ResourceShare var1);

        default public Builder resourceShare(Consumer<ResourceShare.Builder> resourceShare) {
            return this.resourceShare((ResourceShare)((ResourceShare.Builder)ResourceShare.builder().applyMutation(resourceShare)).build());
        }

        public Builder clientToken(String var1);
    }
}

