/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptResourceShareInvitationRequest
extends RamRequest
implements ToCopyableBuilder<Builder, AcceptResourceShareInvitationRequest> {
    private static final SdkField<String> RESOURCE_SHARE_INVITATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceShareInvitationArn").getter(AcceptResourceShareInvitationRequest.getter(AcceptResourceShareInvitationRequest::resourceShareInvitationArn)).setter(AcceptResourceShareInvitationRequest.setter(Builder::resourceShareInvitationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareInvitationArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(AcceptResourceShareInvitationRequest.getter(AcceptResourceShareInvitationRequest::clientToken)).setter(AcceptResourceShareInvitationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_INVITATION_ARN_FIELD, CLIENT_TOKEN_FIELD));
    private final String resourceShareInvitationArn;
    private final String clientToken;

    private AcceptResourceShareInvitationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceShareInvitationArn = builder.resourceShareInvitationArn;
        this.clientToken = builder.clientToken;
    }

    public String resourceShareInvitationArn() {
        return this.resourceShareInvitationArn;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareInvitationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptResourceShareInvitationRequest)) {
            return false;
        }
        AcceptResourceShareInvitationRequest other = (AcceptResourceShareInvitationRequest)((Object)obj);
        return Objects.equals(this.resourceShareInvitationArn(), other.resourceShareInvitationArn()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"AcceptResourceShareInvitationRequest").add("ResourceShareInvitationArn", (Object)this.resourceShareInvitationArn()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareInvitationArn": {
                return Optional.ofNullable(clazz.cast(this.resourceShareInvitationArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptResourceShareInvitationRequest, T> g) {
        return obj -> g.apply((AcceptResourceShareInvitationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private String resourceShareInvitationArn;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptResourceShareInvitationRequest model) {
            super(model);
            this.resourceShareInvitationArn(model.resourceShareInvitationArn);
            this.clientToken(model.clientToken);
        }

        public final String getResourceShareInvitationArn() {
            return this.resourceShareInvitationArn;
        }

        @Override
        public final Builder resourceShareInvitationArn(String resourceShareInvitationArn) {
            this.resourceShareInvitationArn = resourceShareInvitationArn;
            return this;
        }

        public final void setResourceShareInvitationArn(String resourceShareInvitationArn) {
            this.resourceShareInvitationArn = resourceShareInvitationArn;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptResourceShareInvitationRequest build() {
            return new AcceptResourceShareInvitationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AcceptResourceShareInvitationRequest> {
        public Builder resourceShareInvitationArn(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

