/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.RamResponse;
import software.amazon.awssdk.services.ram.model.ResourceShare;
import software.amazon.awssdk.services.ram.model.ResourceShareListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceSharesResponse
extends RamResponse
implements ToCopyableBuilder<Builder, GetResourceSharesResponse> {
    private static final SdkField<List<ResourceShare>> RESOURCE_SHARES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetResourceSharesResponse.getter(GetResourceSharesResponse::resourceShares)).setter(GetResourceSharesResponse.setter(Builder::resourceShares)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShares").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceShare::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetResourceSharesResponse.getter(GetResourceSharesResponse::nextToken)).setter(GetResourceSharesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ResourceShare> resourceShares;
    private final String nextToken;

    private GetResourceSharesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceShares = builder.resourceShares;
        this.nextToken = builder.nextToken;
    }

    public boolean hasResourceShares() {
        return this.resourceShares != null && !(this.resourceShares instanceof SdkAutoConstructList);
    }

    public List<ResourceShare> resourceShares() {
        return this.resourceShares;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShares());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceSharesResponse)) {
            return false;
        }
        GetResourceSharesResponse other = (GetResourceSharesResponse)((Object)obj);
        return Objects.equals(this.resourceShares(), other.resourceShares()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetResourceSharesResponse").add("ResourceShares", this.resourceShares()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShares": {
                return Optional.ofNullable(clazz.cast(this.resourceShares()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceSharesResponse, T> g) {
        return obj -> g.apply((GetResourceSharesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamResponse.BuilderImpl
    implements Builder {
        private List<ResourceShare> resourceShares = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceSharesResponse model) {
            super(model);
            this.resourceShares(model.resourceShares);
            this.nextToken(model.nextToken);
        }

        public final Collection<ResourceShare.Builder> getResourceShares() {
            return this.resourceShares != null ? (Collection)this.resourceShares.stream().map(ResourceShare::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceShares(Collection<ResourceShare> resourceShares) {
            this.resourceShares = ResourceShareListCopier.copy(resourceShares);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShares(ResourceShare ... resourceShares) {
            this.resourceShares(Arrays.asList(resourceShares));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShares(Consumer<ResourceShare.Builder> ... resourceShares) {
            this.resourceShares(Stream.of(resourceShares).map(c -> (ResourceShare)((ResourceShare.Builder)ResourceShare.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceShares(Collection<ResourceShare.BuilderImpl> resourceShares) {
            this.resourceShares = ResourceShareListCopier.copyFromBuilder(resourceShares);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetResourceSharesResponse build() {
            return new GetResourceSharesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceSharesResponse> {
        public Builder resourceShares(Collection<ResourceShare> var1);

        public Builder resourceShares(ResourceShare ... var1);

        public Builder resourceShares(Consumer<ResourceShare.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

