/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamClient;
import software.amazon.awssdk.services.ram.model.GetResourceSharesRequest;
import software.amazon.awssdk.services.ram.model.GetResourceSharesResponse;

public class GetResourceSharesIterable
implements SdkIterable<GetResourceSharesResponse> {
    private final RamClient client;
    private final GetResourceSharesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetResourceSharesIterable(RamClient client, GetResourceSharesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetResourceSharesResponseFetcher();
    }

    public Iterator<GetResourceSharesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetResourceSharesIterable resume(GetResourceSharesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetResourceSharesIterable(this.client, (GetResourceSharesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetResourceSharesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetResourceSharesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetResourceSharesResponseFetcher
    implements SyncPageFetcher<GetResourceSharesResponse> {
        private GetResourceSharesResponseFetcher() {
        }

        public boolean hasNextPage(GetResourceSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetResourceSharesResponse nextPage(GetResourceSharesResponse previousPage) {
            if (previousPage == null) {
                return GetResourceSharesIterable.this.client.getResourceShares(GetResourceSharesIterable.this.firstRequest);
            }
            return GetResourceSharesIterable.this.client.getResourceShares((GetResourceSharesRequest)((Object)GetResourceSharesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

