/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.model.AccessDeniedException;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.CreateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserByPrincipalIdRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserByPrincipalIdResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeUserRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeUserResponse;
import software.amazon.awssdk.services.quicksight.model.DomainNotWhitelistedException;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlRequest;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlResponse;
import software.amazon.awssdk.services.quicksight.model.IdentityTypeNotSupportedException;
import software.amazon.awssdk.services.quicksight.model.InternalFailureException;
import software.amazon.awssdk.services.quicksight.model.InvalidNextTokenException;
import software.amazon.awssdk.services.quicksight.model.InvalidParameterValueException;
import software.amazon.awssdk.services.quicksight.model.LimitExceededException;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListUsersRequest;
import software.amazon.awssdk.services.quicksight.model.ListUsersResponse;
import software.amazon.awssdk.services.quicksight.model.PreconditionNotMetException;
import software.amazon.awssdk.services.quicksight.model.QuickSightException;
import software.amazon.awssdk.services.quicksight.model.QuickSightUserNotFoundException;
import software.amazon.awssdk.services.quicksight.model.RegisterUserRequest;
import software.amazon.awssdk.services.quicksight.model.RegisterUserResponse;
import software.amazon.awssdk.services.quicksight.model.ResourceExistsException;
import software.amazon.awssdk.services.quicksight.model.ResourceNotFoundException;
import software.amazon.awssdk.services.quicksight.model.ResourceUnavailableException;
import software.amazon.awssdk.services.quicksight.model.SessionLifetimeInMinutesInvalidException;
import software.amazon.awssdk.services.quicksight.model.ThrottlingException;
import software.amazon.awssdk.services.quicksight.model.UnsupportedUserEditionException;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateUserRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateUserResponse;
import software.amazon.awssdk.services.quicksight.transform.CreateGroupMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteGroupMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteUserByPrincipalIdRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GetDashboardEmbedUrlRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListGroupMembershipsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListUserGroupsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.RegisterUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateUserRequestMarshaller;

@SdkInternalApi
final class DefaultQuickSightClient
implements QuickSightClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultQuickSightClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "quicksight";
    }

    @Override
    public CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException, LimitExceededException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGroupRequest).withMarshaller((Marshaller)new CreateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateGroupMembershipResponse createGroupMembership(CreateGroupMembershipRequest createGroupMembershipRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGroupMembershipResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateGroupMembershipResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGroupMembership").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGroupMembershipRequest).withMarshaller((Marshaller)new CreateGroupMembershipRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGroupRequest).withMarshaller((Marshaller)new DeleteGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteGroupMembershipResponse deleteGroupMembership(DeleteGroupMembershipRequest deleteGroupMembershipRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGroupMembershipResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteGroupMembershipResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGroupMembership").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGroupMembershipRequest).withMarshaller((Marshaller)new DeleteGroupMembershipRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUserRequest).withMarshaller((Marshaller)new DeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteUserByPrincipalIdResponse deleteUserByPrincipalId(DeleteUserByPrincipalIdRequest deleteUserByPrincipalIdRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserByPrincipalIdResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteUserByPrincipalIdResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUserByPrincipalId").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUserByPrincipalIdRequest).withMarshaller((Marshaller)new DeleteUserByPrincipalIdRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeGroupResponse describeGroup(DescribeGroupRequest describeGroupRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGroupRequest).withMarshaller((Marshaller)new DescribeGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUserRequest).withMarshaller((Marshaller)new DescribeUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDashboardEmbedUrlResponse getDashboardEmbedUrl(GetDashboardEmbedUrlRequest getDashboardEmbedUrlRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException, DomainNotWhitelistedException, QuickSightUserNotFoundException, IdentityTypeNotSupportedException, SessionLifetimeInMinutesInvalidException, UnsupportedUserEditionException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDashboardEmbedUrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDashboardEmbedUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDashboardEmbedUrl").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDashboardEmbedUrlRequest).withMarshaller((Marshaller)new GetDashboardEmbedUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListGroupMembershipsResponse listGroupMemberships(ListGroupMembershipsRequest listGroupMembershipsRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGroupMembershipsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListGroupMembershipsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGroupMemberships").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGroupMembershipsRequest).withMarshaller((Marshaller)new ListGroupMembershipsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGroupsRequest).withMarshaller((Marshaller)new ListGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListUserGroupsResponse listUserGroups(ListUserGroupsRequest listUserGroupsRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUserGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListUserGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUserGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUserGroupsRequest).withMarshaller((Marshaller)new ListUserGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUsersRequest).withMarshaller((Marshaller)new ListUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RegisterUserResponse registerUser(RegisterUserRequest registerUserRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, LimitExceededException, ResourceExistsException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RegisterUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerUserRequest).withMarshaller((Marshaller)new RegisterUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateGroupResponse updateGroup(UpdateGroupRequest updateGroupRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGroupRequest).withMarshaller((Marshaller)new UpdateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserRequest).withMarshaller((Marshaller)new UpdateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(QuickSightException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").exceptionBuilderSupplier(DomainNotWhitelistedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalFailureException").exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").exceptionBuilderSupplier(ResourceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceExistsException").exceptionBuilderSupplier(ResourceExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException").exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").exceptionBuilderSupplier(UnsupportedUserEditionException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").exceptionBuilderSupplier(PreconditionNotMetException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

