/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateActionConnectorResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, UpdateActionConnectorResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateActionConnectorResponse.getter(UpdateActionConnectorResponse::arn)).setter(UpdateActionConnectorResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ACTION_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionConnectorId").getter(UpdateActionConnectorResponse.getter(UpdateActionConnectorResponse::actionConnectorId)).setter(UpdateActionConnectorResponse.setter(Builder::actionConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionConnectorId").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(UpdateActionConnectorResponse.getter(UpdateActionConnectorResponse::requestId)).setter(UpdateActionConnectorResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateStatus").getter(UpdateActionConnectorResponse.getter(UpdateActionConnectorResponse::updateStatusAsString)).setter(UpdateActionConnectorResponse.setter(Builder::updateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(UpdateActionConnectorResponse.getter(UpdateActionConnectorResponse::status)).setter(UpdateActionConnectorResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ACTION_CONNECTOR_ID_FIELD, REQUEST_ID_FIELD, UPDATE_STATUS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateActionConnectorResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String actionConnectorId;
    private final String requestId;
    private final String updateStatus;
    private final Integer status;

    private UpdateActionConnectorResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.actionConnectorId = builder.actionConnectorId;
        this.requestId = builder.requestId;
        this.updateStatus = builder.updateStatus;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String actionConnectorId() {
        return this.actionConnectorId;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final ResourceStatus updateStatus() {
        return ResourceStatus.fromValue(this.updateStatus);
    }

    public final String updateStatusAsString() {
        return this.updateStatus;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateActionConnectorResponse)) {
            return false;
        }
        UpdateActionConnectorResponse other = (UpdateActionConnectorResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.actionConnectorId(), other.actionConnectorId()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.updateStatusAsString(), other.updateStatusAsString()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateActionConnectorResponse").add("Arn", (Object)this.arn()).add("ActionConnectorId", (Object)this.actionConnectorId()).add("RequestId", (Object)this.requestId()).add("UpdateStatus", (Object)this.updateStatusAsString()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ActionConnectorId": {
                return Optional.ofNullable(clazz.cast(this.actionConnectorId()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "UpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.updateStatusAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("ActionConnectorId", ACTION_CONNECTOR_ID_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("UpdateStatus", UPDATE_STATUS_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateActionConnectorResponse, T> g) {
        return obj -> g.apply((UpdateActionConnectorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String actionConnectorId;
        private String requestId;
        private String updateStatus;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateActionConnectorResponse model) {
            super(model);
            this.arn(model.arn);
            this.actionConnectorId(model.actionConnectorId);
            this.requestId(model.requestId);
            this.updateStatus(model.updateStatus);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getActionConnectorId() {
            return this.actionConnectorId;
        }

        public final void setActionConnectorId(String actionConnectorId) {
            this.actionConnectorId = actionConnectorId;
        }

        @Override
        public final Builder actionConnectorId(String actionConnectorId) {
            this.actionConnectorId = actionConnectorId;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getUpdateStatus() {
            return this.updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(ResourceStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public UpdateActionConnectorResponse build() {
            return new UpdateActionConnectorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateActionConnectorResponse> {
        public Builder arn(String var1);

        public Builder actionConnectorId(String var1);

        public Builder requestId(String var1);

        public Builder updateStatus(String var1);

        public Builder updateStatus(ResourceStatus var1);

        public Builder status(Integer var1);
    }
}

