/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.ReadAPIKeyConnectionMetadata;
import software.amazon.awssdk.services.quicksight.model.ReadAuthorizationCodeGrantMetadata;
import software.amazon.awssdk.services.quicksight.model.ReadBasicAuthConnectionMetadata;
import software.amazon.awssdk.services.quicksight.model.ReadClientCredentialsGrantMetadata;
import software.amazon.awssdk.services.quicksight.model.ReadIamConnectionMetadata;
import software.amazon.awssdk.services.quicksight.model.ReadNoneConnectionMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReadAuthenticationMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReadAuthenticationMetadata> {
    private static final SdkField<ReadAuthorizationCodeGrantMetadata> AUTHORIZATION_CODE_GRANT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthorizationCodeGrantMetadata").getter(ReadAuthenticationMetadata.getter(ReadAuthenticationMetadata::authorizationCodeGrantMetadata)).setter(ReadAuthenticationMetadata.setter(Builder::authorizationCodeGrantMetadata)).constructor(ReadAuthorizationCodeGrantMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationCodeGrantMetadata").build()}).build();
    private static final SdkField<ReadClientCredentialsGrantMetadata> CLIENT_CREDENTIALS_GRANT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientCredentialsGrantMetadata").getter(ReadAuthenticationMetadata.getter(ReadAuthenticationMetadata::clientCredentialsGrantMetadata)).setter(ReadAuthenticationMetadata.setter(Builder::clientCredentialsGrantMetadata)).constructor(ReadClientCredentialsGrantMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCredentialsGrantMetadata").build()}).build();
    private static final SdkField<ReadBasicAuthConnectionMetadata> BASIC_AUTH_CONNECTION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BasicAuthConnectionMetadata").getter(ReadAuthenticationMetadata.getter(ReadAuthenticationMetadata::basicAuthConnectionMetadata)).setter(ReadAuthenticationMetadata.setter(Builder::basicAuthConnectionMetadata)).constructor(ReadBasicAuthConnectionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuthConnectionMetadata").build()}).build();
    private static final SdkField<ReadAPIKeyConnectionMetadata> API_KEY_CONNECTION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApiKeyConnectionMetadata").getter(ReadAuthenticationMetadata.getter(ReadAuthenticationMetadata::apiKeyConnectionMetadata)).setter(ReadAuthenticationMetadata.setter(Builder::apiKeyConnectionMetadata)).constructor(ReadAPIKeyConnectionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeyConnectionMetadata").build()}).build();
    private static final SdkField<ReadNoneConnectionMetadata> NONE_CONNECTION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NoneConnectionMetadata").getter(ReadAuthenticationMetadata.getter(ReadAuthenticationMetadata::noneConnectionMetadata)).setter(ReadAuthenticationMetadata.setter(Builder::noneConnectionMetadata)).constructor(ReadNoneConnectionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoneConnectionMetadata").build()}).build();
    private static final SdkField<ReadIamConnectionMetadata> IAM_CONNECTION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamConnectionMetadata").getter(ReadAuthenticationMetadata.getter(ReadAuthenticationMetadata::iamConnectionMetadata)).setter(ReadAuthenticationMetadata.setter(Builder::iamConnectionMetadata)).constructor(ReadIamConnectionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamConnectionMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_CODE_GRANT_METADATA_FIELD, CLIENT_CREDENTIALS_GRANT_METADATA_FIELD, BASIC_AUTH_CONNECTION_METADATA_FIELD, API_KEY_CONNECTION_METADATA_FIELD, NONE_CONNECTION_METADATA_FIELD, IAM_CONNECTION_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReadAuthenticationMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ReadAuthorizationCodeGrantMetadata authorizationCodeGrantMetadata;
    private final ReadClientCredentialsGrantMetadata clientCredentialsGrantMetadata;
    private final ReadBasicAuthConnectionMetadata basicAuthConnectionMetadata;
    private final ReadAPIKeyConnectionMetadata apiKeyConnectionMetadata;
    private final ReadNoneConnectionMetadata noneConnectionMetadata;
    private final ReadIamConnectionMetadata iamConnectionMetadata;
    private final Type type;

    private ReadAuthenticationMetadata(BuilderImpl builder) {
        this.authorizationCodeGrantMetadata = builder.authorizationCodeGrantMetadata;
        this.clientCredentialsGrantMetadata = builder.clientCredentialsGrantMetadata;
        this.basicAuthConnectionMetadata = builder.basicAuthConnectionMetadata;
        this.apiKeyConnectionMetadata = builder.apiKeyConnectionMetadata;
        this.noneConnectionMetadata = builder.noneConnectionMetadata;
        this.iamConnectionMetadata = builder.iamConnectionMetadata;
        this.type = builder.type;
    }

    public final ReadAuthorizationCodeGrantMetadata authorizationCodeGrantMetadata() {
        return this.authorizationCodeGrantMetadata;
    }

    public final ReadClientCredentialsGrantMetadata clientCredentialsGrantMetadata() {
        return this.clientCredentialsGrantMetadata;
    }

    public final ReadBasicAuthConnectionMetadata basicAuthConnectionMetadata() {
        return this.basicAuthConnectionMetadata;
    }

    public final ReadAPIKeyConnectionMetadata apiKeyConnectionMetadata() {
        return this.apiKeyConnectionMetadata;
    }

    public final ReadNoneConnectionMetadata noneConnectionMetadata() {
        return this.noneConnectionMetadata;
    }

    public final ReadIamConnectionMetadata iamConnectionMetadata() {
        return this.iamConnectionMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationCodeGrantMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCredentialsGrantMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthConnectionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyConnectionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.noneConnectionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamConnectionMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadAuthenticationMetadata)) {
            return false;
        }
        ReadAuthenticationMetadata other = (ReadAuthenticationMetadata)obj;
        return Objects.equals(this.authorizationCodeGrantMetadata(), other.authorizationCodeGrantMetadata()) && Objects.equals(this.clientCredentialsGrantMetadata(), other.clientCredentialsGrantMetadata()) && Objects.equals(this.basicAuthConnectionMetadata(), other.basicAuthConnectionMetadata()) && Objects.equals(this.apiKeyConnectionMetadata(), other.apiKeyConnectionMetadata()) && Objects.equals(this.noneConnectionMetadata(), other.noneConnectionMetadata()) && Objects.equals(this.iamConnectionMetadata(), other.iamConnectionMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"ReadAuthenticationMetadata").add("AuthorizationCodeGrantMetadata", (Object)this.authorizationCodeGrantMetadata()).add("ClientCredentialsGrantMetadata", (Object)this.clientCredentialsGrantMetadata()).add("BasicAuthConnectionMetadata", (Object)this.basicAuthConnectionMetadata()).add("ApiKeyConnectionMetadata", (Object)this.apiKeyConnectionMetadata()).add("NoneConnectionMetadata", (Object)this.noneConnectionMetadata()).add("IamConnectionMetadata", (Object)this.iamConnectionMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthorizationCodeGrantMetadata": {
                return Optional.ofNullable(clazz.cast(this.authorizationCodeGrantMetadata()));
            }
            case "ClientCredentialsGrantMetadata": {
                return Optional.ofNullable(clazz.cast(this.clientCredentialsGrantMetadata()));
            }
            case "BasicAuthConnectionMetadata": {
                return Optional.ofNullable(clazz.cast(this.basicAuthConnectionMetadata()));
            }
            case "ApiKeyConnectionMetadata": {
                return Optional.ofNullable(clazz.cast(this.apiKeyConnectionMetadata()));
            }
            case "NoneConnectionMetadata": {
                return Optional.ofNullable(clazz.cast(this.noneConnectionMetadata()));
            }
            case "IamConnectionMetadata": {
                return Optional.ofNullable(clazz.cast(this.iamConnectionMetadata()));
            }
        }
        return Optional.empty();
    }

    public static ReadAuthenticationMetadata fromAuthorizationCodeGrantMetadata(ReadAuthorizationCodeGrantMetadata authorizationCodeGrantMetadata) {
        return (ReadAuthenticationMetadata)ReadAuthenticationMetadata.builder().authorizationCodeGrantMetadata(authorizationCodeGrantMetadata).build();
    }

    public static ReadAuthenticationMetadata fromAuthorizationCodeGrantMetadata(Consumer<ReadAuthorizationCodeGrantMetadata.Builder> authorizationCodeGrantMetadata) {
        ReadAuthorizationCodeGrantMetadata.Builder builder = ReadAuthorizationCodeGrantMetadata.builder();
        authorizationCodeGrantMetadata.accept(builder);
        return ReadAuthenticationMetadata.fromAuthorizationCodeGrantMetadata((ReadAuthorizationCodeGrantMetadata)builder.build());
    }

    public static ReadAuthenticationMetadata fromClientCredentialsGrantMetadata(ReadClientCredentialsGrantMetadata clientCredentialsGrantMetadata) {
        return (ReadAuthenticationMetadata)ReadAuthenticationMetadata.builder().clientCredentialsGrantMetadata(clientCredentialsGrantMetadata).build();
    }

    public static ReadAuthenticationMetadata fromClientCredentialsGrantMetadata(Consumer<ReadClientCredentialsGrantMetadata.Builder> clientCredentialsGrantMetadata) {
        ReadClientCredentialsGrantMetadata.Builder builder = ReadClientCredentialsGrantMetadata.builder();
        clientCredentialsGrantMetadata.accept(builder);
        return ReadAuthenticationMetadata.fromClientCredentialsGrantMetadata((ReadClientCredentialsGrantMetadata)builder.build());
    }

    public static ReadAuthenticationMetadata fromBasicAuthConnectionMetadata(ReadBasicAuthConnectionMetadata basicAuthConnectionMetadata) {
        return (ReadAuthenticationMetadata)ReadAuthenticationMetadata.builder().basicAuthConnectionMetadata(basicAuthConnectionMetadata).build();
    }

    public static ReadAuthenticationMetadata fromBasicAuthConnectionMetadata(Consumer<ReadBasicAuthConnectionMetadata.Builder> basicAuthConnectionMetadata) {
        ReadBasicAuthConnectionMetadata.Builder builder = ReadBasicAuthConnectionMetadata.builder();
        basicAuthConnectionMetadata.accept(builder);
        return ReadAuthenticationMetadata.fromBasicAuthConnectionMetadata((ReadBasicAuthConnectionMetadata)builder.build());
    }

    public static ReadAuthenticationMetadata fromApiKeyConnectionMetadata(ReadAPIKeyConnectionMetadata apiKeyConnectionMetadata) {
        return (ReadAuthenticationMetadata)ReadAuthenticationMetadata.builder().apiKeyConnectionMetadata(apiKeyConnectionMetadata).build();
    }

    public static ReadAuthenticationMetadata fromApiKeyConnectionMetadata(Consumer<ReadAPIKeyConnectionMetadata.Builder> apiKeyConnectionMetadata) {
        ReadAPIKeyConnectionMetadata.Builder builder = ReadAPIKeyConnectionMetadata.builder();
        apiKeyConnectionMetadata.accept(builder);
        return ReadAuthenticationMetadata.fromApiKeyConnectionMetadata((ReadAPIKeyConnectionMetadata)builder.build());
    }

    public static ReadAuthenticationMetadata fromNoneConnectionMetadata(ReadNoneConnectionMetadata noneConnectionMetadata) {
        return (ReadAuthenticationMetadata)ReadAuthenticationMetadata.builder().noneConnectionMetadata(noneConnectionMetadata).build();
    }

    public static ReadAuthenticationMetadata fromNoneConnectionMetadata(Consumer<ReadNoneConnectionMetadata.Builder> noneConnectionMetadata) {
        ReadNoneConnectionMetadata.Builder builder = ReadNoneConnectionMetadata.builder();
        noneConnectionMetadata.accept(builder);
        return ReadAuthenticationMetadata.fromNoneConnectionMetadata((ReadNoneConnectionMetadata)builder.build());
    }

    public static ReadAuthenticationMetadata fromIamConnectionMetadata(ReadIamConnectionMetadata iamConnectionMetadata) {
        return (ReadAuthenticationMetadata)ReadAuthenticationMetadata.builder().iamConnectionMetadata(iamConnectionMetadata).build();
    }

    public static ReadAuthenticationMetadata fromIamConnectionMetadata(Consumer<ReadIamConnectionMetadata.Builder> iamConnectionMetadata) {
        ReadIamConnectionMetadata.Builder builder = ReadIamConnectionMetadata.builder();
        iamConnectionMetadata.accept(builder);
        return ReadAuthenticationMetadata.fromIamConnectionMetadata((ReadIamConnectionMetadata)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AuthorizationCodeGrantMetadata", AUTHORIZATION_CODE_GRANT_METADATA_FIELD);
        map.put("ClientCredentialsGrantMetadata", CLIENT_CREDENTIALS_GRANT_METADATA_FIELD);
        map.put("BasicAuthConnectionMetadata", BASIC_AUTH_CONNECTION_METADATA_FIELD);
        map.put("ApiKeyConnectionMetadata", API_KEY_CONNECTION_METADATA_FIELD);
        map.put("NoneConnectionMetadata", NONE_CONNECTION_METADATA_FIELD);
        map.put("IamConnectionMetadata", IAM_CONNECTION_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadAuthenticationMetadata, T> g) {
        return obj -> g.apply((ReadAuthenticationMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AUTHORIZATION_CODE_GRANT_METADATA,
        CLIENT_CREDENTIALS_GRANT_METADATA,
        BASIC_AUTH_CONNECTION_METADATA,
        API_KEY_CONNECTION_METADATA,
        NONE_CONNECTION_METADATA,
        IAM_CONNECTION_METADATA,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ReadAuthorizationCodeGrantMetadata authorizationCodeGrantMetadata;
        private ReadClientCredentialsGrantMetadata clientCredentialsGrantMetadata;
        private ReadBasicAuthConnectionMetadata basicAuthConnectionMetadata;
        private ReadAPIKeyConnectionMetadata apiKeyConnectionMetadata;
        private ReadNoneConnectionMetadata noneConnectionMetadata;
        private ReadIamConnectionMetadata iamConnectionMetadata;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReadAuthenticationMetadata model) {
            this.authorizationCodeGrantMetadata(model.authorizationCodeGrantMetadata);
            this.clientCredentialsGrantMetadata(model.clientCredentialsGrantMetadata);
            this.basicAuthConnectionMetadata(model.basicAuthConnectionMetadata);
            this.apiKeyConnectionMetadata(model.apiKeyConnectionMetadata);
            this.noneConnectionMetadata(model.noneConnectionMetadata);
            this.iamConnectionMetadata(model.iamConnectionMetadata);
        }

        public final ReadAuthorizationCodeGrantMetadata.Builder getAuthorizationCodeGrantMetadata() {
            return this.authorizationCodeGrantMetadata != null ? this.authorizationCodeGrantMetadata.toBuilder() : null;
        }

        public final void setAuthorizationCodeGrantMetadata(ReadAuthorizationCodeGrantMetadata.BuilderImpl authorizationCodeGrantMetadata) {
            ReadAuthorizationCodeGrantMetadata oldValue = this.authorizationCodeGrantMetadata;
            this.authorizationCodeGrantMetadata = authorizationCodeGrantMetadata != null ? authorizationCodeGrantMetadata.build() : null;
            this.handleUnionValueChange(Type.AUTHORIZATION_CODE_GRANT_METADATA, oldValue, this.authorizationCodeGrantMetadata);
        }

        @Override
        public final Builder authorizationCodeGrantMetadata(ReadAuthorizationCodeGrantMetadata authorizationCodeGrantMetadata) {
            ReadAuthorizationCodeGrantMetadata oldValue = this.authorizationCodeGrantMetadata;
            this.authorizationCodeGrantMetadata = authorizationCodeGrantMetadata;
            this.handleUnionValueChange(Type.AUTHORIZATION_CODE_GRANT_METADATA, oldValue, this.authorizationCodeGrantMetadata);
            return this;
        }

        public final ReadClientCredentialsGrantMetadata.Builder getClientCredentialsGrantMetadata() {
            return this.clientCredentialsGrantMetadata != null ? this.clientCredentialsGrantMetadata.toBuilder() : null;
        }

        public final void setClientCredentialsGrantMetadata(ReadClientCredentialsGrantMetadata.BuilderImpl clientCredentialsGrantMetadata) {
            ReadClientCredentialsGrantMetadata oldValue = this.clientCredentialsGrantMetadata;
            this.clientCredentialsGrantMetadata = clientCredentialsGrantMetadata != null ? clientCredentialsGrantMetadata.build() : null;
            this.handleUnionValueChange(Type.CLIENT_CREDENTIALS_GRANT_METADATA, oldValue, this.clientCredentialsGrantMetadata);
        }

        @Override
        public final Builder clientCredentialsGrantMetadata(ReadClientCredentialsGrantMetadata clientCredentialsGrantMetadata) {
            ReadClientCredentialsGrantMetadata oldValue = this.clientCredentialsGrantMetadata;
            this.clientCredentialsGrantMetadata = clientCredentialsGrantMetadata;
            this.handleUnionValueChange(Type.CLIENT_CREDENTIALS_GRANT_METADATA, oldValue, this.clientCredentialsGrantMetadata);
            return this;
        }

        public final ReadBasicAuthConnectionMetadata.Builder getBasicAuthConnectionMetadata() {
            return this.basicAuthConnectionMetadata != null ? this.basicAuthConnectionMetadata.toBuilder() : null;
        }

        public final void setBasicAuthConnectionMetadata(ReadBasicAuthConnectionMetadata.BuilderImpl basicAuthConnectionMetadata) {
            ReadBasicAuthConnectionMetadata oldValue = this.basicAuthConnectionMetadata;
            this.basicAuthConnectionMetadata = basicAuthConnectionMetadata != null ? basicAuthConnectionMetadata.build() : null;
            this.handleUnionValueChange(Type.BASIC_AUTH_CONNECTION_METADATA, oldValue, this.basicAuthConnectionMetadata);
        }

        @Override
        public final Builder basicAuthConnectionMetadata(ReadBasicAuthConnectionMetadata basicAuthConnectionMetadata) {
            ReadBasicAuthConnectionMetadata oldValue = this.basicAuthConnectionMetadata;
            this.basicAuthConnectionMetadata = basicAuthConnectionMetadata;
            this.handleUnionValueChange(Type.BASIC_AUTH_CONNECTION_METADATA, oldValue, this.basicAuthConnectionMetadata);
            return this;
        }

        public final ReadAPIKeyConnectionMetadata.Builder getApiKeyConnectionMetadata() {
            return this.apiKeyConnectionMetadata != null ? this.apiKeyConnectionMetadata.toBuilder() : null;
        }

        public final void setApiKeyConnectionMetadata(ReadAPIKeyConnectionMetadata.BuilderImpl apiKeyConnectionMetadata) {
            ReadAPIKeyConnectionMetadata oldValue = this.apiKeyConnectionMetadata;
            this.apiKeyConnectionMetadata = apiKeyConnectionMetadata != null ? apiKeyConnectionMetadata.build() : null;
            this.handleUnionValueChange(Type.API_KEY_CONNECTION_METADATA, oldValue, this.apiKeyConnectionMetadata);
        }

        @Override
        public final Builder apiKeyConnectionMetadata(ReadAPIKeyConnectionMetadata apiKeyConnectionMetadata) {
            ReadAPIKeyConnectionMetadata oldValue = this.apiKeyConnectionMetadata;
            this.apiKeyConnectionMetadata = apiKeyConnectionMetadata;
            this.handleUnionValueChange(Type.API_KEY_CONNECTION_METADATA, oldValue, this.apiKeyConnectionMetadata);
            return this;
        }

        public final ReadNoneConnectionMetadata.Builder getNoneConnectionMetadata() {
            return this.noneConnectionMetadata != null ? this.noneConnectionMetadata.toBuilder() : null;
        }

        public final void setNoneConnectionMetadata(ReadNoneConnectionMetadata.BuilderImpl noneConnectionMetadata) {
            ReadNoneConnectionMetadata oldValue = this.noneConnectionMetadata;
            this.noneConnectionMetadata = noneConnectionMetadata != null ? noneConnectionMetadata.build() : null;
            this.handleUnionValueChange(Type.NONE_CONNECTION_METADATA, oldValue, this.noneConnectionMetadata);
        }

        @Override
        public final Builder noneConnectionMetadata(ReadNoneConnectionMetadata noneConnectionMetadata) {
            ReadNoneConnectionMetadata oldValue = this.noneConnectionMetadata;
            this.noneConnectionMetadata = noneConnectionMetadata;
            this.handleUnionValueChange(Type.NONE_CONNECTION_METADATA, oldValue, this.noneConnectionMetadata);
            return this;
        }

        public final ReadIamConnectionMetadata.Builder getIamConnectionMetadata() {
            return this.iamConnectionMetadata != null ? this.iamConnectionMetadata.toBuilder() : null;
        }

        public final void setIamConnectionMetadata(ReadIamConnectionMetadata.BuilderImpl iamConnectionMetadata) {
            ReadIamConnectionMetadata oldValue = this.iamConnectionMetadata;
            this.iamConnectionMetadata = iamConnectionMetadata != null ? iamConnectionMetadata.build() : null;
            this.handleUnionValueChange(Type.IAM_CONNECTION_METADATA, oldValue, this.iamConnectionMetadata);
        }

        @Override
        public final Builder iamConnectionMetadata(ReadIamConnectionMetadata iamConnectionMetadata) {
            ReadIamConnectionMetadata oldValue = this.iamConnectionMetadata;
            this.iamConnectionMetadata = iamConnectionMetadata;
            this.handleUnionValueChange(Type.IAM_CONNECTION_METADATA, oldValue, this.iamConnectionMetadata);
            return this;
        }

        public ReadAuthenticationMetadata build() {
            return new ReadAuthenticationMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReadAuthenticationMetadata> {
        public Builder authorizationCodeGrantMetadata(ReadAuthorizationCodeGrantMetadata var1);

        default public Builder authorizationCodeGrantMetadata(Consumer<ReadAuthorizationCodeGrantMetadata.Builder> authorizationCodeGrantMetadata) {
            return this.authorizationCodeGrantMetadata((ReadAuthorizationCodeGrantMetadata)((ReadAuthorizationCodeGrantMetadata.Builder)ReadAuthorizationCodeGrantMetadata.builder().applyMutation(authorizationCodeGrantMetadata)).build());
        }

        public Builder clientCredentialsGrantMetadata(ReadClientCredentialsGrantMetadata var1);

        default public Builder clientCredentialsGrantMetadata(Consumer<ReadClientCredentialsGrantMetadata.Builder> clientCredentialsGrantMetadata) {
            return this.clientCredentialsGrantMetadata((ReadClientCredentialsGrantMetadata)((ReadClientCredentialsGrantMetadata.Builder)ReadClientCredentialsGrantMetadata.builder().applyMutation(clientCredentialsGrantMetadata)).build());
        }

        public Builder basicAuthConnectionMetadata(ReadBasicAuthConnectionMetadata var1);

        default public Builder basicAuthConnectionMetadata(Consumer<ReadBasicAuthConnectionMetadata.Builder> basicAuthConnectionMetadata) {
            return this.basicAuthConnectionMetadata((ReadBasicAuthConnectionMetadata)((ReadBasicAuthConnectionMetadata.Builder)ReadBasicAuthConnectionMetadata.builder().applyMutation(basicAuthConnectionMetadata)).build());
        }

        public Builder apiKeyConnectionMetadata(ReadAPIKeyConnectionMetadata var1);

        default public Builder apiKeyConnectionMetadata(Consumer<ReadAPIKeyConnectionMetadata.Builder> apiKeyConnectionMetadata) {
            return this.apiKeyConnectionMetadata((ReadAPIKeyConnectionMetadata)((ReadAPIKeyConnectionMetadata.Builder)ReadAPIKeyConnectionMetadata.builder().applyMutation(apiKeyConnectionMetadata)).build());
        }

        public Builder noneConnectionMetadata(ReadNoneConnectionMetadata var1);

        default public Builder noneConnectionMetadata(Consumer<ReadNoneConnectionMetadata.Builder> noneConnectionMetadata) {
            return this.noneConnectionMetadata((ReadNoneConnectionMetadata)((ReadNoneConnectionMetadata.Builder)ReadNoneConnectionMetadata.builder().applyMutation(noneConnectionMetadata)).build());
        }

        public Builder iamConnectionMetadata(ReadIamConnectionMetadata var1);

        default public Builder iamConnectionMetadata(Consumer<ReadIamConnectionMetadata.Builder> iamConnectionMetadata) {
            return this.iamConnectionMetadata((ReadIamConnectionMetadata)((ReadIamConnectionMetadata.Builder)ReadIamConnectionMetadata.builder().applyMutation(iamConnectionMetadata)).build());
        }
    }
}

