/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.PivotConfiguration;
import software.amazon.awssdk.services.quicksight.model.PivotGroupByColumnNameListCopier;
import software.amazon.awssdk.services.quicksight.model.TransformOperationSource;
import software.amazon.awssdk.services.quicksight.model.ValueColumnConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PivotOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PivotOperation> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(PivotOperation.getter(PivotOperation::alias)).setter(PivotOperation.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<TransformOperationSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(PivotOperation.getter(PivotOperation::source)).setter(PivotOperation.setter(Builder::source)).constructor(TransformOperationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<String>> GROUP_BY_COLUMN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupByColumnNames").getter(PivotOperation.getter(PivotOperation::groupByColumnNames)).setter(PivotOperation.setter(Builder::groupByColumnNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByColumnNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ValueColumnConfiguration> VALUE_COLUMN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValueColumnConfiguration").getter(PivotOperation.getter(PivotOperation::valueColumnConfiguration)).setter(PivotOperation.setter(Builder::valueColumnConfiguration)).constructor(ValueColumnConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueColumnConfiguration").build()}).build();
    private static final SdkField<PivotConfiguration> PIVOT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PivotConfiguration").getter(PivotOperation.getter(PivotOperation::pivotConfiguration)).setter(PivotOperation.setter(Builder::pivotConfiguration)).constructor(PivotConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PivotConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, SOURCE_FIELD, GROUP_BY_COLUMN_NAMES_FIELD, VALUE_COLUMN_CONFIGURATION_FIELD, PIVOT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PivotOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alias;
    private final TransformOperationSource source;
    private final List<String> groupByColumnNames;
    private final ValueColumnConfiguration valueColumnConfiguration;
    private final PivotConfiguration pivotConfiguration;

    private PivotOperation(BuilderImpl builder) {
        this.alias = builder.alias;
        this.source = builder.source;
        this.groupByColumnNames = builder.groupByColumnNames;
        this.valueColumnConfiguration = builder.valueColumnConfiguration;
        this.pivotConfiguration = builder.pivotConfiguration;
    }

    public final String alias() {
        return this.alias;
    }

    public final TransformOperationSource source() {
        return this.source;
    }

    public final boolean hasGroupByColumnNames() {
        return this.groupByColumnNames != null && !(this.groupByColumnNames instanceof SdkAutoConstructList);
    }

    public final List<String> groupByColumnNames() {
        return this.groupByColumnNames;
    }

    public final ValueColumnConfiguration valueColumnConfiguration() {
        return this.valueColumnConfiguration;
    }

    public final PivotConfiguration pivotConfiguration() {
        return this.pivotConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupByColumnNames() ? this.groupByColumnNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.valueColumnConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.pivotConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotOperation)) {
            return false;
        }
        PivotOperation other = (PivotOperation)obj;
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.source(), other.source()) && this.hasGroupByColumnNames() == other.hasGroupByColumnNames() && Objects.equals(this.groupByColumnNames(), other.groupByColumnNames()) && Objects.equals(this.valueColumnConfiguration(), other.valueColumnConfiguration()) && Objects.equals(this.pivotConfiguration(), other.pivotConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"PivotOperation").add("Alias", (Object)this.alias()).add("Source", (Object)this.source()).add("GroupByColumnNames", this.hasGroupByColumnNames() ? this.groupByColumnNames() : null).add("ValueColumnConfiguration", (Object)this.valueColumnConfiguration()).add("PivotConfiguration", (Object)this.pivotConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "GroupByColumnNames": {
                return Optional.ofNullable(clazz.cast(this.groupByColumnNames()));
            }
            case "ValueColumnConfiguration": {
                return Optional.ofNullable(clazz.cast(this.valueColumnConfiguration()));
            }
            case "PivotConfiguration": {
                return Optional.ofNullable(clazz.cast(this.pivotConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Alias", ALIAS_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("GroupByColumnNames", GROUP_BY_COLUMN_NAMES_FIELD);
        map.put("ValueColumnConfiguration", VALUE_COLUMN_CONFIGURATION_FIELD);
        map.put("PivotConfiguration", PIVOT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotOperation, T> g) {
        return obj -> g.apply((PivotOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alias;
        private TransformOperationSource source;
        private List<String> groupByColumnNames = DefaultSdkAutoConstructList.getInstance();
        private ValueColumnConfiguration valueColumnConfiguration;
        private PivotConfiguration pivotConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotOperation model) {
            this.alias(model.alias);
            this.source(model.source);
            this.groupByColumnNames(model.groupByColumnNames);
            this.valueColumnConfiguration(model.valueColumnConfiguration);
            this.pivotConfiguration(model.pivotConfiguration);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final TransformOperationSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(TransformOperationSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TransformOperationSource source) {
            this.source = source;
            return this;
        }

        public final Collection<String> getGroupByColumnNames() {
            if (this.groupByColumnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupByColumnNames;
        }

        public final void setGroupByColumnNames(Collection<String> groupByColumnNames) {
            this.groupByColumnNames = PivotGroupByColumnNameListCopier.copy(groupByColumnNames);
        }

        @Override
        public final Builder groupByColumnNames(Collection<String> groupByColumnNames) {
            this.groupByColumnNames = PivotGroupByColumnNameListCopier.copy(groupByColumnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByColumnNames(String ... groupByColumnNames) {
            this.groupByColumnNames(Arrays.asList(groupByColumnNames));
            return this;
        }

        public final ValueColumnConfiguration.Builder getValueColumnConfiguration() {
            return this.valueColumnConfiguration != null ? this.valueColumnConfiguration.toBuilder() : null;
        }

        public final void setValueColumnConfiguration(ValueColumnConfiguration.BuilderImpl valueColumnConfiguration) {
            this.valueColumnConfiguration = valueColumnConfiguration != null ? valueColumnConfiguration.build() : null;
        }

        @Override
        public final Builder valueColumnConfiguration(ValueColumnConfiguration valueColumnConfiguration) {
            this.valueColumnConfiguration = valueColumnConfiguration;
            return this;
        }

        public final PivotConfiguration.Builder getPivotConfiguration() {
            return this.pivotConfiguration != null ? this.pivotConfiguration.toBuilder() : null;
        }

        public final void setPivotConfiguration(PivotConfiguration.BuilderImpl pivotConfiguration) {
            this.pivotConfiguration = pivotConfiguration != null ? pivotConfiguration.build() : null;
        }

        @Override
        public final Builder pivotConfiguration(PivotConfiguration pivotConfiguration) {
            this.pivotConfiguration = pivotConfiguration;
            return this;
        }

        public PivotOperation build() {
            return new PivotOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PivotOperation> {
        public Builder alias(String var1);

        public Builder source(TransformOperationSource var1);

        default public Builder source(Consumer<TransformOperationSource.Builder> source) {
            return this.source((TransformOperationSource)((TransformOperationSource.Builder)TransformOperationSource.builder().applyMutation(source)).build());
        }

        public Builder groupByColumnNames(Collection<String> var1);

        public Builder groupByColumnNames(String ... var1);

        public Builder valueColumnConfiguration(ValueColumnConfiguration var1);

        default public Builder valueColumnConfiguration(Consumer<ValueColumnConfiguration.Builder> valueColumnConfiguration) {
            return this.valueColumnConfiguration((ValueColumnConfiguration)((ValueColumnConfiguration.Builder)ValueColumnConfiguration.builder().applyMutation(valueColumnConfiguration)).build());
        }

        public Builder pivotConfiguration(PivotConfiguration var1);

        default public Builder pivotConfiguration(Consumer<PivotConfiguration.Builder> pivotConfiguration) {
            return this.pivotConfiguration((PivotConfiguration)((PivotConfiguration.Builder)PivotConfiguration.builder().applyMutation(pivotConfiguration)).build());
        }
    }
}

