/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.UserIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdentityContextRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, GetIdentityContextRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(GetIdentityContextRequest.getter(GetIdentityContextRequest::awsAccountId)).setter(GetIdentityContextRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<UserIdentifier> USER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserIdentifier").getter(GetIdentityContextRequest.getter(GetIdentityContextRequest::userIdentifier)).setter(GetIdentityContextRequest.setter(Builder::userIdentifier)).constructor(UserIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdentifier").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(GetIdentityContextRequest.getter(GetIdentityContextRequest::namespace)).setter(GetIdentityContextRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<Instant> SESSION_EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SessionExpiresAt").getter(GetIdentityContextRequest.getter(GetIdentityContextRequest::sessionExpiresAt)).setter(GetIdentityContextRequest.setter(Builder::sessionExpiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionExpiresAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, USER_IDENTIFIER_FIELD, NAMESPACE_FIELD, SESSION_EXPIRES_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIdentityContextRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final UserIdentifier userIdentifier;
    private final String namespace;
    private final Instant sessionExpiresAt;

    private GetIdentityContextRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.userIdentifier = builder.userIdentifier;
        this.namespace = builder.namespace;
        this.sessionExpiresAt = builder.sessionExpiresAt;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final UserIdentifier userIdentifier() {
        return this.userIdentifier;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final Instant sessionExpiresAt() {
        return this.sessionExpiresAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionExpiresAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityContextRequest)) {
            return false;
        }
        GetIdentityContextRequest other = (GetIdentityContextRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.userIdentifier(), other.userIdentifier()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.sessionExpiresAt(), other.sessionExpiresAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetIdentityContextRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("UserIdentifier", (Object)this.userIdentifier()).add("Namespace", (Object)this.namespace()).add("SessionExpiresAt", (Object)this.sessionExpiresAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "UserIdentifier": {
                return Optional.ofNullable(clazz.cast(this.userIdentifier()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "SessionExpiresAt": {
                return Optional.ofNullable(clazz.cast(this.sessionExpiresAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("UserIdentifier", USER_IDENTIFIER_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("SessionExpiresAt", SESSION_EXPIRES_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityContextRequest, T> g) {
        return obj -> g.apply((GetIdentityContextRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private UserIdentifier userIdentifier;
        private String namespace;
        private Instant sessionExpiresAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityContextRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.userIdentifier(model.userIdentifier);
            this.namespace(model.namespace);
            this.sessionExpiresAt(model.sessionExpiresAt);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final UserIdentifier.Builder getUserIdentifier() {
            return this.userIdentifier != null ? this.userIdentifier.toBuilder() : null;
        }

        public final void setUserIdentifier(UserIdentifier.BuilderImpl userIdentifier) {
            this.userIdentifier = userIdentifier != null ? userIdentifier.build() : null;
        }

        @Override
        public final Builder userIdentifier(UserIdentifier userIdentifier) {
            this.userIdentifier = userIdentifier;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final Instant getSessionExpiresAt() {
            return this.sessionExpiresAt;
        }

        public final void setSessionExpiresAt(Instant sessionExpiresAt) {
            this.sessionExpiresAt = sessionExpiresAt;
        }

        @Override
        public final Builder sessionExpiresAt(Instant sessionExpiresAt) {
            this.sessionExpiresAt = sessionExpiresAt;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIdentityContextRequest build() {
            return new GetIdentityContextRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIdentityContextRequest> {
        public Builder awsAccountId(String var1);

        public Builder userIdentifier(UserIdentifier var1);

        default public Builder userIdentifier(Consumer<UserIdentifier.Builder> userIdentifier) {
            return this.userIdentifier((UserIdentifier)((UserIdentifier.Builder)UserIdentifier.builder().applyMutation(userIdentifier)).build());
        }

        public Builder namespace(String var1);

        public Builder sessionExpiresAt(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

