/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.Permission;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateFlowPermissionsInputGrantPermissionsListCopier;
import software.amazon.awssdk.services.quicksight.model.UpdateFlowPermissionsInputRevokePermissionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFlowPermissionsRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateFlowPermissionsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateFlowPermissionsRequest.getter(UpdateFlowPermissionsRequest::awsAccountId)).setter(UpdateFlowPermissionsRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowId").getter(UpdateFlowPermissionsRequest.getter(UpdateFlowPermissionsRequest::flowId)).setter(UpdateFlowPermissionsRequest.setter(Builder::flowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FlowId").build()}).build();
    private static final SdkField<List<Permission>> GRANT_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GrantPermissions").getter(UpdateFlowPermissionsRequest.getter(UpdateFlowPermissionsRequest::grantPermissions)).setter(UpdateFlowPermissionsRequest.setter(Builder::grantPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Permission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Permission>> REVOKE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RevokePermissions").getter(UpdateFlowPermissionsRequest.getter(UpdateFlowPermissionsRequest::revokePermissions)).setter(UpdateFlowPermissionsRequest.setter(Builder::revokePermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokePermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Permission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, FLOW_ID_FIELD, GRANT_PERMISSIONS_FIELD, REVOKE_PERMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFlowPermissionsRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String flowId;
    private final List<Permission> grantPermissions;
    private final List<Permission> revokePermissions;

    private UpdateFlowPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.flowId = builder.flowId;
        this.grantPermissions = builder.grantPermissions;
        this.revokePermissions = builder.revokePermissions;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String flowId() {
        return this.flowId;
    }

    public final boolean hasGrantPermissions() {
        return this.grantPermissions != null && !(this.grantPermissions instanceof SdkAutoConstructList);
    }

    public final List<Permission> grantPermissions() {
        return this.grantPermissions;
    }

    public final boolean hasRevokePermissions() {
        return this.revokePermissions != null && !(this.revokePermissions instanceof SdkAutoConstructList);
    }

    public final List<Permission> revokePermissions() {
        return this.revokePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantPermissions() ? this.grantPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevokePermissions() ? this.revokePermissions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowPermissionsRequest)) {
            return false;
        }
        UpdateFlowPermissionsRequest other = (UpdateFlowPermissionsRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.flowId(), other.flowId()) && this.hasGrantPermissions() == other.hasGrantPermissions() && Objects.equals(this.grantPermissions(), other.grantPermissions()) && this.hasRevokePermissions() == other.hasRevokePermissions() && Objects.equals(this.revokePermissions(), other.revokePermissions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFlowPermissionsRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("FlowId", (Object)this.flowId()).add("GrantPermissions", this.hasGrantPermissions() ? this.grantPermissions() : null).add("RevokePermissions", this.hasRevokePermissions() ? this.revokePermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "FlowId": {
                return Optional.ofNullable(clazz.cast(this.flowId()));
            }
            case "GrantPermissions": {
                return Optional.ofNullable(clazz.cast(this.grantPermissions()));
            }
            case "RevokePermissions": {
                return Optional.ofNullable(clazz.cast(this.revokePermissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("FlowId", FLOW_ID_FIELD);
        map.put("GrantPermissions", GRANT_PERMISSIONS_FIELD);
        map.put("RevokePermissions", REVOKE_PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowPermissionsRequest, T> g) {
        return obj -> g.apply((UpdateFlowPermissionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String flowId;
        private List<Permission> grantPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<Permission> revokePermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowPermissionsRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.flowId(model.flowId);
            this.grantPermissions(model.grantPermissions);
            this.revokePermissions(model.revokePermissions);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getFlowId() {
            return this.flowId;
        }

        public final void setFlowId(String flowId) {
            this.flowId = flowId;
        }

        @Override
        public final Builder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        public final List<Permission.Builder> getGrantPermissions() {
            List<Permission.Builder> result = UpdateFlowPermissionsInputGrantPermissionsListCopier.copyToBuilder(this.grantPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGrantPermissions(Collection<Permission.BuilderImpl> grantPermissions) {
            this.grantPermissions = UpdateFlowPermissionsInputGrantPermissionsListCopier.copyFromBuilder(grantPermissions);
        }

        @Override
        public final Builder grantPermissions(Collection<Permission> grantPermissions) {
            this.grantPermissions = UpdateFlowPermissionsInputGrantPermissionsListCopier.copy(grantPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(Permission ... grantPermissions) {
            this.grantPermissions(Arrays.asList(grantPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(Consumer<Permission.Builder> ... grantPermissions) {
            this.grantPermissions(Stream.of(grantPermissions).map(c -> (Permission)((Permission.Builder)Permission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Permission.Builder> getRevokePermissions() {
            List<Permission.Builder> result = UpdateFlowPermissionsInputRevokePermissionsListCopier.copyToBuilder(this.revokePermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevokePermissions(Collection<Permission.BuilderImpl> revokePermissions) {
            this.revokePermissions = UpdateFlowPermissionsInputRevokePermissionsListCopier.copyFromBuilder(revokePermissions);
        }

        @Override
        public final Builder revokePermissions(Collection<Permission> revokePermissions) {
            this.revokePermissions = UpdateFlowPermissionsInputRevokePermissionsListCopier.copy(revokePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(Permission ... revokePermissions) {
            this.revokePermissions(Arrays.asList(revokePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(Consumer<Permission.Builder> ... revokePermissions) {
            this.revokePermissions(Stream.of(revokePermissions).map(c -> (Permission)((Permission.Builder)Permission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowPermissionsRequest build() {
            return new UpdateFlowPermissionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFlowPermissionsRequest> {
        public Builder awsAccountId(String var1);

        public Builder flowId(String var1);

        public Builder grantPermissions(Collection<Permission> var1);

        public Builder grantPermissions(Permission ... var1);

        public Builder grantPermissions(Consumer<Permission.Builder> ... var1);

        public Builder revokePermissions(Collection<Permission> var1);

        public Builder revokePermissions(Permission ... var1);

        public Builder revokePermissions(Consumer<Permission.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

