/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DecalSettings;
import software.amazon.awssdk.services.quicksight.model.DecalSettingsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DecalSettingsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DecalSettingsConfiguration> {
    private static final SdkField<List<DecalSettings>> CUSTOM_DECAL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomDecalSettings").getter(DecalSettingsConfiguration.getter(DecalSettingsConfiguration::customDecalSettings)).setter(DecalSettingsConfiguration.setter(Builder::customDecalSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDecalSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DecalSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DECAL_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DecalSettingsConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<DecalSettings> customDecalSettings;

    private DecalSettingsConfiguration(BuilderImpl builder) {
        this.customDecalSettings = builder.customDecalSettings;
    }

    public final boolean hasCustomDecalSettings() {
        return this.customDecalSettings != null && !(this.customDecalSettings instanceof SdkAutoConstructList);
    }

    public final List<DecalSettings> customDecalSettings() {
        return this.customDecalSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomDecalSettings() ? this.customDecalSettings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecalSettingsConfiguration)) {
            return false;
        }
        DecalSettingsConfiguration other = (DecalSettingsConfiguration)obj;
        return this.hasCustomDecalSettings() == other.hasCustomDecalSettings() && Objects.equals(this.customDecalSettings(), other.customDecalSettings());
    }

    public final String toString() {
        return ToString.builder((String)"DecalSettingsConfiguration").add("CustomDecalSettings", this.hasCustomDecalSettings() ? this.customDecalSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomDecalSettings": {
                return Optional.ofNullable(clazz.cast(this.customDecalSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<DecalSettings>>> map = new HashMap<String, SdkField<List<DecalSettings>>>();
        map.put("CustomDecalSettings", CUSTOM_DECAL_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DecalSettingsConfiguration, T> g) {
        return obj -> g.apply((DecalSettingsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DecalSettings> customDecalSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DecalSettingsConfiguration model) {
            this.customDecalSettings(model.customDecalSettings);
        }

        public final List<DecalSettings.Builder> getCustomDecalSettings() {
            List<DecalSettings.Builder> result = DecalSettingsListCopier.copyToBuilder(this.customDecalSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomDecalSettings(Collection<DecalSettings.BuilderImpl> customDecalSettings) {
            this.customDecalSettings = DecalSettingsListCopier.copyFromBuilder(customDecalSettings);
        }

        @Override
        public final Builder customDecalSettings(Collection<DecalSettings> customDecalSettings) {
            this.customDecalSettings = DecalSettingsListCopier.copy(customDecalSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDecalSettings(DecalSettings ... customDecalSettings) {
            this.customDecalSettings(Arrays.asList(customDecalSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDecalSettings(Consumer<DecalSettings.Builder> ... customDecalSettings) {
            this.customDecalSettings(Stream.of(customDecalSettings).map(c -> (DecalSettings)((DecalSettings.Builder)DecalSettings.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DecalSettingsConfiguration build() {
            return new DecalSettingsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DecalSettingsConfiguration> {
        public Builder customDecalSettings(Collection<DecalSettings> var1);

        public Builder customDecalSettings(DecalSettings ... var1);

        public Builder customDecalSettings(Consumer<DecalSettings.Builder> ... var1);
    }
}

