/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CapabilityState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Capabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Capabilities> {
    private static final SdkField<String> EXPORT_TO_CSV_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportToCsv").getter(Capabilities.getter(Capabilities::exportToCsvAsString)).setter(Capabilities.setter(Builder::exportToCsv)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToCsv").build()}).build();
    private static final SdkField<String> EXPORT_TO_EXCEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportToExcel").getter(Capabilities.getter(Capabilities::exportToExcelAsString)).setter(Capabilities.setter(Builder::exportToExcel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToExcel").build()}).build();
    private static final SdkField<String> EXPORT_TO_PDF_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportToPdf").getter(Capabilities.getter(Capabilities::exportToPdfAsString)).setter(Capabilities.setter(Builder::exportToPdf)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToPdf").build()}).build();
    private static final SdkField<String> PRINT_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrintReports").getter(Capabilities.getter(Capabilities::printReportsAsString)).setter(Capabilities.setter(Builder::printReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrintReports").build()}).build();
    private static final SdkField<String> CREATE_AND_UPDATE_THEMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateAndUpdateThemes").getter(Capabilities.getter(Capabilities::createAndUpdateThemesAsString)).setter(Capabilities.setter(Builder::createAndUpdateThemes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAndUpdateThemes").build()}).build();
    private static final SdkField<String> ADD_OR_RUN_ANOMALY_DETECTION_FOR_ANALYSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddOrRunAnomalyDetectionForAnalyses").getter(Capabilities.getter(Capabilities::addOrRunAnomalyDetectionForAnalysesAsString)).setter(Capabilities.setter(Builder::addOrRunAnomalyDetectionForAnalyses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddOrRunAnomalyDetectionForAnalyses").build()}).build();
    private static final SdkField<String> SHARE_ANALYSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareAnalyses").getter(Capabilities.getter(Capabilities::shareAnalysesAsString)).setter(Capabilities.setter(Builder::shareAnalyses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareAnalyses").build()}).build();
    private static final SdkField<String> CREATE_AND_UPDATE_DATASETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateAndUpdateDatasets").getter(Capabilities.getter(Capabilities::createAndUpdateDatasetsAsString)).setter(Capabilities.setter(Builder::createAndUpdateDatasets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAndUpdateDatasets").build()}).build();
    private static final SdkField<String> SHARE_DATASETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareDatasets").getter(Capabilities.getter(Capabilities::shareDatasetsAsString)).setter(Capabilities.setter(Builder::shareDatasets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareDatasets").build()}).build();
    private static final SdkField<String> SUBSCRIBE_DASHBOARD_EMAIL_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscribeDashboardEmailReports").getter(Capabilities.getter(Capabilities::subscribeDashboardEmailReportsAsString)).setter(Capabilities.setter(Builder::subscribeDashboardEmailReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribeDashboardEmailReports").build()}).build();
    private static final SdkField<String> CREATE_AND_UPDATE_DASHBOARD_EMAIL_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateAndUpdateDashboardEmailReports").getter(Capabilities.getter(Capabilities::createAndUpdateDashboardEmailReportsAsString)).setter(Capabilities.setter(Builder::createAndUpdateDashboardEmailReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAndUpdateDashboardEmailReports").build()}).build();
    private static final SdkField<String> SHARE_DASHBOARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareDashboards").getter(Capabilities.getter(Capabilities::shareDashboardsAsString)).setter(Capabilities.setter(Builder::shareDashboards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareDashboards").build()}).build();
    private static final SdkField<String> CREATE_AND_UPDATE_THRESHOLD_ALERTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateAndUpdateThresholdAlerts").getter(Capabilities.getter(Capabilities::createAndUpdateThresholdAlertsAsString)).setter(Capabilities.setter(Builder::createAndUpdateThresholdAlerts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAndUpdateThresholdAlerts").build()}).build();
    private static final SdkField<String> RENAME_SHARED_FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenameSharedFolders").getter(Capabilities.getter(Capabilities::renameSharedFoldersAsString)).setter(Capabilities.setter(Builder::renameSharedFolders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenameSharedFolders").build()}).build();
    private static final SdkField<String> CREATE_SHARED_FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateSharedFolders").getter(Capabilities.getter(Capabilities::createSharedFoldersAsString)).setter(Capabilities.setter(Builder::createSharedFolders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateSharedFolders").build()}).build();
    private static final SdkField<String> CREATE_AND_UPDATE_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateAndUpdateDataSources").getter(Capabilities.getter(Capabilities::createAndUpdateDataSourcesAsString)).setter(Capabilities.setter(Builder::createAndUpdateDataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAndUpdateDataSources").build()}).build();
    private static final SdkField<String> SHARE_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareDataSources").getter(Capabilities.getter(Capabilities::shareDataSourcesAsString)).setter(Capabilities.setter(Builder::shareDataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareDataSources").build()}).build();
    private static final SdkField<String> VIEW_ACCOUNT_SPICE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewAccountSPICECapacity").getter(Capabilities.getter(Capabilities::viewAccountSPICECapacityAsString)).setter(Capabilities.setter(Builder::viewAccountSPICECapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewAccountSPICECapacity").build()}).build();
    private static final SdkField<String> CREATE_SPICE_DATASET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateSPICEDataset").getter(Capabilities.getter(Capabilities::createSPICEDatasetAsString)).setter(Capabilities.setter(Builder::createSPICEDataset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateSPICEDataset").build()}).build();
    private static final SdkField<String> EXPORT_TO_PDF_IN_SCHEDULED_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportToPdfInScheduledReports").getter(Capabilities.getter(Capabilities::exportToPdfInScheduledReportsAsString)).setter(Capabilities.setter(Builder::exportToPdfInScheduledReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToPdfInScheduledReports").build()}).build();
    private static final SdkField<String> EXPORT_TO_CSV_IN_SCHEDULED_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportToCsvInScheduledReports").getter(Capabilities.getter(Capabilities::exportToCsvInScheduledReportsAsString)).setter(Capabilities.setter(Builder::exportToCsvInScheduledReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToCsvInScheduledReports").build()}).build();
    private static final SdkField<String> EXPORT_TO_EXCEL_IN_SCHEDULED_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportToExcelInScheduledReports").getter(Capabilities.getter(Capabilities::exportToExcelInScheduledReportsAsString)).setter(Capabilities.setter(Builder::exportToExcelInScheduledReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToExcelInScheduledReports").build()}).build();
    private static final SdkField<String> INCLUDE_CONTENT_IN_SCHEDULED_REPORTS_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncludeContentInScheduledReportsEmail").getter(Capabilities.getter(Capabilities::includeContentInScheduledReportsEmailAsString)).setter(Capabilities.setter(Builder::includeContentInScheduledReportsEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeContentInScheduledReportsEmail").build()}).build();
    private static final SdkField<String> DASHBOARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Dashboard").getter(Capabilities.getter(Capabilities::dashboardAsString)).setter(Capabilities.setter(Builder::dashboard)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dashboard").build()}).build();
    private static final SdkField<String> ANALYSIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Analysis").getter(Capabilities.getter(Capabilities::analysisAsString)).setter(Capabilities.setter(Builder::analysis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analysis").build()}).build();
    private static final SdkField<String> AUTOMATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Automate").getter(Capabilities.getter(Capabilities::automateAsString)).setter(Capabilities.setter(Builder::automate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Automate").build()}).build();
    private static final SdkField<String> FLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Flow").getter(Capabilities.getter(Capabilities::flowAsString)).setter(Capabilities.setter(Builder::flow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flow").build()}).build();
    private static final SdkField<String> PUBLISH_WITHOUT_APPROVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublishWithoutApproval").getter(Capabilities.getter(Capabilities::publishWithoutApprovalAsString)).setter(Capabilities.setter(Builder::publishWithoutApproval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishWithoutApproval").build()}).build();
    private static final SdkField<String> USE_BEDROCK_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UseBedrockModels").getter(Capabilities.getter(Capabilities::useBedrockModelsAsString)).setter(Capabilities.setter(Builder::useBedrockModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseBedrockModels").build()}).build();
    private static final SdkField<String> PERFORM_FLOW_UI_TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerformFlowUiTask").getter(Capabilities.getter(Capabilities::performFlowUiTaskAsString)).setter(Capabilities.setter(Builder::performFlowUiTask)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformFlowUiTask").build()}).build();
    private static final SdkField<String> USE_AGENT_WEB_SEARCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UseAgentWebSearch").getter(Capabilities.getter(Capabilities::useAgentWebSearchAsString)).setter(Capabilities.setter(Builder::useAgentWebSearch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseAgentWebSearch").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KnowledgeBase").getter(Capabilities.getter(Capabilities::knowledgeBaseAsString)).setter(Capabilities.setter(Builder::knowledgeBase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnowledgeBase").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(Capabilities.getter(Capabilities::actionAsString)).setter(Capabilities.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> SPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Space").getter(Capabilities.getter(Capabilities::spaceAsString)).setter(Capabilities.setter(Builder::space)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Space").build()}).build();
    private static final SdkField<String> CHAT_AGENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChatAgent").getter(Capabilities.getter(Capabilities::chatAgentAsString)).setter(Capabilities.setter(Builder::chatAgent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatAgent").build()}).build();
    private static final SdkField<String> CREATE_CHAT_AGENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateChatAgents").getter(Capabilities.getter(Capabilities::createChatAgentsAsString)).setter(Capabilities.setter(Builder::createChatAgents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateChatAgents").build()}).build();
    private static final SdkField<String> RESEARCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Research").getter(Capabilities.getter(Capabilities::researchAsString)).setter(Capabilities.setter(Builder::research)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Research").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TO_CSV_FIELD, EXPORT_TO_EXCEL_FIELD, EXPORT_TO_PDF_FIELD, PRINT_REPORTS_FIELD, CREATE_AND_UPDATE_THEMES_FIELD, ADD_OR_RUN_ANOMALY_DETECTION_FOR_ANALYSES_FIELD, SHARE_ANALYSES_FIELD, CREATE_AND_UPDATE_DATASETS_FIELD, SHARE_DATASETS_FIELD, SUBSCRIBE_DASHBOARD_EMAIL_REPORTS_FIELD, CREATE_AND_UPDATE_DASHBOARD_EMAIL_REPORTS_FIELD, SHARE_DASHBOARDS_FIELD, CREATE_AND_UPDATE_THRESHOLD_ALERTS_FIELD, RENAME_SHARED_FOLDERS_FIELD, CREATE_SHARED_FOLDERS_FIELD, CREATE_AND_UPDATE_DATA_SOURCES_FIELD, SHARE_DATA_SOURCES_FIELD, VIEW_ACCOUNT_SPICE_CAPACITY_FIELD, CREATE_SPICE_DATASET_FIELD, EXPORT_TO_PDF_IN_SCHEDULED_REPORTS_FIELD, EXPORT_TO_CSV_IN_SCHEDULED_REPORTS_FIELD, EXPORT_TO_EXCEL_IN_SCHEDULED_REPORTS_FIELD, INCLUDE_CONTENT_IN_SCHEDULED_REPORTS_EMAIL_FIELD, DASHBOARD_FIELD, ANALYSIS_FIELD, AUTOMATE_FIELD, FLOW_FIELD, PUBLISH_WITHOUT_APPROVAL_FIELD, USE_BEDROCK_MODELS_FIELD, PERFORM_FLOW_UI_TASK_FIELD, USE_AGENT_WEB_SEARCH_FIELD, KNOWLEDGE_BASE_FIELD, ACTION_FIELD, SPACE_FIELD, CHAT_AGENT_FIELD, CREATE_CHAT_AGENTS_FIELD, RESEARCH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Capabilities.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String exportToCsv;
    private final String exportToExcel;
    private final String exportToPdf;
    private final String printReports;
    private final String createAndUpdateThemes;
    private final String addOrRunAnomalyDetectionForAnalyses;
    private final String shareAnalyses;
    private final String createAndUpdateDatasets;
    private final String shareDatasets;
    private final String subscribeDashboardEmailReports;
    private final String createAndUpdateDashboardEmailReports;
    private final String shareDashboards;
    private final String createAndUpdateThresholdAlerts;
    private final String renameSharedFolders;
    private final String createSharedFolders;
    private final String createAndUpdateDataSources;
    private final String shareDataSources;
    private final String viewAccountSPICECapacity;
    private final String createSPICEDataset;
    private final String exportToPdfInScheduledReports;
    private final String exportToCsvInScheduledReports;
    private final String exportToExcelInScheduledReports;
    private final String includeContentInScheduledReportsEmail;
    private final String dashboard;
    private final String analysis;
    private final String automate;
    private final String flow;
    private final String publishWithoutApproval;
    private final String useBedrockModels;
    private final String performFlowUiTask;
    private final String useAgentWebSearch;
    private final String knowledgeBase;
    private final String action;
    private final String space;
    private final String chatAgent;
    private final String createChatAgents;
    private final String research;

    private Capabilities(BuilderImpl builder) {
        this.exportToCsv = builder.exportToCsv;
        this.exportToExcel = builder.exportToExcel;
        this.exportToPdf = builder.exportToPdf;
        this.printReports = builder.printReports;
        this.createAndUpdateThemes = builder.createAndUpdateThemes;
        this.addOrRunAnomalyDetectionForAnalyses = builder.addOrRunAnomalyDetectionForAnalyses;
        this.shareAnalyses = builder.shareAnalyses;
        this.createAndUpdateDatasets = builder.createAndUpdateDatasets;
        this.shareDatasets = builder.shareDatasets;
        this.subscribeDashboardEmailReports = builder.subscribeDashboardEmailReports;
        this.createAndUpdateDashboardEmailReports = builder.createAndUpdateDashboardEmailReports;
        this.shareDashboards = builder.shareDashboards;
        this.createAndUpdateThresholdAlerts = builder.createAndUpdateThresholdAlerts;
        this.renameSharedFolders = builder.renameSharedFolders;
        this.createSharedFolders = builder.createSharedFolders;
        this.createAndUpdateDataSources = builder.createAndUpdateDataSources;
        this.shareDataSources = builder.shareDataSources;
        this.viewAccountSPICECapacity = builder.viewAccountSPICECapacity;
        this.createSPICEDataset = builder.createSPICEDataset;
        this.exportToPdfInScheduledReports = builder.exportToPdfInScheduledReports;
        this.exportToCsvInScheduledReports = builder.exportToCsvInScheduledReports;
        this.exportToExcelInScheduledReports = builder.exportToExcelInScheduledReports;
        this.includeContentInScheduledReportsEmail = builder.includeContentInScheduledReportsEmail;
        this.dashboard = builder.dashboard;
        this.analysis = builder.analysis;
        this.automate = builder.automate;
        this.flow = builder.flow;
        this.publishWithoutApproval = builder.publishWithoutApproval;
        this.useBedrockModels = builder.useBedrockModels;
        this.performFlowUiTask = builder.performFlowUiTask;
        this.useAgentWebSearch = builder.useAgentWebSearch;
        this.knowledgeBase = builder.knowledgeBase;
        this.action = builder.action;
        this.space = builder.space;
        this.chatAgent = builder.chatAgent;
        this.createChatAgents = builder.createChatAgents;
        this.research = builder.research;
    }

    public final CapabilityState exportToCsv() {
        return CapabilityState.fromValue(this.exportToCsv);
    }

    public final String exportToCsvAsString() {
        return this.exportToCsv;
    }

    public final CapabilityState exportToExcel() {
        return CapabilityState.fromValue(this.exportToExcel);
    }

    public final String exportToExcelAsString() {
        return this.exportToExcel;
    }

    public final CapabilityState exportToPdf() {
        return CapabilityState.fromValue(this.exportToPdf);
    }

    public final String exportToPdfAsString() {
        return this.exportToPdf;
    }

    public final CapabilityState printReports() {
        return CapabilityState.fromValue(this.printReports);
    }

    public final String printReportsAsString() {
        return this.printReports;
    }

    public final CapabilityState createAndUpdateThemes() {
        return CapabilityState.fromValue(this.createAndUpdateThemes);
    }

    public final String createAndUpdateThemesAsString() {
        return this.createAndUpdateThemes;
    }

    public final CapabilityState addOrRunAnomalyDetectionForAnalyses() {
        return CapabilityState.fromValue(this.addOrRunAnomalyDetectionForAnalyses);
    }

    public final String addOrRunAnomalyDetectionForAnalysesAsString() {
        return this.addOrRunAnomalyDetectionForAnalyses;
    }

    public final CapabilityState shareAnalyses() {
        return CapabilityState.fromValue(this.shareAnalyses);
    }

    public final String shareAnalysesAsString() {
        return this.shareAnalyses;
    }

    public final CapabilityState createAndUpdateDatasets() {
        return CapabilityState.fromValue(this.createAndUpdateDatasets);
    }

    public final String createAndUpdateDatasetsAsString() {
        return this.createAndUpdateDatasets;
    }

    public final CapabilityState shareDatasets() {
        return CapabilityState.fromValue(this.shareDatasets);
    }

    public final String shareDatasetsAsString() {
        return this.shareDatasets;
    }

    public final CapabilityState subscribeDashboardEmailReports() {
        return CapabilityState.fromValue(this.subscribeDashboardEmailReports);
    }

    public final String subscribeDashboardEmailReportsAsString() {
        return this.subscribeDashboardEmailReports;
    }

    public final CapabilityState createAndUpdateDashboardEmailReports() {
        return CapabilityState.fromValue(this.createAndUpdateDashboardEmailReports);
    }

    public final String createAndUpdateDashboardEmailReportsAsString() {
        return this.createAndUpdateDashboardEmailReports;
    }

    public final CapabilityState shareDashboards() {
        return CapabilityState.fromValue(this.shareDashboards);
    }

    public final String shareDashboardsAsString() {
        return this.shareDashboards;
    }

    public final CapabilityState createAndUpdateThresholdAlerts() {
        return CapabilityState.fromValue(this.createAndUpdateThresholdAlerts);
    }

    public final String createAndUpdateThresholdAlertsAsString() {
        return this.createAndUpdateThresholdAlerts;
    }

    public final CapabilityState renameSharedFolders() {
        return CapabilityState.fromValue(this.renameSharedFolders);
    }

    public final String renameSharedFoldersAsString() {
        return this.renameSharedFolders;
    }

    public final CapabilityState createSharedFolders() {
        return CapabilityState.fromValue(this.createSharedFolders);
    }

    public final String createSharedFoldersAsString() {
        return this.createSharedFolders;
    }

    public final CapabilityState createAndUpdateDataSources() {
        return CapabilityState.fromValue(this.createAndUpdateDataSources);
    }

    public final String createAndUpdateDataSourcesAsString() {
        return this.createAndUpdateDataSources;
    }

    public final CapabilityState shareDataSources() {
        return CapabilityState.fromValue(this.shareDataSources);
    }

    public final String shareDataSourcesAsString() {
        return this.shareDataSources;
    }

    public final CapabilityState viewAccountSPICECapacity() {
        return CapabilityState.fromValue(this.viewAccountSPICECapacity);
    }

    public final String viewAccountSPICECapacityAsString() {
        return this.viewAccountSPICECapacity;
    }

    public final CapabilityState createSPICEDataset() {
        return CapabilityState.fromValue(this.createSPICEDataset);
    }

    public final String createSPICEDatasetAsString() {
        return this.createSPICEDataset;
    }

    public final CapabilityState exportToPdfInScheduledReports() {
        return CapabilityState.fromValue(this.exportToPdfInScheduledReports);
    }

    public final String exportToPdfInScheduledReportsAsString() {
        return this.exportToPdfInScheduledReports;
    }

    public final CapabilityState exportToCsvInScheduledReports() {
        return CapabilityState.fromValue(this.exportToCsvInScheduledReports);
    }

    public final String exportToCsvInScheduledReportsAsString() {
        return this.exportToCsvInScheduledReports;
    }

    public final CapabilityState exportToExcelInScheduledReports() {
        return CapabilityState.fromValue(this.exportToExcelInScheduledReports);
    }

    public final String exportToExcelInScheduledReportsAsString() {
        return this.exportToExcelInScheduledReports;
    }

    public final CapabilityState includeContentInScheduledReportsEmail() {
        return CapabilityState.fromValue(this.includeContentInScheduledReportsEmail);
    }

    public final String includeContentInScheduledReportsEmailAsString() {
        return this.includeContentInScheduledReportsEmail;
    }

    public final CapabilityState dashboard() {
        return CapabilityState.fromValue(this.dashboard);
    }

    public final String dashboardAsString() {
        return this.dashboard;
    }

    public final CapabilityState analysis() {
        return CapabilityState.fromValue(this.analysis);
    }

    public final String analysisAsString() {
        return this.analysis;
    }

    public final CapabilityState automate() {
        return CapabilityState.fromValue(this.automate);
    }

    public final String automateAsString() {
        return this.automate;
    }

    public final CapabilityState flow() {
        return CapabilityState.fromValue(this.flow);
    }

    public final String flowAsString() {
        return this.flow;
    }

    public final CapabilityState publishWithoutApproval() {
        return CapabilityState.fromValue(this.publishWithoutApproval);
    }

    public final String publishWithoutApprovalAsString() {
        return this.publishWithoutApproval;
    }

    public final CapabilityState useBedrockModels() {
        return CapabilityState.fromValue(this.useBedrockModels);
    }

    public final String useBedrockModelsAsString() {
        return this.useBedrockModels;
    }

    public final CapabilityState performFlowUiTask() {
        return CapabilityState.fromValue(this.performFlowUiTask);
    }

    public final String performFlowUiTaskAsString() {
        return this.performFlowUiTask;
    }

    public final CapabilityState useAgentWebSearch() {
        return CapabilityState.fromValue(this.useAgentWebSearch);
    }

    public final String useAgentWebSearchAsString() {
        return this.useAgentWebSearch;
    }

    public final CapabilityState knowledgeBase() {
        return CapabilityState.fromValue(this.knowledgeBase);
    }

    public final String knowledgeBaseAsString() {
        return this.knowledgeBase;
    }

    public final CapabilityState action() {
        return CapabilityState.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final CapabilityState space() {
        return CapabilityState.fromValue(this.space);
    }

    public final String spaceAsString() {
        return this.space;
    }

    public final CapabilityState chatAgent() {
        return CapabilityState.fromValue(this.chatAgent);
    }

    public final String chatAgentAsString() {
        return this.chatAgent;
    }

    public final CapabilityState createChatAgents() {
        return CapabilityState.fromValue(this.createChatAgents);
    }

    public final String createChatAgentsAsString() {
        return this.createChatAgents;
    }

    public final CapabilityState research() {
        return CapabilityState.fromValue(this.research);
    }

    public final String researchAsString() {
        return this.research;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToCsvAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToExcelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToPdfAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.printReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createAndUpdateThemesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.addOrRunAnomalyDetectionForAnalysesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareAnalysesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createAndUpdateDatasetsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareDatasetsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribeDashboardEmailReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createAndUpdateDashboardEmailReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareDashboardsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createAndUpdateThresholdAlertsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.renameSharedFoldersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createSharedFoldersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createAndUpdateDataSourcesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareDataSourcesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewAccountSPICECapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createSPICEDatasetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToPdfInScheduledReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToCsvInScheduledReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToExcelInScheduledReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeContentInScheduledReportsEmailAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.automateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishWithoutApprovalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.useBedrockModelsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.performFlowUiTaskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.useAgentWebSearchAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.chatAgentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createChatAgentsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.researchAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Capabilities)) {
            return false;
        }
        Capabilities other = (Capabilities)obj;
        return Objects.equals(this.exportToCsvAsString(), other.exportToCsvAsString()) && Objects.equals(this.exportToExcelAsString(), other.exportToExcelAsString()) && Objects.equals(this.exportToPdfAsString(), other.exportToPdfAsString()) && Objects.equals(this.printReportsAsString(), other.printReportsAsString()) && Objects.equals(this.createAndUpdateThemesAsString(), other.createAndUpdateThemesAsString()) && Objects.equals(this.addOrRunAnomalyDetectionForAnalysesAsString(), other.addOrRunAnomalyDetectionForAnalysesAsString()) && Objects.equals(this.shareAnalysesAsString(), other.shareAnalysesAsString()) && Objects.equals(this.createAndUpdateDatasetsAsString(), other.createAndUpdateDatasetsAsString()) && Objects.equals(this.shareDatasetsAsString(), other.shareDatasetsAsString()) && Objects.equals(this.subscribeDashboardEmailReportsAsString(), other.subscribeDashboardEmailReportsAsString()) && Objects.equals(this.createAndUpdateDashboardEmailReportsAsString(), other.createAndUpdateDashboardEmailReportsAsString()) && Objects.equals(this.shareDashboardsAsString(), other.shareDashboardsAsString()) && Objects.equals(this.createAndUpdateThresholdAlertsAsString(), other.createAndUpdateThresholdAlertsAsString()) && Objects.equals(this.renameSharedFoldersAsString(), other.renameSharedFoldersAsString()) && Objects.equals(this.createSharedFoldersAsString(), other.createSharedFoldersAsString()) && Objects.equals(this.createAndUpdateDataSourcesAsString(), other.createAndUpdateDataSourcesAsString()) && Objects.equals(this.shareDataSourcesAsString(), other.shareDataSourcesAsString()) && Objects.equals(this.viewAccountSPICECapacityAsString(), other.viewAccountSPICECapacityAsString()) && Objects.equals(this.createSPICEDatasetAsString(), other.createSPICEDatasetAsString()) && Objects.equals(this.exportToPdfInScheduledReportsAsString(), other.exportToPdfInScheduledReportsAsString()) && Objects.equals(this.exportToCsvInScheduledReportsAsString(), other.exportToCsvInScheduledReportsAsString()) && Objects.equals(this.exportToExcelInScheduledReportsAsString(), other.exportToExcelInScheduledReportsAsString()) && Objects.equals(this.includeContentInScheduledReportsEmailAsString(), other.includeContentInScheduledReportsEmailAsString()) && Objects.equals(this.dashboardAsString(), other.dashboardAsString()) && Objects.equals(this.analysisAsString(), other.analysisAsString()) && Objects.equals(this.automateAsString(), other.automateAsString()) && Objects.equals(this.flowAsString(), other.flowAsString()) && Objects.equals(this.publishWithoutApprovalAsString(), other.publishWithoutApprovalAsString()) && Objects.equals(this.useBedrockModelsAsString(), other.useBedrockModelsAsString()) && Objects.equals(this.performFlowUiTaskAsString(), other.performFlowUiTaskAsString()) && Objects.equals(this.useAgentWebSearchAsString(), other.useAgentWebSearchAsString()) && Objects.equals(this.knowledgeBaseAsString(), other.knowledgeBaseAsString()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.spaceAsString(), other.spaceAsString()) && Objects.equals(this.chatAgentAsString(), other.chatAgentAsString()) && Objects.equals(this.createChatAgentsAsString(), other.createChatAgentsAsString()) && Objects.equals(this.researchAsString(), other.researchAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Capabilities").add("ExportToCsv", (Object)this.exportToCsvAsString()).add("ExportToExcel", (Object)this.exportToExcelAsString()).add("ExportToPdf", (Object)this.exportToPdfAsString()).add("PrintReports", (Object)this.printReportsAsString()).add("CreateAndUpdateThemes", (Object)this.createAndUpdateThemesAsString()).add("AddOrRunAnomalyDetectionForAnalyses", (Object)this.addOrRunAnomalyDetectionForAnalysesAsString()).add("ShareAnalyses", (Object)this.shareAnalysesAsString()).add("CreateAndUpdateDatasets", (Object)this.createAndUpdateDatasetsAsString()).add("ShareDatasets", (Object)this.shareDatasetsAsString()).add("SubscribeDashboardEmailReports", (Object)this.subscribeDashboardEmailReportsAsString()).add("CreateAndUpdateDashboardEmailReports", (Object)this.createAndUpdateDashboardEmailReportsAsString()).add("ShareDashboards", (Object)this.shareDashboardsAsString()).add("CreateAndUpdateThresholdAlerts", (Object)this.createAndUpdateThresholdAlertsAsString()).add("RenameSharedFolders", (Object)this.renameSharedFoldersAsString()).add("CreateSharedFolders", (Object)this.createSharedFoldersAsString()).add("CreateAndUpdateDataSources", (Object)this.createAndUpdateDataSourcesAsString()).add("ShareDataSources", (Object)this.shareDataSourcesAsString()).add("ViewAccountSPICECapacity", (Object)this.viewAccountSPICECapacityAsString()).add("CreateSPICEDataset", (Object)this.createSPICEDatasetAsString()).add("ExportToPdfInScheduledReports", (Object)this.exportToPdfInScheduledReportsAsString()).add("ExportToCsvInScheduledReports", (Object)this.exportToCsvInScheduledReportsAsString()).add("ExportToExcelInScheduledReports", (Object)this.exportToExcelInScheduledReportsAsString()).add("IncludeContentInScheduledReportsEmail", (Object)this.includeContentInScheduledReportsEmailAsString()).add("Dashboard", (Object)this.dashboardAsString()).add("Analysis", (Object)this.analysisAsString()).add("Automate", (Object)this.automateAsString()).add("Flow", (Object)this.flowAsString()).add("PublishWithoutApproval", (Object)this.publishWithoutApprovalAsString()).add("UseBedrockModels", (Object)this.useBedrockModelsAsString()).add("PerformFlowUiTask", (Object)this.performFlowUiTaskAsString()).add("UseAgentWebSearch", (Object)this.useAgentWebSearchAsString()).add("KnowledgeBase", (Object)this.knowledgeBaseAsString()).add("Action", (Object)this.actionAsString()).add("Space", (Object)this.spaceAsString()).add("ChatAgent", (Object)this.chatAgentAsString()).add("CreateChatAgents", (Object)this.createChatAgentsAsString()).add("Research", (Object)this.researchAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportToCsv": {
                return Optional.ofNullable(clazz.cast(this.exportToCsvAsString()));
            }
            case "ExportToExcel": {
                return Optional.ofNullable(clazz.cast(this.exportToExcelAsString()));
            }
            case "ExportToPdf": {
                return Optional.ofNullable(clazz.cast(this.exportToPdfAsString()));
            }
            case "PrintReports": {
                return Optional.ofNullable(clazz.cast(this.printReportsAsString()));
            }
            case "CreateAndUpdateThemes": {
                return Optional.ofNullable(clazz.cast(this.createAndUpdateThemesAsString()));
            }
            case "AddOrRunAnomalyDetectionForAnalyses": {
                return Optional.ofNullable(clazz.cast(this.addOrRunAnomalyDetectionForAnalysesAsString()));
            }
            case "ShareAnalyses": {
                return Optional.ofNullable(clazz.cast(this.shareAnalysesAsString()));
            }
            case "CreateAndUpdateDatasets": {
                return Optional.ofNullable(clazz.cast(this.createAndUpdateDatasetsAsString()));
            }
            case "ShareDatasets": {
                return Optional.ofNullable(clazz.cast(this.shareDatasetsAsString()));
            }
            case "SubscribeDashboardEmailReports": {
                return Optional.ofNullable(clazz.cast(this.subscribeDashboardEmailReportsAsString()));
            }
            case "CreateAndUpdateDashboardEmailReports": {
                return Optional.ofNullable(clazz.cast(this.createAndUpdateDashboardEmailReportsAsString()));
            }
            case "ShareDashboards": {
                return Optional.ofNullable(clazz.cast(this.shareDashboardsAsString()));
            }
            case "CreateAndUpdateThresholdAlerts": {
                return Optional.ofNullable(clazz.cast(this.createAndUpdateThresholdAlertsAsString()));
            }
            case "RenameSharedFolders": {
                return Optional.ofNullable(clazz.cast(this.renameSharedFoldersAsString()));
            }
            case "CreateSharedFolders": {
                return Optional.ofNullable(clazz.cast(this.createSharedFoldersAsString()));
            }
            case "CreateAndUpdateDataSources": {
                return Optional.ofNullable(clazz.cast(this.createAndUpdateDataSourcesAsString()));
            }
            case "ShareDataSources": {
                return Optional.ofNullable(clazz.cast(this.shareDataSourcesAsString()));
            }
            case "ViewAccountSPICECapacity": {
                return Optional.ofNullable(clazz.cast(this.viewAccountSPICECapacityAsString()));
            }
            case "CreateSPICEDataset": {
                return Optional.ofNullable(clazz.cast(this.createSPICEDatasetAsString()));
            }
            case "ExportToPdfInScheduledReports": {
                return Optional.ofNullable(clazz.cast(this.exportToPdfInScheduledReportsAsString()));
            }
            case "ExportToCsvInScheduledReports": {
                return Optional.ofNullable(clazz.cast(this.exportToCsvInScheduledReportsAsString()));
            }
            case "ExportToExcelInScheduledReports": {
                return Optional.ofNullable(clazz.cast(this.exportToExcelInScheduledReportsAsString()));
            }
            case "IncludeContentInScheduledReportsEmail": {
                return Optional.ofNullable(clazz.cast(this.includeContentInScheduledReportsEmailAsString()));
            }
            case "Dashboard": {
                return Optional.ofNullable(clazz.cast(this.dashboardAsString()));
            }
            case "Analysis": {
                return Optional.ofNullable(clazz.cast(this.analysisAsString()));
            }
            case "Automate": {
                return Optional.ofNullable(clazz.cast(this.automateAsString()));
            }
            case "Flow": {
                return Optional.ofNullable(clazz.cast(this.flowAsString()));
            }
            case "PublishWithoutApproval": {
                return Optional.ofNullable(clazz.cast(this.publishWithoutApprovalAsString()));
            }
            case "UseBedrockModels": {
                return Optional.ofNullable(clazz.cast(this.useBedrockModelsAsString()));
            }
            case "PerformFlowUiTask": {
                return Optional.ofNullable(clazz.cast(this.performFlowUiTaskAsString()));
            }
            case "UseAgentWebSearch": {
                return Optional.ofNullable(clazz.cast(this.useAgentWebSearchAsString()));
            }
            case "KnowledgeBase": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseAsString()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Space": {
                return Optional.ofNullable(clazz.cast(this.spaceAsString()));
            }
            case "ChatAgent": {
                return Optional.ofNullable(clazz.cast(this.chatAgentAsString()));
            }
            case "CreateChatAgents": {
                return Optional.ofNullable(clazz.cast(this.createChatAgentsAsString()));
            }
            case "Research": {
                return Optional.ofNullable(clazz.cast(this.researchAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ExportToCsv", EXPORT_TO_CSV_FIELD);
        map.put("ExportToExcel", EXPORT_TO_EXCEL_FIELD);
        map.put("ExportToPdf", EXPORT_TO_PDF_FIELD);
        map.put("PrintReports", PRINT_REPORTS_FIELD);
        map.put("CreateAndUpdateThemes", CREATE_AND_UPDATE_THEMES_FIELD);
        map.put("AddOrRunAnomalyDetectionForAnalyses", ADD_OR_RUN_ANOMALY_DETECTION_FOR_ANALYSES_FIELD);
        map.put("ShareAnalyses", SHARE_ANALYSES_FIELD);
        map.put("CreateAndUpdateDatasets", CREATE_AND_UPDATE_DATASETS_FIELD);
        map.put("ShareDatasets", SHARE_DATASETS_FIELD);
        map.put("SubscribeDashboardEmailReports", SUBSCRIBE_DASHBOARD_EMAIL_REPORTS_FIELD);
        map.put("CreateAndUpdateDashboardEmailReports", CREATE_AND_UPDATE_DASHBOARD_EMAIL_REPORTS_FIELD);
        map.put("ShareDashboards", SHARE_DASHBOARDS_FIELD);
        map.put("CreateAndUpdateThresholdAlerts", CREATE_AND_UPDATE_THRESHOLD_ALERTS_FIELD);
        map.put("RenameSharedFolders", RENAME_SHARED_FOLDERS_FIELD);
        map.put("CreateSharedFolders", CREATE_SHARED_FOLDERS_FIELD);
        map.put("CreateAndUpdateDataSources", CREATE_AND_UPDATE_DATA_SOURCES_FIELD);
        map.put("ShareDataSources", SHARE_DATA_SOURCES_FIELD);
        map.put("ViewAccountSPICECapacity", VIEW_ACCOUNT_SPICE_CAPACITY_FIELD);
        map.put("CreateSPICEDataset", CREATE_SPICE_DATASET_FIELD);
        map.put("ExportToPdfInScheduledReports", EXPORT_TO_PDF_IN_SCHEDULED_REPORTS_FIELD);
        map.put("ExportToCsvInScheduledReports", EXPORT_TO_CSV_IN_SCHEDULED_REPORTS_FIELD);
        map.put("ExportToExcelInScheduledReports", EXPORT_TO_EXCEL_IN_SCHEDULED_REPORTS_FIELD);
        map.put("IncludeContentInScheduledReportsEmail", INCLUDE_CONTENT_IN_SCHEDULED_REPORTS_EMAIL_FIELD);
        map.put("Dashboard", DASHBOARD_FIELD);
        map.put("Analysis", ANALYSIS_FIELD);
        map.put("Automate", AUTOMATE_FIELD);
        map.put("Flow", FLOW_FIELD);
        map.put("PublishWithoutApproval", PUBLISH_WITHOUT_APPROVAL_FIELD);
        map.put("UseBedrockModels", USE_BEDROCK_MODELS_FIELD);
        map.put("PerformFlowUiTask", PERFORM_FLOW_UI_TASK_FIELD);
        map.put("UseAgentWebSearch", USE_AGENT_WEB_SEARCH_FIELD);
        map.put("KnowledgeBase", KNOWLEDGE_BASE_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("Space", SPACE_FIELD);
        map.put("ChatAgent", CHAT_AGENT_FIELD);
        map.put("CreateChatAgents", CREATE_CHAT_AGENTS_FIELD);
        map.put("Research", RESEARCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Capabilities, T> g) {
        return obj -> g.apply((Capabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String exportToCsv;
        private String exportToExcel;
        private String exportToPdf;
        private String printReports;
        private String createAndUpdateThemes;
        private String addOrRunAnomalyDetectionForAnalyses;
        private String shareAnalyses;
        private String createAndUpdateDatasets;
        private String shareDatasets;
        private String subscribeDashboardEmailReports;
        private String createAndUpdateDashboardEmailReports;
        private String shareDashboards;
        private String createAndUpdateThresholdAlerts;
        private String renameSharedFolders;
        private String createSharedFolders;
        private String createAndUpdateDataSources;
        private String shareDataSources;
        private String viewAccountSPICECapacity;
        private String createSPICEDataset;
        private String exportToPdfInScheduledReports;
        private String exportToCsvInScheduledReports;
        private String exportToExcelInScheduledReports;
        private String includeContentInScheduledReportsEmail;
        private String dashboard;
        private String analysis;
        private String automate;
        private String flow;
        private String publishWithoutApproval;
        private String useBedrockModels;
        private String performFlowUiTask;
        private String useAgentWebSearch;
        private String knowledgeBase;
        private String action;
        private String space;
        private String chatAgent;
        private String createChatAgents;
        private String research;

        private BuilderImpl() {
        }

        private BuilderImpl(Capabilities model) {
            this.exportToCsv(model.exportToCsv);
            this.exportToExcel(model.exportToExcel);
            this.exportToPdf(model.exportToPdf);
            this.printReports(model.printReports);
            this.createAndUpdateThemes(model.createAndUpdateThemes);
            this.addOrRunAnomalyDetectionForAnalyses(model.addOrRunAnomalyDetectionForAnalyses);
            this.shareAnalyses(model.shareAnalyses);
            this.createAndUpdateDatasets(model.createAndUpdateDatasets);
            this.shareDatasets(model.shareDatasets);
            this.subscribeDashboardEmailReports(model.subscribeDashboardEmailReports);
            this.createAndUpdateDashboardEmailReports(model.createAndUpdateDashboardEmailReports);
            this.shareDashboards(model.shareDashboards);
            this.createAndUpdateThresholdAlerts(model.createAndUpdateThresholdAlerts);
            this.renameSharedFolders(model.renameSharedFolders);
            this.createSharedFolders(model.createSharedFolders);
            this.createAndUpdateDataSources(model.createAndUpdateDataSources);
            this.shareDataSources(model.shareDataSources);
            this.viewAccountSPICECapacity(model.viewAccountSPICECapacity);
            this.createSPICEDataset(model.createSPICEDataset);
            this.exportToPdfInScheduledReports(model.exportToPdfInScheduledReports);
            this.exportToCsvInScheduledReports(model.exportToCsvInScheduledReports);
            this.exportToExcelInScheduledReports(model.exportToExcelInScheduledReports);
            this.includeContentInScheduledReportsEmail(model.includeContentInScheduledReportsEmail);
            this.dashboard(model.dashboard);
            this.analysis(model.analysis);
            this.automate(model.automate);
            this.flow(model.flow);
            this.publishWithoutApproval(model.publishWithoutApproval);
            this.useBedrockModels(model.useBedrockModels);
            this.performFlowUiTask(model.performFlowUiTask);
            this.useAgentWebSearch(model.useAgentWebSearch);
            this.knowledgeBase(model.knowledgeBase);
            this.action(model.action);
            this.space(model.space);
            this.chatAgent(model.chatAgent);
            this.createChatAgents(model.createChatAgents);
            this.research(model.research);
        }

        public final String getExportToCsv() {
            return this.exportToCsv;
        }

        public final void setExportToCsv(String exportToCsv) {
            this.exportToCsv = exportToCsv;
        }

        @Override
        public final Builder exportToCsv(String exportToCsv) {
            this.exportToCsv = exportToCsv;
            return this;
        }

        @Override
        public final Builder exportToCsv(CapabilityState exportToCsv) {
            this.exportToCsv(exportToCsv == null ? null : exportToCsv.toString());
            return this;
        }

        public final String getExportToExcel() {
            return this.exportToExcel;
        }

        public final void setExportToExcel(String exportToExcel) {
            this.exportToExcel = exportToExcel;
        }

        @Override
        public final Builder exportToExcel(String exportToExcel) {
            this.exportToExcel = exportToExcel;
            return this;
        }

        @Override
        public final Builder exportToExcel(CapabilityState exportToExcel) {
            this.exportToExcel(exportToExcel == null ? null : exportToExcel.toString());
            return this;
        }

        public final String getExportToPdf() {
            return this.exportToPdf;
        }

        public final void setExportToPdf(String exportToPdf) {
            this.exportToPdf = exportToPdf;
        }

        @Override
        public final Builder exportToPdf(String exportToPdf) {
            this.exportToPdf = exportToPdf;
            return this;
        }

        @Override
        public final Builder exportToPdf(CapabilityState exportToPdf) {
            this.exportToPdf(exportToPdf == null ? null : exportToPdf.toString());
            return this;
        }

        public final String getPrintReports() {
            return this.printReports;
        }

        public final void setPrintReports(String printReports) {
            this.printReports = printReports;
        }

        @Override
        public final Builder printReports(String printReports) {
            this.printReports = printReports;
            return this;
        }

        @Override
        public final Builder printReports(CapabilityState printReports) {
            this.printReports(printReports == null ? null : printReports.toString());
            return this;
        }

        public final String getCreateAndUpdateThemes() {
            return this.createAndUpdateThemes;
        }

        public final void setCreateAndUpdateThemes(String createAndUpdateThemes) {
            this.createAndUpdateThemes = createAndUpdateThemes;
        }

        @Override
        public final Builder createAndUpdateThemes(String createAndUpdateThemes) {
            this.createAndUpdateThemes = createAndUpdateThemes;
            return this;
        }

        @Override
        public final Builder createAndUpdateThemes(CapabilityState createAndUpdateThemes) {
            this.createAndUpdateThemes(createAndUpdateThemes == null ? null : createAndUpdateThemes.toString());
            return this;
        }

        public final String getAddOrRunAnomalyDetectionForAnalyses() {
            return this.addOrRunAnomalyDetectionForAnalyses;
        }

        public final void setAddOrRunAnomalyDetectionForAnalyses(String addOrRunAnomalyDetectionForAnalyses) {
            this.addOrRunAnomalyDetectionForAnalyses = addOrRunAnomalyDetectionForAnalyses;
        }

        @Override
        public final Builder addOrRunAnomalyDetectionForAnalyses(String addOrRunAnomalyDetectionForAnalyses) {
            this.addOrRunAnomalyDetectionForAnalyses = addOrRunAnomalyDetectionForAnalyses;
            return this;
        }

        @Override
        public final Builder addOrRunAnomalyDetectionForAnalyses(CapabilityState addOrRunAnomalyDetectionForAnalyses) {
            this.addOrRunAnomalyDetectionForAnalyses(addOrRunAnomalyDetectionForAnalyses == null ? null : addOrRunAnomalyDetectionForAnalyses.toString());
            return this;
        }

        public final String getShareAnalyses() {
            return this.shareAnalyses;
        }

        public final void setShareAnalyses(String shareAnalyses) {
            this.shareAnalyses = shareAnalyses;
        }

        @Override
        public final Builder shareAnalyses(String shareAnalyses) {
            this.shareAnalyses = shareAnalyses;
            return this;
        }

        @Override
        public final Builder shareAnalyses(CapabilityState shareAnalyses) {
            this.shareAnalyses(shareAnalyses == null ? null : shareAnalyses.toString());
            return this;
        }

        public final String getCreateAndUpdateDatasets() {
            return this.createAndUpdateDatasets;
        }

        public final void setCreateAndUpdateDatasets(String createAndUpdateDatasets) {
            this.createAndUpdateDatasets = createAndUpdateDatasets;
        }

        @Override
        public final Builder createAndUpdateDatasets(String createAndUpdateDatasets) {
            this.createAndUpdateDatasets = createAndUpdateDatasets;
            return this;
        }

        @Override
        public final Builder createAndUpdateDatasets(CapabilityState createAndUpdateDatasets) {
            this.createAndUpdateDatasets(createAndUpdateDatasets == null ? null : createAndUpdateDatasets.toString());
            return this;
        }

        public final String getShareDatasets() {
            return this.shareDatasets;
        }

        public final void setShareDatasets(String shareDatasets) {
            this.shareDatasets = shareDatasets;
        }

        @Override
        public final Builder shareDatasets(String shareDatasets) {
            this.shareDatasets = shareDatasets;
            return this;
        }

        @Override
        public final Builder shareDatasets(CapabilityState shareDatasets) {
            this.shareDatasets(shareDatasets == null ? null : shareDatasets.toString());
            return this;
        }

        public final String getSubscribeDashboardEmailReports() {
            return this.subscribeDashboardEmailReports;
        }

        public final void setSubscribeDashboardEmailReports(String subscribeDashboardEmailReports) {
            this.subscribeDashboardEmailReports = subscribeDashboardEmailReports;
        }

        @Override
        public final Builder subscribeDashboardEmailReports(String subscribeDashboardEmailReports) {
            this.subscribeDashboardEmailReports = subscribeDashboardEmailReports;
            return this;
        }

        @Override
        public final Builder subscribeDashboardEmailReports(CapabilityState subscribeDashboardEmailReports) {
            this.subscribeDashboardEmailReports(subscribeDashboardEmailReports == null ? null : subscribeDashboardEmailReports.toString());
            return this;
        }

        public final String getCreateAndUpdateDashboardEmailReports() {
            return this.createAndUpdateDashboardEmailReports;
        }

        public final void setCreateAndUpdateDashboardEmailReports(String createAndUpdateDashboardEmailReports) {
            this.createAndUpdateDashboardEmailReports = createAndUpdateDashboardEmailReports;
        }

        @Override
        public final Builder createAndUpdateDashboardEmailReports(String createAndUpdateDashboardEmailReports) {
            this.createAndUpdateDashboardEmailReports = createAndUpdateDashboardEmailReports;
            return this;
        }

        @Override
        public final Builder createAndUpdateDashboardEmailReports(CapabilityState createAndUpdateDashboardEmailReports) {
            this.createAndUpdateDashboardEmailReports(createAndUpdateDashboardEmailReports == null ? null : createAndUpdateDashboardEmailReports.toString());
            return this;
        }

        public final String getShareDashboards() {
            return this.shareDashboards;
        }

        public final void setShareDashboards(String shareDashboards) {
            this.shareDashboards = shareDashboards;
        }

        @Override
        public final Builder shareDashboards(String shareDashboards) {
            this.shareDashboards = shareDashboards;
            return this;
        }

        @Override
        public final Builder shareDashboards(CapabilityState shareDashboards) {
            this.shareDashboards(shareDashboards == null ? null : shareDashboards.toString());
            return this;
        }

        public final String getCreateAndUpdateThresholdAlerts() {
            return this.createAndUpdateThresholdAlerts;
        }

        public final void setCreateAndUpdateThresholdAlerts(String createAndUpdateThresholdAlerts) {
            this.createAndUpdateThresholdAlerts = createAndUpdateThresholdAlerts;
        }

        @Override
        public final Builder createAndUpdateThresholdAlerts(String createAndUpdateThresholdAlerts) {
            this.createAndUpdateThresholdAlerts = createAndUpdateThresholdAlerts;
            return this;
        }

        @Override
        public final Builder createAndUpdateThresholdAlerts(CapabilityState createAndUpdateThresholdAlerts) {
            this.createAndUpdateThresholdAlerts(createAndUpdateThresholdAlerts == null ? null : createAndUpdateThresholdAlerts.toString());
            return this;
        }

        public final String getRenameSharedFolders() {
            return this.renameSharedFolders;
        }

        public final void setRenameSharedFolders(String renameSharedFolders) {
            this.renameSharedFolders = renameSharedFolders;
        }

        @Override
        public final Builder renameSharedFolders(String renameSharedFolders) {
            this.renameSharedFolders = renameSharedFolders;
            return this;
        }

        @Override
        public final Builder renameSharedFolders(CapabilityState renameSharedFolders) {
            this.renameSharedFolders(renameSharedFolders == null ? null : renameSharedFolders.toString());
            return this;
        }

        public final String getCreateSharedFolders() {
            return this.createSharedFolders;
        }

        public final void setCreateSharedFolders(String createSharedFolders) {
            this.createSharedFolders = createSharedFolders;
        }

        @Override
        public final Builder createSharedFolders(String createSharedFolders) {
            this.createSharedFolders = createSharedFolders;
            return this;
        }

        @Override
        public final Builder createSharedFolders(CapabilityState createSharedFolders) {
            this.createSharedFolders(createSharedFolders == null ? null : createSharedFolders.toString());
            return this;
        }

        public final String getCreateAndUpdateDataSources() {
            return this.createAndUpdateDataSources;
        }

        public final void setCreateAndUpdateDataSources(String createAndUpdateDataSources) {
            this.createAndUpdateDataSources = createAndUpdateDataSources;
        }

        @Override
        public final Builder createAndUpdateDataSources(String createAndUpdateDataSources) {
            this.createAndUpdateDataSources = createAndUpdateDataSources;
            return this;
        }

        @Override
        public final Builder createAndUpdateDataSources(CapabilityState createAndUpdateDataSources) {
            this.createAndUpdateDataSources(createAndUpdateDataSources == null ? null : createAndUpdateDataSources.toString());
            return this;
        }

        public final String getShareDataSources() {
            return this.shareDataSources;
        }

        public final void setShareDataSources(String shareDataSources) {
            this.shareDataSources = shareDataSources;
        }

        @Override
        public final Builder shareDataSources(String shareDataSources) {
            this.shareDataSources = shareDataSources;
            return this;
        }

        @Override
        public final Builder shareDataSources(CapabilityState shareDataSources) {
            this.shareDataSources(shareDataSources == null ? null : shareDataSources.toString());
            return this;
        }

        public final String getViewAccountSPICECapacity() {
            return this.viewAccountSPICECapacity;
        }

        public final void setViewAccountSPICECapacity(String viewAccountSPICECapacity) {
            this.viewAccountSPICECapacity = viewAccountSPICECapacity;
        }

        @Override
        public final Builder viewAccountSPICECapacity(String viewAccountSPICECapacity) {
            this.viewAccountSPICECapacity = viewAccountSPICECapacity;
            return this;
        }

        @Override
        public final Builder viewAccountSPICECapacity(CapabilityState viewAccountSPICECapacity) {
            this.viewAccountSPICECapacity(viewAccountSPICECapacity == null ? null : viewAccountSPICECapacity.toString());
            return this;
        }

        public final String getCreateSPICEDataset() {
            return this.createSPICEDataset;
        }

        public final void setCreateSPICEDataset(String createSPICEDataset) {
            this.createSPICEDataset = createSPICEDataset;
        }

        @Override
        public final Builder createSPICEDataset(String createSPICEDataset) {
            this.createSPICEDataset = createSPICEDataset;
            return this;
        }

        @Override
        public final Builder createSPICEDataset(CapabilityState createSPICEDataset) {
            this.createSPICEDataset(createSPICEDataset == null ? null : createSPICEDataset.toString());
            return this;
        }

        public final String getExportToPdfInScheduledReports() {
            return this.exportToPdfInScheduledReports;
        }

        public final void setExportToPdfInScheduledReports(String exportToPdfInScheduledReports) {
            this.exportToPdfInScheduledReports = exportToPdfInScheduledReports;
        }

        @Override
        public final Builder exportToPdfInScheduledReports(String exportToPdfInScheduledReports) {
            this.exportToPdfInScheduledReports = exportToPdfInScheduledReports;
            return this;
        }

        @Override
        public final Builder exportToPdfInScheduledReports(CapabilityState exportToPdfInScheduledReports) {
            this.exportToPdfInScheduledReports(exportToPdfInScheduledReports == null ? null : exportToPdfInScheduledReports.toString());
            return this;
        }

        public final String getExportToCsvInScheduledReports() {
            return this.exportToCsvInScheduledReports;
        }

        public final void setExportToCsvInScheduledReports(String exportToCsvInScheduledReports) {
            this.exportToCsvInScheduledReports = exportToCsvInScheduledReports;
        }

        @Override
        public final Builder exportToCsvInScheduledReports(String exportToCsvInScheduledReports) {
            this.exportToCsvInScheduledReports = exportToCsvInScheduledReports;
            return this;
        }

        @Override
        public final Builder exportToCsvInScheduledReports(CapabilityState exportToCsvInScheduledReports) {
            this.exportToCsvInScheduledReports(exportToCsvInScheduledReports == null ? null : exportToCsvInScheduledReports.toString());
            return this;
        }

        public final String getExportToExcelInScheduledReports() {
            return this.exportToExcelInScheduledReports;
        }

        public final void setExportToExcelInScheduledReports(String exportToExcelInScheduledReports) {
            this.exportToExcelInScheduledReports = exportToExcelInScheduledReports;
        }

        @Override
        public final Builder exportToExcelInScheduledReports(String exportToExcelInScheduledReports) {
            this.exportToExcelInScheduledReports = exportToExcelInScheduledReports;
            return this;
        }

        @Override
        public final Builder exportToExcelInScheduledReports(CapabilityState exportToExcelInScheduledReports) {
            this.exportToExcelInScheduledReports(exportToExcelInScheduledReports == null ? null : exportToExcelInScheduledReports.toString());
            return this;
        }

        public final String getIncludeContentInScheduledReportsEmail() {
            return this.includeContentInScheduledReportsEmail;
        }

        public final void setIncludeContentInScheduledReportsEmail(String includeContentInScheduledReportsEmail) {
            this.includeContentInScheduledReportsEmail = includeContentInScheduledReportsEmail;
        }

        @Override
        public final Builder includeContentInScheduledReportsEmail(String includeContentInScheduledReportsEmail) {
            this.includeContentInScheduledReportsEmail = includeContentInScheduledReportsEmail;
            return this;
        }

        @Override
        public final Builder includeContentInScheduledReportsEmail(CapabilityState includeContentInScheduledReportsEmail) {
            this.includeContentInScheduledReportsEmail(includeContentInScheduledReportsEmail == null ? null : includeContentInScheduledReportsEmail.toString());
            return this;
        }

        public final String getDashboard() {
            return this.dashboard;
        }

        public final void setDashboard(String dashboard) {
            this.dashboard = dashboard;
        }

        @Override
        public final Builder dashboard(String dashboard) {
            this.dashboard = dashboard;
            return this;
        }

        @Override
        public final Builder dashboard(CapabilityState dashboard) {
            this.dashboard(dashboard == null ? null : dashboard.toString());
            return this;
        }

        public final String getAnalysis() {
            return this.analysis;
        }

        public final void setAnalysis(String analysis) {
            this.analysis = analysis;
        }

        @Override
        public final Builder analysis(String analysis) {
            this.analysis = analysis;
            return this;
        }

        @Override
        public final Builder analysis(CapabilityState analysis) {
            this.analysis(analysis == null ? null : analysis.toString());
            return this;
        }

        public final String getAutomate() {
            return this.automate;
        }

        public final void setAutomate(String automate) {
            this.automate = automate;
        }

        @Override
        public final Builder automate(String automate) {
            this.automate = automate;
            return this;
        }

        @Override
        public final Builder automate(CapabilityState automate) {
            this.automate(automate == null ? null : automate.toString());
            return this;
        }

        public final String getFlow() {
            return this.flow;
        }

        public final void setFlow(String flow) {
            this.flow = flow;
        }

        @Override
        public final Builder flow(String flow) {
            this.flow = flow;
            return this;
        }

        @Override
        public final Builder flow(CapabilityState flow) {
            this.flow(flow == null ? null : flow.toString());
            return this;
        }

        public final String getPublishWithoutApproval() {
            return this.publishWithoutApproval;
        }

        public final void setPublishWithoutApproval(String publishWithoutApproval) {
            this.publishWithoutApproval = publishWithoutApproval;
        }

        @Override
        public final Builder publishWithoutApproval(String publishWithoutApproval) {
            this.publishWithoutApproval = publishWithoutApproval;
            return this;
        }

        @Override
        public final Builder publishWithoutApproval(CapabilityState publishWithoutApproval) {
            this.publishWithoutApproval(publishWithoutApproval == null ? null : publishWithoutApproval.toString());
            return this;
        }

        public final String getUseBedrockModels() {
            return this.useBedrockModels;
        }

        public final void setUseBedrockModels(String useBedrockModels) {
            this.useBedrockModels = useBedrockModels;
        }

        @Override
        public final Builder useBedrockModels(String useBedrockModels) {
            this.useBedrockModels = useBedrockModels;
            return this;
        }

        @Override
        public final Builder useBedrockModels(CapabilityState useBedrockModels) {
            this.useBedrockModels(useBedrockModels == null ? null : useBedrockModels.toString());
            return this;
        }

        public final String getPerformFlowUiTask() {
            return this.performFlowUiTask;
        }

        public final void setPerformFlowUiTask(String performFlowUiTask) {
            this.performFlowUiTask = performFlowUiTask;
        }

        @Override
        public final Builder performFlowUiTask(String performFlowUiTask) {
            this.performFlowUiTask = performFlowUiTask;
            return this;
        }

        @Override
        public final Builder performFlowUiTask(CapabilityState performFlowUiTask) {
            this.performFlowUiTask(performFlowUiTask == null ? null : performFlowUiTask.toString());
            return this;
        }

        public final String getUseAgentWebSearch() {
            return this.useAgentWebSearch;
        }

        public final void setUseAgentWebSearch(String useAgentWebSearch) {
            this.useAgentWebSearch = useAgentWebSearch;
        }

        @Override
        public final Builder useAgentWebSearch(String useAgentWebSearch) {
            this.useAgentWebSearch = useAgentWebSearch;
            return this;
        }

        @Override
        public final Builder useAgentWebSearch(CapabilityState useAgentWebSearch) {
            this.useAgentWebSearch(useAgentWebSearch == null ? null : useAgentWebSearch.toString());
            return this;
        }

        public final String getKnowledgeBase() {
            return this.knowledgeBase;
        }

        public final void setKnowledgeBase(String knowledgeBase) {
            this.knowledgeBase = knowledgeBase;
        }

        @Override
        public final Builder knowledgeBase(String knowledgeBase) {
            this.knowledgeBase = knowledgeBase;
            return this;
        }

        @Override
        public final Builder knowledgeBase(CapabilityState knowledgeBase) {
            this.knowledgeBase(knowledgeBase == null ? null : knowledgeBase.toString());
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(CapabilityState action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getSpace() {
            return this.space;
        }

        public final void setSpace(String space) {
            this.space = space;
        }

        @Override
        public final Builder space(String space) {
            this.space = space;
            return this;
        }

        @Override
        public final Builder space(CapabilityState space) {
            this.space(space == null ? null : space.toString());
            return this;
        }

        public final String getChatAgent() {
            return this.chatAgent;
        }

        public final void setChatAgent(String chatAgent) {
            this.chatAgent = chatAgent;
        }

        @Override
        public final Builder chatAgent(String chatAgent) {
            this.chatAgent = chatAgent;
            return this;
        }

        @Override
        public final Builder chatAgent(CapabilityState chatAgent) {
            this.chatAgent(chatAgent == null ? null : chatAgent.toString());
            return this;
        }

        public final String getCreateChatAgents() {
            return this.createChatAgents;
        }

        public final void setCreateChatAgents(String createChatAgents) {
            this.createChatAgents = createChatAgents;
        }

        @Override
        public final Builder createChatAgents(String createChatAgents) {
            this.createChatAgents = createChatAgents;
            return this;
        }

        @Override
        public final Builder createChatAgents(CapabilityState createChatAgents) {
            this.createChatAgents(createChatAgents == null ? null : createChatAgents.toString());
            return this;
        }

        public final String getResearch() {
            return this.research;
        }

        public final void setResearch(String research) {
            this.research = research;
        }

        @Override
        public final Builder research(String research) {
            this.research = research;
            return this;
        }

        @Override
        public final Builder research(CapabilityState research) {
            this.research(research == null ? null : research.toString());
            return this;
        }

        public Capabilities build() {
            return new Capabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Capabilities> {
        public Builder exportToCsv(String var1);

        public Builder exportToCsv(CapabilityState var1);

        public Builder exportToExcel(String var1);

        public Builder exportToExcel(CapabilityState var1);

        public Builder exportToPdf(String var1);

        public Builder exportToPdf(CapabilityState var1);

        public Builder printReports(String var1);

        public Builder printReports(CapabilityState var1);

        public Builder createAndUpdateThemes(String var1);

        public Builder createAndUpdateThemes(CapabilityState var1);

        public Builder addOrRunAnomalyDetectionForAnalyses(String var1);

        public Builder addOrRunAnomalyDetectionForAnalyses(CapabilityState var1);

        public Builder shareAnalyses(String var1);

        public Builder shareAnalyses(CapabilityState var1);

        public Builder createAndUpdateDatasets(String var1);

        public Builder createAndUpdateDatasets(CapabilityState var1);

        public Builder shareDatasets(String var1);

        public Builder shareDatasets(CapabilityState var1);

        public Builder subscribeDashboardEmailReports(String var1);

        public Builder subscribeDashboardEmailReports(CapabilityState var1);

        public Builder createAndUpdateDashboardEmailReports(String var1);

        public Builder createAndUpdateDashboardEmailReports(CapabilityState var1);

        public Builder shareDashboards(String var1);

        public Builder shareDashboards(CapabilityState var1);

        public Builder createAndUpdateThresholdAlerts(String var1);

        public Builder createAndUpdateThresholdAlerts(CapabilityState var1);

        public Builder renameSharedFolders(String var1);

        public Builder renameSharedFolders(CapabilityState var1);

        public Builder createSharedFolders(String var1);

        public Builder createSharedFolders(CapabilityState var1);

        public Builder createAndUpdateDataSources(String var1);

        public Builder createAndUpdateDataSources(CapabilityState var1);

        public Builder shareDataSources(String var1);

        public Builder shareDataSources(CapabilityState var1);

        public Builder viewAccountSPICECapacity(String var1);

        public Builder viewAccountSPICECapacity(CapabilityState var1);

        public Builder createSPICEDataset(String var1);

        public Builder createSPICEDataset(CapabilityState var1);

        public Builder exportToPdfInScheduledReports(String var1);

        public Builder exportToPdfInScheduledReports(CapabilityState var1);

        public Builder exportToCsvInScheduledReports(String var1);

        public Builder exportToCsvInScheduledReports(CapabilityState var1);

        public Builder exportToExcelInScheduledReports(String var1);

        public Builder exportToExcelInScheduledReports(CapabilityState var1);

        public Builder includeContentInScheduledReportsEmail(String var1);

        public Builder includeContentInScheduledReportsEmail(CapabilityState var1);

        public Builder dashboard(String var1);

        public Builder dashboard(CapabilityState var1);

        public Builder analysis(String var1);

        public Builder analysis(CapabilityState var1);

        public Builder automate(String var1);

        public Builder automate(CapabilityState var1);

        public Builder flow(String var1);

        public Builder flow(CapabilityState var1);

        public Builder publishWithoutApproval(String var1);

        public Builder publishWithoutApproval(CapabilityState var1);

        public Builder useBedrockModels(String var1);

        public Builder useBedrockModels(CapabilityState var1);

        public Builder performFlowUiTask(String var1);

        public Builder performFlowUiTask(CapabilityState var1);

        public Builder useAgentWebSearch(String var1);

        public Builder useAgentWebSearch(CapabilityState var1);

        public Builder knowledgeBase(String var1);

        public Builder knowledgeBase(CapabilityState var1);

        public Builder action(String var1);

        public Builder action(CapabilityState var1);

        public Builder space(String var1);

        public Builder space(CapabilityState var1);

        public Builder chatAgent(String var1);

        public Builder chatAgent(CapabilityState var1);

        public Builder createChatAgents(String var1);

        public Builder createChatAgents(CapabilityState var1);

        public Builder research(String var1);

        public Builder research(CapabilityState var1);
    }
}

