/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.DashboardCustomizationStatus;
import software.amazon.awssdk.services.quicksight.model.VisualCustomizationAdditionalFieldsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VisualCustomizationFieldsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VisualCustomizationFieldsConfiguration> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(VisualCustomizationFieldsConfiguration.getter(VisualCustomizationFieldsConfiguration::statusAsString)).setter(VisualCustomizationFieldsConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<ColumnIdentifier>> ADDITIONAL_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalFields").getter(VisualCustomizationFieldsConfiguration.getter(VisualCustomizationFieldsConfiguration::additionalFields)).setter(VisualCustomizationFieldsConfiguration.setter(Builder::additionalFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ADDITIONAL_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VisualCustomizationFieldsConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final List<ColumnIdentifier> additionalFields;

    private VisualCustomizationFieldsConfiguration(BuilderImpl builder) {
        this.status = builder.status;
        this.additionalFields = builder.additionalFields;
    }

    public final DashboardCustomizationStatus status() {
        return DashboardCustomizationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasAdditionalFields() {
        return this.additionalFields != null && !(this.additionalFields instanceof SdkAutoConstructList);
    }

    public final List<ColumnIdentifier> additionalFields() {
        return this.additionalFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalFields() ? this.additionalFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualCustomizationFieldsConfiguration)) {
            return false;
        }
        VisualCustomizationFieldsConfiguration other = (VisualCustomizationFieldsConfiguration)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasAdditionalFields() == other.hasAdditionalFields() && Objects.equals(this.additionalFields(), other.additionalFields());
    }

    public final String toString() {
        return ToString.builder((String)"VisualCustomizationFieldsConfiguration").add("Status", (Object)this.statusAsString()).add("AdditionalFields", this.hasAdditionalFields() ? this.additionalFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AdditionalFields": {
                return Optional.ofNullable(clazz.cast(this.additionalFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("AdditionalFields", ADDITIONAL_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VisualCustomizationFieldsConfiguration, T> g) {
        return obj -> g.apply((VisualCustomizationFieldsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private List<ColumnIdentifier> additionalFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VisualCustomizationFieldsConfiguration model) {
            this.status(model.status);
            this.additionalFields(model.additionalFields);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DashboardCustomizationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<ColumnIdentifier.Builder> getAdditionalFields() {
            List<ColumnIdentifier.Builder> result = VisualCustomizationAdditionalFieldsListCopier.copyToBuilder(this.additionalFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalFields(Collection<ColumnIdentifier.BuilderImpl> additionalFields) {
            this.additionalFields = VisualCustomizationAdditionalFieldsListCopier.copyFromBuilder(additionalFields);
        }

        @Override
        public final Builder additionalFields(Collection<ColumnIdentifier> additionalFields) {
            this.additionalFields = VisualCustomizationAdditionalFieldsListCopier.copy(additionalFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFields(ColumnIdentifier ... additionalFields) {
            this.additionalFields(Arrays.asList(additionalFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalFields(Consumer<ColumnIdentifier.Builder> ... additionalFields) {
            this.additionalFields(Stream.of(additionalFields).map(c -> (ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VisualCustomizationFieldsConfiguration build() {
            return new VisualCustomizationFieldsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VisualCustomizationFieldsConfiguration> {
        public Builder status(String var1);

        public Builder status(DashboardCustomizationStatus var1);

        public Builder additionalFields(Collection<ColumnIdentifier> var1);

        public Builder additionalFields(ColumnIdentifier ... var1);

        public Builder additionalFields(Consumer<ColumnIdentifier.Builder> ... var1);
    }
}

