/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.SemanticTable;
import software.amazon.awssdk.services.quicksight.model.SemanticTableMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SemanticModelConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SemanticModelConfiguration> {
    private static final SdkField<Map<String, SemanticTable>> TABLE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TableMap").getter(SemanticModelConfiguration.getter(SemanticModelConfiguration::tableMap)).setter(SemanticModelConfiguration.setter(Builder::tableMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SemanticTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_MAP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SemanticModelConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, SemanticTable> tableMap;

    private SemanticModelConfiguration(BuilderImpl builder) {
        this.tableMap = builder.tableMap;
    }

    public final boolean hasTableMap() {
        return this.tableMap != null && !(this.tableMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, SemanticTable> tableMap() {
        return this.tableMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableMap() ? this.tableMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemanticModelConfiguration)) {
            return false;
        }
        SemanticModelConfiguration other = (SemanticModelConfiguration)obj;
        return this.hasTableMap() == other.hasTableMap() && Objects.equals(this.tableMap(), other.tableMap());
    }

    public final String toString() {
        return ToString.builder((String)"SemanticModelConfiguration").add("TableMap", this.hasTableMap() ? this.tableMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableMap": {
                return Optional.ofNullable(clazz.cast(this.tableMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, SemanticTable>>> map = new HashMap<String, SdkField<Map<String, SemanticTable>>>();
        map.put("TableMap", TABLE_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SemanticModelConfiguration, T> g) {
        return obj -> g.apply((SemanticModelConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, SemanticTable> tableMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SemanticModelConfiguration model) {
            this.tableMap(model.tableMap);
        }

        public final Map<String, SemanticTable.Builder> getTableMap() {
            Map<String, SemanticTable.Builder> result = SemanticTableMapCopier.copyToBuilder(this.tableMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTableMap(Map<String, SemanticTable.BuilderImpl> tableMap) {
            this.tableMap = SemanticTableMapCopier.copyFromBuilder(tableMap);
        }

        @Override
        public final Builder tableMap(Map<String, SemanticTable> tableMap) {
            this.tableMap = SemanticTableMapCopier.copy(tableMap);
            return this;
        }

        public SemanticModelConfiguration build() {
            return new SemanticModelConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SemanticModelConfiguration> {
        public Builder tableMap(Map<String, SemanticTable> var1);
    }
}

