/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.SnapshotConfiguration;
import software.amazon.awssdk.services.quicksight.model.SnapshotJobStatus;
import software.amazon.awssdk.services.quicksight.model.SnapshotUserConfigurationRedacted;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDashboardSnapshotJobResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeDashboardSnapshotJobResponse> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(DescribeDashboardSnapshotJobResponse.getter(DescribeDashboardSnapshotJobResponse::awsAccountId)).setter(DescribeDashboardSnapshotJobResponse.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardId").getter(DescribeDashboardSnapshotJobResponse.getter(DescribeDashboardSnapshotJobResponse::dashboardId)).setter(DescribeDashboardSnapshotJobResponse.setter(Builder::dashboardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()}).build();
    private static final SdkField<String> SNAPSHOT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotJobId").getter(DescribeDashboardSnapshotJobResponse.getter(DescribeDashboardSnapshotJobResponse::snapshotJobId)).setter(DescribeDashboardSnapshotJobResponse.setter(Builder::snapshotJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotJobId").build()}).build();
    private static final SdkField<SnapshotUserConfigurationRedacted> USER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserConfiguration").getter(DescribeDashboardSnapshotJobResponse.getter(DescribeDashboardSnapshotJobResponse::userConfiguration)).setter(DescribeDashboardSnapshotJobResponse.setter(Builder::userConfiguration)).constructor(SnapshotUserConfigurationRedacted::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserConfiguration").build()}).build();
    private static final SdkField<SnapshotConfiguration> SNAPSHOT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnapshotConfiguration").getter(DescribeDashboardSnapshotJobResponse.getter(DescribeDashboardSnapshotJobResponse::snapshotConfiguration)).setter(DescribeDashboardSnapshotJobResponse.setter(Builder::snapshotConfiguration)).constructor(SnapshotConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotConfiguration").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeDashboardSnapshotJobResponse.getter(DescribeDashboardSnapshotJobResponse::arn)).setter(DescribeDashboardSnapshotJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(DescribeDashboardSnapshotJobResponse.getter(DescribeDashboardSnapshotJobResponse::jobStatusAsString)).setter(DescribeDashboardSnapshotJobResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DescribeDashboardSnapshotJobResponse.getter(DescribeDashboardSnapshotJobResponse::createdTime)).setter(DescribeDashboardSnapshotJobResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(DescribeDashboardSnapshotJobResponse.getter(DescribeDashboardSnapshotJobResponse::lastUpdatedTime)).setter(DescribeDashboardSnapshotJobResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeDashboardSnapshotJobResponse.getter(DescribeDashboardSnapshotJobResponse::requestId)).setter(DescribeDashboardSnapshotJobResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeDashboardSnapshotJobResponse.getter(DescribeDashboardSnapshotJobResponse::status)).setter(DescribeDashboardSnapshotJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DASHBOARD_ID_FIELD, SNAPSHOT_JOB_ID_FIELD, USER_CONFIGURATION_FIELD, SNAPSHOT_CONFIGURATION_FIELD, ARN_FIELD, JOB_STATUS_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDashboardSnapshotJobResponse.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String dashboardId;
    private final String snapshotJobId;
    private final SnapshotUserConfigurationRedacted userConfiguration;
    private final SnapshotConfiguration snapshotConfiguration;
    private final String arn;
    private final String jobStatus;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final String requestId;
    private final Integer status;

    private DescribeDashboardSnapshotJobResponse(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.snapshotJobId = builder.snapshotJobId;
        this.userConfiguration = builder.userConfiguration;
        this.snapshotConfiguration = builder.snapshotConfiguration;
        this.arn = builder.arn;
        this.jobStatus = builder.jobStatus;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String dashboardId() {
        return this.dashboardId;
    }

    public final String snapshotJobId() {
        return this.snapshotJobId;
    }

    public final SnapshotUserConfigurationRedacted userConfiguration() {
        return this.userConfiguration;
    }

    public final SnapshotConfiguration snapshotConfiguration() {
        return this.snapshotConfiguration;
    }

    public final String arn() {
        return this.arn;
    }

    public final SnapshotJobStatus jobStatus() {
        return SnapshotJobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDashboardSnapshotJobResponse)) {
            return false;
        }
        DescribeDashboardSnapshotJobResponse other = (DescribeDashboardSnapshotJobResponse)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.dashboardId(), other.dashboardId()) && Objects.equals(this.snapshotJobId(), other.snapshotJobId()) && Objects.equals(this.userConfiguration(), other.userConfiguration()) && Objects.equals(this.snapshotConfiguration(), other.snapshotConfiguration()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDashboardSnapshotJobResponse").add("AwsAccountId", (Object)this.awsAccountId()).add("DashboardId", (Object)this.dashboardId()).add("SnapshotJobId", (Object)this.snapshotJobId()).add("UserConfiguration", (Object)this.userConfiguration()).add("SnapshotConfiguration", (Object)this.snapshotConfiguration()).add("Arn", (Object)this.arn()).add("JobStatus", (Object)this.jobStatusAsString()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "DashboardId": {
                return Optional.ofNullable(clazz.cast(this.dashboardId()));
            }
            case "SnapshotJobId": {
                return Optional.ofNullable(clazz.cast(this.snapshotJobId()));
            }
            case "UserConfiguration": {
                return Optional.ofNullable(clazz.cast(this.userConfiguration()));
            }
            case "SnapshotConfiguration": {
                return Optional.ofNullable(clazz.cast(this.snapshotConfiguration()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("DashboardId", DASHBOARD_ID_FIELD);
        map.put("SnapshotJobId", SNAPSHOT_JOB_ID_FIELD);
        map.put("UserConfiguration", USER_CONFIGURATION_FIELD);
        map.put("SnapshotConfiguration", SNAPSHOT_CONFIGURATION_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDashboardSnapshotJobResponse, T> g) {
        return obj -> g.apply((DescribeDashboardSnapshotJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String dashboardId;
        private String snapshotJobId;
        private SnapshotUserConfigurationRedacted userConfiguration;
        private SnapshotConfiguration snapshotConfiguration;
        private String arn;
        private String jobStatus;
        private Instant createdTime;
        private Instant lastUpdatedTime;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDashboardSnapshotJobResponse model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.dashboardId(model.dashboardId);
            this.snapshotJobId(model.snapshotJobId);
            this.userConfiguration(model.userConfiguration);
            this.snapshotConfiguration(model.snapshotConfiguration);
            this.arn(model.arn);
            this.jobStatus(model.jobStatus);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDashboardId() {
            return this.dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getSnapshotJobId() {
            return this.snapshotJobId;
        }

        public final void setSnapshotJobId(String snapshotJobId) {
            this.snapshotJobId = snapshotJobId;
        }

        @Override
        public final Builder snapshotJobId(String snapshotJobId) {
            this.snapshotJobId = snapshotJobId;
            return this;
        }

        public final SnapshotUserConfigurationRedacted.Builder getUserConfiguration() {
            return this.userConfiguration != null ? this.userConfiguration.toBuilder() : null;
        }

        public final void setUserConfiguration(SnapshotUserConfigurationRedacted.BuilderImpl userConfiguration) {
            this.userConfiguration = userConfiguration != null ? userConfiguration.build() : null;
        }

        @Override
        public final Builder userConfiguration(SnapshotUserConfigurationRedacted userConfiguration) {
            this.userConfiguration = userConfiguration;
            return this;
        }

        public final SnapshotConfiguration.Builder getSnapshotConfiguration() {
            return this.snapshotConfiguration != null ? this.snapshotConfiguration.toBuilder() : null;
        }

        public final void setSnapshotConfiguration(SnapshotConfiguration.BuilderImpl snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration != null ? snapshotConfiguration.build() : null;
        }

        @Override
        public final Builder snapshotConfiguration(SnapshotConfiguration snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(SnapshotJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeDashboardSnapshotJobResponse build() {
            return new DescribeDashboardSnapshotJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDashboardSnapshotJobResponse> {
        public Builder awsAccountId(String var1);

        public Builder dashboardId(String var1);

        public Builder snapshotJobId(String var1);

        public Builder userConfiguration(SnapshotUserConfigurationRedacted var1);

        default public Builder userConfiguration(Consumer<SnapshotUserConfigurationRedacted.Builder> userConfiguration) {
            return this.userConfiguration((SnapshotUserConfigurationRedacted)((SnapshotUserConfigurationRedacted.Builder)SnapshotUserConfigurationRedacted.builder().applyMutation(userConfiguration)).build());
        }

        public Builder snapshotConfiguration(SnapshotConfiguration var1);

        default public Builder snapshotConfiguration(Consumer<SnapshotConfiguration.Builder> snapshotConfiguration) {
            return this.snapshotConfiguration((SnapshotConfiguration)((SnapshotConfiguration.Builder)SnapshotConfiguration.builder().applyMutation(snapshotConfiguration)).build());
        }

        public Builder arn(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(SnapshotJobStatus var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

