/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DecalStyleType {
    MANUAL("Manual"),
    AUTO("Auto"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DecalStyleType> VALUE_MAP;
    private final String value;

    private DecalStyleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DecalStyleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DecalStyleType> knownValues() {
        EnumSet<DecalStyleType> knownValues = EnumSet.allOf(DecalStyleType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DecalStyleType.class, DecalStyleType::toString);
    }
}

