/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ActionConnectorType;
import software.amazon.awssdk.services.quicksight.model.AuthConfig;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.ResourcePermission;
import software.amazon.awssdk.services.quicksight.model.ResourcePermissionListCopier;
import software.amazon.awssdk.services.quicksight.model.Tag;
import software.amazon.awssdk.services.quicksight.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateActionConnectorRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, CreateActionConnectorRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(CreateActionConnectorRequest.getter(CreateActionConnectorRequest::awsAccountId)).setter(CreateActionConnectorRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> ACTION_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionConnectorId").getter(CreateActionConnectorRequest.getter(CreateActionConnectorRequest::actionConnectorId)).setter(CreateActionConnectorRequest.setter(Builder::actionConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionConnectorId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateActionConnectorRequest.getter(CreateActionConnectorRequest::name)).setter(CreateActionConnectorRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateActionConnectorRequest.getter(CreateActionConnectorRequest::typeAsString)).setter(CreateActionConnectorRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<AuthConfig> AUTHENTICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationConfig").getter(CreateActionConnectorRequest.getter(CreateActionConnectorRequest::authenticationConfig)).setter(CreateActionConnectorRequest.setter(Builder::authenticationConfig)).constructor(AuthConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfig").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateActionConnectorRequest.getter(CreateActionConnectorRequest::description)).setter(CreateActionConnectorRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(CreateActionConnectorRequest.getter(CreateActionConnectorRequest::permissions)).setter(CreateActionConnectorRequest.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcConnectionArn").getter(CreateActionConnectorRequest.getter(CreateActionConnectorRequest::vpcConnectionArn)).setter(CreateActionConnectorRequest.setter(Builder::vpcConnectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectionArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateActionConnectorRequest.getter(CreateActionConnectorRequest::tags)).setter(CreateActionConnectorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, ACTION_CONNECTOR_ID_FIELD, NAME_FIELD, TYPE_FIELD, AUTHENTICATION_CONFIG_FIELD, DESCRIPTION_FIELD, PERMISSIONS_FIELD, VPC_CONNECTION_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateActionConnectorRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String actionConnectorId;
    private final String name;
    private final String type;
    private final AuthConfig authenticationConfig;
    private final String description;
    private final List<ResourcePermission> permissions;
    private final String vpcConnectionArn;
    private final List<Tag> tags;

    private CreateActionConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.actionConnectorId = builder.actionConnectorId;
        this.name = builder.name;
        this.type = builder.type;
        this.authenticationConfig = builder.authenticationConfig;
        this.description = builder.description;
        this.permissions = builder.permissions;
        this.vpcConnectionArn = builder.vpcConnectionArn;
        this.tags = builder.tags;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String actionConnectorId() {
        return this.actionConnectorId;
    }

    public final String name() {
        return this.name;
    }

    public final ActionConnectorType type() {
        return ActionConnectorType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final AuthConfig authenticationConfig() {
        return this.authenticationConfig;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePermission> permissions() {
        return this.permissions;
    }

    public final String vpcConnectionArn() {
        return this.vpcConnectionArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActionConnectorRequest)) {
            return false;
        }
        CreateActionConnectorRequest other = (CreateActionConnectorRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.actionConnectorId(), other.actionConnectorId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.authenticationConfig(), other.authenticationConfig()) && Objects.equals(this.description(), other.description()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.vpcConnectionArn(), other.vpcConnectionArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateActionConnectorRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("ActionConnectorId", (Object)this.actionConnectorId()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("AuthenticationConfig", (Object)this.authenticationConfig()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Permissions", this.hasPermissions() ? this.permissions() : null).add("VpcConnectionArn", (Object)this.vpcConnectionArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "ActionConnectorId": {
                return Optional.ofNullable(clazz.cast(this.actionConnectorId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "AuthenticationConfig": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfig()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "VpcConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("ActionConnectorId", ACTION_CONNECTOR_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("AuthenticationConfig", AUTHENTICATION_CONFIG_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("VpcConnectionArn", VPC_CONNECTION_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateActionConnectorRequest, T> g) {
        return obj -> g.apply((CreateActionConnectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String actionConnectorId;
        private String name;
        private String type;
        private AuthConfig authenticationConfig;
        private String description;
        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();
        private String vpcConnectionArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateActionConnectorRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.actionConnectorId(model.actionConnectorId);
            this.name(model.name);
            this.type(model.type);
            this.authenticationConfig(model.authenticationConfig);
            this.description(model.description);
            this.permissions(model.permissions);
            this.vpcConnectionArn(model.vpcConnectionArn);
            this.tags(model.tags);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getActionConnectorId() {
            return this.actionConnectorId;
        }

        public final void setActionConnectorId(String actionConnectorId) {
            this.actionConnectorId = actionConnectorId;
        }

        @Override
        public final Builder actionConnectorId(String actionConnectorId) {
            this.actionConnectorId = actionConnectorId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActionConnectorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final AuthConfig.Builder getAuthenticationConfig() {
            return this.authenticationConfig != null ? this.authenticationConfig.toBuilder() : null;
        }

        public final void setAuthenticationConfig(AuthConfig.BuilderImpl authenticationConfig) {
            this.authenticationConfig = authenticationConfig != null ? authenticationConfig.build() : null;
        }

        @Override
        public final Builder authenticationConfig(AuthConfig authenticationConfig) {
            this.authenticationConfig = authenticationConfig;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder> ... permissions) {
            this.permissions(Stream.of(permissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpcConnectionArn() {
            return this.vpcConnectionArn;
        }

        public final void setVpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
        }

        @Override
        public final Builder vpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateActionConnectorRequest build() {
            return new CreateActionConnectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateActionConnectorRequest> {
        public Builder awsAccountId(String var1);

        public Builder actionConnectorId(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ActionConnectorType var1);

        public Builder authenticationConfig(AuthConfig var1);

        default public Builder authenticationConfig(Consumer<AuthConfig.Builder> authenticationConfig) {
            return this.authenticationConfig((AuthConfig)((AuthConfig.Builder)AuthConfig.builder().applyMutation(authenticationConfig)).build());
        }

        public Builder description(String var1);

        public Builder permissions(Collection<ResourcePermission> var1);

        public Builder permissions(ResourcePermission ... var1);

        public Builder permissions(Consumer<ResourcePermission.Builder> ... var1);

        public Builder vpcConnectionArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

