/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AxisDisplayOptions;
import software.amazon.awssdk.services.quicksight.model.BarsArrangement;
import software.amazon.awssdk.services.quicksight.model.ChartAxisLabelOptions;
import software.amazon.awssdk.services.quicksight.model.ComboChartDefaultSeriesSettings;
import software.amazon.awssdk.services.quicksight.model.ComboChartFieldWells;
import software.amazon.awssdk.services.quicksight.model.ComboChartSortConfiguration;
import software.amazon.awssdk.services.quicksight.model.ComboSeriesItem;
import software.amazon.awssdk.services.quicksight.model.ComboSeriesItemListCopier;
import software.amazon.awssdk.services.quicksight.model.DataLabelOptions;
import software.amazon.awssdk.services.quicksight.model.LegendOptions;
import software.amazon.awssdk.services.quicksight.model.ReferenceLine;
import software.amazon.awssdk.services.quicksight.model.ReferenceLineListCopier;
import software.amazon.awssdk.services.quicksight.model.SingleAxisOptions;
import software.amazon.awssdk.services.quicksight.model.TooltipOptions;
import software.amazon.awssdk.services.quicksight.model.VisualInteractionOptions;
import software.amazon.awssdk.services.quicksight.model.VisualPalette;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComboChartConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComboChartConfiguration> {
    private static final SdkField<ComboChartFieldWells> FIELD_WELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldWells").getter(ComboChartConfiguration.getter(ComboChartConfiguration::fieldWells)).setter(ComboChartConfiguration.setter(Builder::fieldWells)).constructor(ComboChartFieldWells::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()}).build();
    private static final SdkField<ComboChartSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortConfiguration").getter(ComboChartConfiguration.getter(ComboChartConfiguration::sortConfiguration)).setter(ComboChartConfiguration.setter(Builder::sortConfiguration)).constructor(ComboChartSortConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()}).build();
    private static final SdkField<String> BARS_ARRANGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BarsArrangement").getter(ComboChartConfiguration.getter(ComboChartConfiguration::barsArrangementAsString)).setter(ComboChartConfiguration.setter(Builder::barsArrangement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BarsArrangement").build()}).build();
    private static final SdkField<AxisDisplayOptions> CATEGORY_AXIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryAxis").getter(ComboChartConfiguration.getter(ComboChartConfiguration::categoryAxis)).setter(ComboChartConfiguration.setter(Builder::categoryAxis)).constructor(AxisDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryAxis").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> CATEGORY_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryLabelOptions").getter(ComboChartConfiguration.getter(ComboChartConfiguration::categoryLabelOptions)).setter(ComboChartConfiguration.setter(Builder::categoryLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelOptions").build()}).build();
    private static final SdkField<AxisDisplayOptions> PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryYAxisDisplayOptions").getter(ComboChartConfiguration.getter(ComboChartConfiguration::primaryYAxisDisplayOptions)).setter(ComboChartConfiguration.setter(Builder::primaryYAxisDisplayOptions)).constructor(AxisDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryYAxisDisplayOptions").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryYAxisLabelOptions").getter(ComboChartConfiguration.getter(ComboChartConfiguration::primaryYAxisLabelOptions)).setter(ComboChartConfiguration.setter(Builder::primaryYAxisLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryYAxisLabelOptions").build()}).build();
    private static final SdkField<AxisDisplayOptions> SECONDARY_Y_AXIS_DISPLAY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecondaryYAxisDisplayOptions").getter(ComboChartConfiguration.getter(ComboChartConfiguration::secondaryYAxisDisplayOptions)).setter(ComboChartConfiguration.setter(Builder::secondaryYAxisDisplayOptions)).constructor(AxisDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryYAxisDisplayOptions").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> SECONDARY_Y_AXIS_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecondaryYAxisLabelOptions").getter(ComboChartConfiguration.getter(ComboChartConfiguration::secondaryYAxisLabelOptions)).setter(ComboChartConfiguration.setter(Builder::secondaryYAxisLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryYAxisLabelOptions").build()}).build();
    private static final SdkField<SingleAxisOptions> SINGLE_AXIS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SingleAxisOptions").getter(ComboChartConfiguration.getter(ComboChartConfiguration::singleAxisOptions)).setter(ComboChartConfiguration.setter(Builder::singleAxisOptions)).constructor(SingleAxisOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleAxisOptions").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> COLOR_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColorLabelOptions").getter(ComboChartConfiguration.getter(ComboChartConfiguration::colorLabelOptions)).setter(ComboChartConfiguration.setter(Builder::colorLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorLabelOptions").build()}).build();
    private static final SdkField<ComboChartDefaultSeriesSettings> DEFAULT_SERIES_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultSeriesSettings").getter(ComboChartConfiguration.getter(ComboChartConfiguration::defaultSeriesSettings)).setter(ComboChartConfiguration.setter(Builder::defaultSeriesSettings)).constructor(ComboChartDefaultSeriesSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSeriesSettings").build()}).build();
    private static final SdkField<List<ComboSeriesItem>> SERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Series").getter(ComboChartConfiguration.getter(ComboChartConfiguration::series)).setter(ComboChartConfiguration.setter(Builder::series)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Series").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComboSeriesItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Legend").getter(ComboChartConfiguration.getter(ComboChartConfiguration::legend)).setter(ComboChartConfiguration.setter(Builder::legend)).constructor(LegendOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()}).build();
    private static final SdkField<DataLabelOptions> BAR_DATA_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BarDataLabels").getter(ComboChartConfiguration.getter(ComboChartConfiguration::barDataLabels)).setter(ComboChartConfiguration.setter(Builder::barDataLabels)).constructor(DataLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BarDataLabels").build()}).build();
    private static final SdkField<DataLabelOptions> LINE_DATA_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LineDataLabels").getter(ComboChartConfiguration.getter(ComboChartConfiguration::lineDataLabels)).setter(ComboChartConfiguration.setter(Builder::lineDataLabels)).constructor(DataLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineDataLabels").build()}).build();
    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tooltip").getter(ComboChartConfiguration.getter(ComboChartConfiguration::tooltip)).setter(ComboChartConfiguration.setter(Builder::tooltip)).constructor(TooltipOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()}).build();
    private static final SdkField<List<ReferenceLine>> REFERENCE_LINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferenceLines").getter(ComboChartConfiguration.getter(ComboChartConfiguration::referenceLines)).setter(ComboChartConfiguration.setter(Builder::referenceLines)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceLines").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReferenceLine::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualPalette").getter(ComboChartConfiguration.getter(ComboChartConfiguration::visualPalette)).setter(ComboChartConfiguration.setter(Builder::visualPalette)).constructor(VisualPalette::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()}).build();
    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Interactions").getter(ComboChartConfiguration.getter(ComboChartConfiguration::interactions)).setter(ComboChartConfiguration.setter(Builder::interactions)).constructor(VisualInteractionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD, SORT_CONFIGURATION_FIELD, BARS_ARRANGEMENT_FIELD, CATEGORY_AXIS_FIELD, CATEGORY_LABEL_OPTIONS_FIELD, PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD, PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD, SECONDARY_Y_AXIS_DISPLAY_OPTIONS_FIELD, SECONDARY_Y_AXIS_LABEL_OPTIONS_FIELD, SINGLE_AXIS_OPTIONS_FIELD, COLOR_LABEL_OPTIONS_FIELD, DEFAULT_SERIES_SETTINGS_FIELD, SERIES_FIELD, LEGEND_FIELD, BAR_DATA_LABELS_FIELD, LINE_DATA_LABELS_FIELD, TOOLTIP_FIELD, REFERENCE_LINES_FIELD, VISUAL_PALETTE_FIELD, INTERACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComboChartConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ComboChartFieldWells fieldWells;
    private final ComboChartSortConfiguration sortConfiguration;
    private final String barsArrangement;
    private final AxisDisplayOptions categoryAxis;
    private final ChartAxisLabelOptions categoryLabelOptions;
    private final AxisDisplayOptions primaryYAxisDisplayOptions;
    private final ChartAxisLabelOptions primaryYAxisLabelOptions;
    private final AxisDisplayOptions secondaryYAxisDisplayOptions;
    private final ChartAxisLabelOptions secondaryYAxisLabelOptions;
    private final SingleAxisOptions singleAxisOptions;
    private final ChartAxisLabelOptions colorLabelOptions;
    private final ComboChartDefaultSeriesSettings defaultSeriesSettings;
    private final List<ComboSeriesItem> series;
    private final LegendOptions legend;
    private final DataLabelOptions barDataLabels;
    private final DataLabelOptions lineDataLabels;
    private final TooltipOptions tooltip;
    private final List<ReferenceLine> referenceLines;
    private final VisualPalette visualPalette;
    private final VisualInteractionOptions interactions;

    private ComboChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.barsArrangement = builder.barsArrangement;
        this.categoryAxis = builder.categoryAxis;
        this.categoryLabelOptions = builder.categoryLabelOptions;
        this.primaryYAxisDisplayOptions = builder.primaryYAxisDisplayOptions;
        this.primaryYAxisLabelOptions = builder.primaryYAxisLabelOptions;
        this.secondaryYAxisDisplayOptions = builder.secondaryYAxisDisplayOptions;
        this.secondaryYAxisLabelOptions = builder.secondaryYAxisLabelOptions;
        this.singleAxisOptions = builder.singleAxisOptions;
        this.colorLabelOptions = builder.colorLabelOptions;
        this.defaultSeriesSettings = builder.defaultSeriesSettings;
        this.series = builder.series;
        this.legend = builder.legend;
        this.barDataLabels = builder.barDataLabels;
        this.lineDataLabels = builder.lineDataLabels;
        this.tooltip = builder.tooltip;
        this.referenceLines = builder.referenceLines;
        this.visualPalette = builder.visualPalette;
        this.interactions = builder.interactions;
    }

    public final ComboChartFieldWells fieldWells() {
        return this.fieldWells;
    }

    public final ComboChartSortConfiguration sortConfiguration() {
        return this.sortConfiguration;
    }

    public final BarsArrangement barsArrangement() {
        return BarsArrangement.fromValue(this.barsArrangement);
    }

    public final String barsArrangementAsString() {
        return this.barsArrangement;
    }

    public final AxisDisplayOptions categoryAxis() {
        return this.categoryAxis;
    }

    public final ChartAxisLabelOptions categoryLabelOptions() {
        return this.categoryLabelOptions;
    }

    public final AxisDisplayOptions primaryYAxisDisplayOptions() {
        return this.primaryYAxisDisplayOptions;
    }

    public final ChartAxisLabelOptions primaryYAxisLabelOptions() {
        return this.primaryYAxisLabelOptions;
    }

    public final AxisDisplayOptions secondaryYAxisDisplayOptions() {
        return this.secondaryYAxisDisplayOptions;
    }

    public final ChartAxisLabelOptions secondaryYAxisLabelOptions() {
        return this.secondaryYAxisLabelOptions;
    }

    public final SingleAxisOptions singleAxisOptions() {
        return this.singleAxisOptions;
    }

    public final ChartAxisLabelOptions colorLabelOptions() {
        return this.colorLabelOptions;
    }

    public final ComboChartDefaultSeriesSettings defaultSeriesSettings() {
        return this.defaultSeriesSettings;
    }

    public final boolean hasSeries() {
        return this.series != null && !(this.series instanceof SdkAutoConstructList);
    }

    public final List<ComboSeriesItem> series() {
        return this.series;
    }

    public final LegendOptions legend() {
        return this.legend;
    }

    public final DataLabelOptions barDataLabels() {
        return this.barDataLabels;
    }

    public final DataLabelOptions lineDataLabels() {
        return this.lineDataLabels;
    }

    public final TooltipOptions tooltip() {
        return this.tooltip;
    }

    public final boolean hasReferenceLines() {
        return this.referenceLines != null && !(this.referenceLines instanceof SdkAutoConstructList);
    }

    public final List<ReferenceLine> referenceLines() {
        return this.referenceLines;
    }

    public final VisualPalette visualPalette() {
        return this.visualPalette;
    }

    public final VisualInteractionOptions interactions() {
        return this.interactions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.barsArrangementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAxis());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryYAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryYAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryYAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryYAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleAxisOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSeriesSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSeries() ? this.series() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.legend());
        hashCode = 31 * hashCode + Objects.hashCode(this.barDataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineDataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceLines() ? this.referenceLines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComboChartConfiguration)) {
            return false;
        }
        ComboChartConfiguration other = (ComboChartConfiguration)obj;
        return Objects.equals(this.fieldWells(), other.fieldWells()) && Objects.equals(this.sortConfiguration(), other.sortConfiguration()) && Objects.equals(this.barsArrangementAsString(), other.barsArrangementAsString()) && Objects.equals(this.categoryAxis(), other.categoryAxis()) && Objects.equals(this.categoryLabelOptions(), other.categoryLabelOptions()) && Objects.equals(this.primaryYAxisDisplayOptions(), other.primaryYAxisDisplayOptions()) && Objects.equals(this.primaryYAxisLabelOptions(), other.primaryYAxisLabelOptions()) && Objects.equals(this.secondaryYAxisDisplayOptions(), other.secondaryYAxisDisplayOptions()) && Objects.equals(this.secondaryYAxisLabelOptions(), other.secondaryYAxisLabelOptions()) && Objects.equals(this.singleAxisOptions(), other.singleAxisOptions()) && Objects.equals(this.colorLabelOptions(), other.colorLabelOptions()) && Objects.equals(this.defaultSeriesSettings(), other.defaultSeriesSettings()) && this.hasSeries() == other.hasSeries() && Objects.equals(this.series(), other.series()) && Objects.equals(this.legend(), other.legend()) && Objects.equals(this.barDataLabels(), other.barDataLabels()) && Objects.equals(this.lineDataLabels(), other.lineDataLabels()) && Objects.equals(this.tooltip(), other.tooltip()) && this.hasReferenceLines() == other.hasReferenceLines() && Objects.equals(this.referenceLines(), other.referenceLines()) && Objects.equals(this.visualPalette(), other.visualPalette()) && Objects.equals(this.interactions(), other.interactions());
    }

    public final String toString() {
        return ToString.builder((String)"ComboChartConfiguration").add("FieldWells", (Object)this.fieldWells()).add("SortConfiguration", (Object)this.sortConfiguration()).add("BarsArrangement", (Object)this.barsArrangementAsString()).add("CategoryAxis", (Object)this.categoryAxis()).add("CategoryLabelOptions", (Object)this.categoryLabelOptions()).add("PrimaryYAxisDisplayOptions", (Object)this.primaryYAxisDisplayOptions()).add("PrimaryYAxisLabelOptions", (Object)this.primaryYAxisLabelOptions()).add("SecondaryYAxisDisplayOptions", (Object)this.secondaryYAxisDisplayOptions()).add("SecondaryYAxisLabelOptions", (Object)this.secondaryYAxisLabelOptions()).add("SingleAxisOptions", (Object)this.singleAxisOptions()).add("ColorLabelOptions", (Object)this.colorLabelOptions()).add("DefaultSeriesSettings", (Object)this.defaultSeriesSettings()).add("Series", this.hasSeries() ? this.series() : null).add("Legend", (Object)this.legend()).add("BarDataLabels", (Object)this.barDataLabels()).add("LineDataLabels", (Object)this.lineDataLabels()).add("Tooltip", (Object)this.tooltip()).add("ReferenceLines", this.hasReferenceLines() ? this.referenceLines() : null).add("VisualPalette", (Object)this.visualPalette()).add("Interactions", (Object)this.interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldWells": {
                return Optional.ofNullable(clazz.cast(this.fieldWells()));
            }
            case "SortConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sortConfiguration()));
            }
            case "BarsArrangement": {
                return Optional.ofNullable(clazz.cast(this.barsArrangementAsString()));
            }
            case "CategoryAxis": {
                return Optional.ofNullable(clazz.cast(this.categoryAxis()));
            }
            case "CategoryLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.categoryLabelOptions()));
            }
            case "PrimaryYAxisDisplayOptions": {
                return Optional.ofNullable(clazz.cast(this.primaryYAxisDisplayOptions()));
            }
            case "PrimaryYAxisLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.primaryYAxisLabelOptions()));
            }
            case "SecondaryYAxisDisplayOptions": {
                return Optional.ofNullable(clazz.cast(this.secondaryYAxisDisplayOptions()));
            }
            case "SecondaryYAxisLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.secondaryYAxisLabelOptions()));
            }
            case "SingleAxisOptions": {
                return Optional.ofNullable(clazz.cast(this.singleAxisOptions()));
            }
            case "ColorLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.colorLabelOptions()));
            }
            case "DefaultSeriesSettings": {
                return Optional.ofNullable(clazz.cast(this.defaultSeriesSettings()));
            }
            case "Series": {
                return Optional.ofNullable(clazz.cast(this.series()));
            }
            case "Legend": {
                return Optional.ofNullable(clazz.cast(this.legend()));
            }
            case "BarDataLabels": {
                return Optional.ofNullable(clazz.cast(this.barDataLabels()));
            }
            case "LineDataLabels": {
                return Optional.ofNullable(clazz.cast(this.lineDataLabels()));
            }
            case "Tooltip": {
                return Optional.ofNullable(clazz.cast(this.tooltip()));
            }
            case "ReferenceLines": {
                return Optional.ofNullable(clazz.cast(this.referenceLines()));
            }
            case "VisualPalette": {
                return Optional.ofNullable(clazz.cast(this.visualPalette()));
            }
            case "Interactions": {
                return Optional.ofNullable(clazz.cast(this.interactions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("SortConfiguration", SORT_CONFIGURATION_FIELD);
        map.put("BarsArrangement", BARS_ARRANGEMENT_FIELD);
        map.put("CategoryAxis", CATEGORY_AXIS_FIELD);
        map.put("CategoryLabelOptions", CATEGORY_LABEL_OPTIONS_FIELD);
        map.put("PrimaryYAxisDisplayOptions", PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD);
        map.put("PrimaryYAxisLabelOptions", PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD);
        map.put("SecondaryYAxisDisplayOptions", SECONDARY_Y_AXIS_DISPLAY_OPTIONS_FIELD);
        map.put("SecondaryYAxisLabelOptions", SECONDARY_Y_AXIS_LABEL_OPTIONS_FIELD);
        map.put("SingleAxisOptions", SINGLE_AXIS_OPTIONS_FIELD);
        map.put("ColorLabelOptions", COLOR_LABEL_OPTIONS_FIELD);
        map.put("DefaultSeriesSettings", DEFAULT_SERIES_SETTINGS_FIELD);
        map.put("Series", SERIES_FIELD);
        map.put("Legend", LEGEND_FIELD);
        map.put("BarDataLabels", BAR_DATA_LABELS_FIELD);
        map.put("LineDataLabels", LINE_DATA_LABELS_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        map.put("ReferenceLines", REFERENCE_LINES_FIELD);
        map.put("VisualPalette", VISUAL_PALETTE_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComboChartConfiguration, T> g) {
        return obj -> g.apply((ComboChartConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ComboChartFieldWells fieldWells;
        private ComboChartSortConfiguration sortConfiguration;
        private String barsArrangement;
        private AxisDisplayOptions categoryAxis;
        private ChartAxisLabelOptions categoryLabelOptions;
        private AxisDisplayOptions primaryYAxisDisplayOptions;
        private ChartAxisLabelOptions primaryYAxisLabelOptions;
        private AxisDisplayOptions secondaryYAxisDisplayOptions;
        private ChartAxisLabelOptions secondaryYAxisLabelOptions;
        private SingleAxisOptions singleAxisOptions;
        private ChartAxisLabelOptions colorLabelOptions;
        private ComboChartDefaultSeriesSettings defaultSeriesSettings;
        private List<ComboSeriesItem> series = DefaultSdkAutoConstructList.getInstance();
        private LegendOptions legend;
        private DataLabelOptions barDataLabels;
        private DataLabelOptions lineDataLabels;
        private TooltipOptions tooltip;
        private List<ReferenceLine> referenceLines = DefaultSdkAutoConstructList.getInstance();
        private VisualPalette visualPalette;
        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(ComboChartConfiguration model) {
            this.fieldWells(model.fieldWells);
            this.sortConfiguration(model.sortConfiguration);
            this.barsArrangement(model.barsArrangement);
            this.categoryAxis(model.categoryAxis);
            this.categoryLabelOptions(model.categoryLabelOptions);
            this.primaryYAxisDisplayOptions(model.primaryYAxisDisplayOptions);
            this.primaryYAxisLabelOptions(model.primaryYAxisLabelOptions);
            this.secondaryYAxisDisplayOptions(model.secondaryYAxisDisplayOptions);
            this.secondaryYAxisLabelOptions(model.secondaryYAxisLabelOptions);
            this.singleAxisOptions(model.singleAxisOptions);
            this.colorLabelOptions(model.colorLabelOptions);
            this.defaultSeriesSettings(model.defaultSeriesSettings);
            this.series(model.series);
            this.legend(model.legend);
            this.barDataLabels(model.barDataLabels);
            this.lineDataLabels(model.lineDataLabels);
            this.tooltip(model.tooltip);
            this.referenceLines(model.referenceLines);
            this.visualPalette(model.visualPalette);
            this.interactions(model.interactions);
        }

        public final ComboChartFieldWells.Builder getFieldWells() {
            return this.fieldWells != null ? this.fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(ComboChartFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(ComboChartFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final ComboChartSortConfiguration.Builder getSortConfiguration() {
            return this.sortConfiguration != null ? this.sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(ComboChartSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(ComboChartSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final String getBarsArrangement() {
            return this.barsArrangement;
        }

        public final void setBarsArrangement(String barsArrangement) {
            this.barsArrangement = barsArrangement;
        }

        @Override
        public final Builder barsArrangement(String barsArrangement) {
            this.barsArrangement = barsArrangement;
            return this;
        }

        @Override
        public final Builder barsArrangement(BarsArrangement barsArrangement) {
            this.barsArrangement(barsArrangement == null ? null : barsArrangement.toString());
            return this;
        }

        public final AxisDisplayOptions.Builder getCategoryAxis() {
            return this.categoryAxis != null ? this.categoryAxis.toBuilder() : null;
        }

        public final void setCategoryAxis(AxisDisplayOptions.BuilderImpl categoryAxis) {
            this.categoryAxis = categoryAxis != null ? categoryAxis.build() : null;
        }

        @Override
        public final Builder categoryAxis(AxisDisplayOptions categoryAxis) {
            this.categoryAxis = categoryAxis;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getCategoryLabelOptions() {
            return this.categoryLabelOptions != null ? this.categoryLabelOptions.toBuilder() : null;
        }

        public final void setCategoryLabelOptions(ChartAxisLabelOptions.BuilderImpl categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions != null ? categoryLabelOptions.build() : null;
        }

        @Override
        public final Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getPrimaryYAxisDisplayOptions() {
            return this.primaryYAxisDisplayOptions != null ? this.primaryYAxisDisplayOptions.toBuilder() : null;
        }

        public final void setPrimaryYAxisDisplayOptions(AxisDisplayOptions.BuilderImpl primaryYAxisDisplayOptions) {
            this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions != null ? primaryYAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder primaryYAxisDisplayOptions(AxisDisplayOptions primaryYAxisDisplayOptions) {
            this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getPrimaryYAxisLabelOptions() {
            return this.primaryYAxisLabelOptions != null ? this.primaryYAxisLabelOptions.toBuilder() : null;
        }

        public final void setPrimaryYAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl primaryYAxisLabelOptions) {
            this.primaryYAxisLabelOptions = primaryYAxisLabelOptions != null ? primaryYAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder primaryYAxisLabelOptions(ChartAxisLabelOptions primaryYAxisLabelOptions) {
            this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getSecondaryYAxisDisplayOptions() {
            return this.secondaryYAxisDisplayOptions != null ? this.secondaryYAxisDisplayOptions.toBuilder() : null;
        }

        public final void setSecondaryYAxisDisplayOptions(AxisDisplayOptions.BuilderImpl secondaryYAxisDisplayOptions) {
            this.secondaryYAxisDisplayOptions = secondaryYAxisDisplayOptions != null ? secondaryYAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder secondaryYAxisDisplayOptions(AxisDisplayOptions secondaryYAxisDisplayOptions) {
            this.secondaryYAxisDisplayOptions = secondaryYAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getSecondaryYAxisLabelOptions() {
            return this.secondaryYAxisLabelOptions != null ? this.secondaryYAxisLabelOptions.toBuilder() : null;
        }

        public final void setSecondaryYAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl secondaryYAxisLabelOptions) {
            this.secondaryYAxisLabelOptions = secondaryYAxisLabelOptions != null ? secondaryYAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder secondaryYAxisLabelOptions(ChartAxisLabelOptions secondaryYAxisLabelOptions) {
            this.secondaryYAxisLabelOptions = secondaryYAxisLabelOptions;
            return this;
        }

        public final SingleAxisOptions.Builder getSingleAxisOptions() {
            return this.singleAxisOptions != null ? this.singleAxisOptions.toBuilder() : null;
        }

        public final void setSingleAxisOptions(SingleAxisOptions.BuilderImpl singleAxisOptions) {
            this.singleAxisOptions = singleAxisOptions != null ? singleAxisOptions.build() : null;
        }

        @Override
        public final Builder singleAxisOptions(SingleAxisOptions singleAxisOptions) {
            this.singleAxisOptions = singleAxisOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getColorLabelOptions() {
            return this.colorLabelOptions != null ? this.colorLabelOptions.toBuilder() : null;
        }

        public final void setColorLabelOptions(ChartAxisLabelOptions.BuilderImpl colorLabelOptions) {
            this.colorLabelOptions = colorLabelOptions != null ? colorLabelOptions.build() : null;
        }

        @Override
        public final Builder colorLabelOptions(ChartAxisLabelOptions colorLabelOptions) {
            this.colorLabelOptions = colorLabelOptions;
            return this;
        }

        public final ComboChartDefaultSeriesSettings.Builder getDefaultSeriesSettings() {
            return this.defaultSeriesSettings != null ? this.defaultSeriesSettings.toBuilder() : null;
        }

        public final void setDefaultSeriesSettings(ComboChartDefaultSeriesSettings.BuilderImpl defaultSeriesSettings) {
            this.defaultSeriesSettings = defaultSeriesSettings != null ? defaultSeriesSettings.build() : null;
        }

        @Override
        public final Builder defaultSeriesSettings(ComboChartDefaultSeriesSettings defaultSeriesSettings) {
            this.defaultSeriesSettings = defaultSeriesSettings;
            return this;
        }

        public final List<ComboSeriesItem.Builder> getSeries() {
            List<ComboSeriesItem.Builder> result = ComboSeriesItemListCopier.copyToBuilder(this.series);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSeries(Collection<ComboSeriesItem.BuilderImpl> series) {
            this.series = ComboSeriesItemListCopier.copyFromBuilder(series);
        }

        @Override
        public final Builder series(Collection<ComboSeriesItem> series) {
            this.series = ComboSeriesItemListCopier.copy(series);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder series(ComboSeriesItem ... series) {
            this.series(Arrays.asList(series));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder series(Consumer<ComboSeriesItem.Builder> ... series) {
            this.series(Stream.of(series).map(c -> (ComboSeriesItem)((ComboSeriesItem.Builder)ComboSeriesItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return this.legend != null ? this.legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final DataLabelOptions.Builder getBarDataLabels() {
            return this.barDataLabels != null ? this.barDataLabels.toBuilder() : null;
        }

        public final void setBarDataLabels(DataLabelOptions.BuilderImpl barDataLabels) {
            this.barDataLabels = barDataLabels != null ? barDataLabels.build() : null;
        }

        @Override
        public final Builder barDataLabels(DataLabelOptions barDataLabels) {
            this.barDataLabels = barDataLabels;
            return this;
        }

        public final DataLabelOptions.Builder getLineDataLabels() {
            return this.lineDataLabels != null ? this.lineDataLabels.toBuilder() : null;
        }

        public final void setLineDataLabels(DataLabelOptions.BuilderImpl lineDataLabels) {
            this.lineDataLabels = lineDataLabels != null ? lineDataLabels.build() : null;
        }

        @Override
        public final Builder lineDataLabels(DataLabelOptions lineDataLabels) {
            this.lineDataLabels = lineDataLabels;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return this.tooltip != null ? this.tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final List<ReferenceLine.Builder> getReferenceLines() {
            List<ReferenceLine.Builder> result = ReferenceLineListCopier.copyToBuilder(this.referenceLines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceLines(Collection<ReferenceLine.BuilderImpl> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copyFromBuilder(referenceLines);
        }

        @Override
        public final Builder referenceLines(Collection<ReferenceLine> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copy(referenceLines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(ReferenceLine ... referenceLines) {
            this.referenceLines(Arrays.asList(referenceLines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(Consumer<ReferenceLine.Builder> ... referenceLines) {
            this.referenceLines(Stream.of(referenceLines).map(c -> (ReferenceLine)((ReferenceLine.Builder)ReferenceLine.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return this.visualPalette != null ? this.visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return this.interactions != null ? this.interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        public ComboChartConfiguration build() {
            return new ComboChartConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComboChartConfiguration> {
        public Builder fieldWells(ComboChartFieldWells var1);

        default public Builder fieldWells(Consumer<ComboChartFieldWells.Builder> fieldWells) {
            return this.fieldWells((ComboChartFieldWells)((ComboChartFieldWells.Builder)ComboChartFieldWells.builder().applyMutation(fieldWells)).build());
        }

        public Builder sortConfiguration(ComboChartSortConfiguration var1);

        default public Builder sortConfiguration(Consumer<ComboChartSortConfiguration.Builder> sortConfiguration) {
            return this.sortConfiguration((ComboChartSortConfiguration)((ComboChartSortConfiguration.Builder)ComboChartSortConfiguration.builder().applyMutation(sortConfiguration)).build());
        }

        public Builder barsArrangement(String var1);

        public Builder barsArrangement(BarsArrangement var1);

        public Builder categoryAxis(AxisDisplayOptions var1);

        default public Builder categoryAxis(Consumer<AxisDisplayOptions.Builder> categoryAxis) {
            return this.categoryAxis((AxisDisplayOptions)((AxisDisplayOptions.Builder)AxisDisplayOptions.builder().applyMutation(categoryAxis)).build());
        }

        public Builder categoryLabelOptions(ChartAxisLabelOptions var1);

        default public Builder categoryLabelOptions(Consumer<ChartAxisLabelOptions.Builder> categoryLabelOptions) {
            return this.categoryLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(categoryLabelOptions)).build());
        }

        public Builder primaryYAxisDisplayOptions(AxisDisplayOptions var1);

        default public Builder primaryYAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> primaryYAxisDisplayOptions) {
            return this.primaryYAxisDisplayOptions((AxisDisplayOptions)((AxisDisplayOptions.Builder)AxisDisplayOptions.builder().applyMutation(primaryYAxisDisplayOptions)).build());
        }

        public Builder primaryYAxisLabelOptions(ChartAxisLabelOptions var1);

        default public Builder primaryYAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> primaryYAxisLabelOptions) {
            return this.primaryYAxisLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(primaryYAxisLabelOptions)).build());
        }

        public Builder secondaryYAxisDisplayOptions(AxisDisplayOptions var1);

        default public Builder secondaryYAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> secondaryYAxisDisplayOptions) {
            return this.secondaryYAxisDisplayOptions((AxisDisplayOptions)((AxisDisplayOptions.Builder)AxisDisplayOptions.builder().applyMutation(secondaryYAxisDisplayOptions)).build());
        }

        public Builder secondaryYAxisLabelOptions(ChartAxisLabelOptions var1);

        default public Builder secondaryYAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> secondaryYAxisLabelOptions) {
            return this.secondaryYAxisLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(secondaryYAxisLabelOptions)).build());
        }

        public Builder singleAxisOptions(SingleAxisOptions var1);

        default public Builder singleAxisOptions(Consumer<SingleAxisOptions.Builder> singleAxisOptions) {
            return this.singleAxisOptions((SingleAxisOptions)((SingleAxisOptions.Builder)SingleAxisOptions.builder().applyMutation(singleAxisOptions)).build());
        }

        public Builder colorLabelOptions(ChartAxisLabelOptions var1);

        default public Builder colorLabelOptions(Consumer<ChartAxisLabelOptions.Builder> colorLabelOptions) {
            return this.colorLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(colorLabelOptions)).build());
        }

        public Builder defaultSeriesSettings(ComboChartDefaultSeriesSettings var1);

        default public Builder defaultSeriesSettings(Consumer<ComboChartDefaultSeriesSettings.Builder> defaultSeriesSettings) {
            return this.defaultSeriesSettings((ComboChartDefaultSeriesSettings)((ComboChartDefaultSeriesSettings.Builder)ComboChartDefaultSeriesSettings.builder().applyMutation(defaultSeriesSettings)).build());
        }

        public Builder series(Collection<ComboSeriesItem> var1);

        public Builder series(ComboSeriesItem ... var1);

        public Builder series(Consumer<ComboSeriesItem.Builder> ... var1);

        public Builder legend(LegendOptions var1);

        default public Builder legend(Consumer<LegendOptions.Builder> legend) {
            return this.legend((LegendOptions)((LegendOptions.Builder)LegendOptions.builder().applyMutation(legend)).build());
        }

        public Builder barDataLabels(DataLabelOptions var1);

        default public Builder barDataLabels(Consumer<DataLabelOptions.Builder> barDataLabels) {
            return this.barDataLabels((DataLabelOptions)((DataLabelOptions.Builder)DataLabelOptions.builder().applyMutation(barDataLabels)).build());
        }

        public Builder lineDataLabels(DataLabelOptions var1);

        default public Builder lineDataLabels(Consumer<DataLabelOptions.Builder> lineDataLabels) {
            return this.lineDataLabels((DataLabelOptions)((DataLabelOptions.Builder)DataLabelOptions.builder().applyMutation(lineDataLabels)).build());
        }

        public Builder tooltip(TooltipOptions var1);

        default public Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return this.tooltip((TooltipOptions)((TooltipOptions.Builder)TooltipOptions.builder().applyMutation(tooltip)).build());
        }

        public Builder referenceLines(Collection<ReferenceLine> var1);

        public Builder referenceLines(ReferenceLine ... var1);

        public Builder referenceLines(Consumer<ReferenceLine.Builder> ... var1);

        public Builder visualPalette(VisualPalette var1);

        default public Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return this.visualPalette((VisualPalette)((VisualPalette.Builder)VisualPalette.builder().applyMutation(visualPalette)).build());
        }

        public Builder interactions(VisualInteractionOptions var1);

        default public Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return this.interactions((VisualInteractionOptions)((VisualInteractionOptions.Builder)VisualInteractionOptions.builder().applyMutation(interactions)).build());
        }
    }
}

