/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class APIKeyConnectionMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, APIKeyConnectionMetadata> {
    private static final SdkField<String> BASE_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseEndpoint").getter(APIKeyConnectionMetadata.getter(APIKeyConnectionMetadata::baseEndpoint)).setter(APIKeyConnectionMetadata.setter(Builder::baseEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpoint").build()}).build();
    private static final SdkField<String> API_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiKey").getter(APIKeyConnectionMetadata.getter(APIKeyConnectionMetadata::apiKey)).setter(APIKeyConnectionMetadata.setter(Builder::apiKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKey").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Email").getter(APIKeyConnectionMetadata.getter(APIKeyConnectionMetadata::email)).setter(APIKeyConnectionMetadata.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_ENDPOINT_FIELD, API_KEY_FIELD, EMAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = APIKeyConnectionMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String baseEndpoint;
    private final String apiKey;
    private final String email;

    private APIKeyConnectionMetadata(BuilderImpl builder) {
        this.baseEndpoint = builder.baseEndpoint;
        this.apiKey = builder.apiKey;
        this.email = builder.email;
    }

    public final String baseEndpoint() {
        return this.baseEndpoint;
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public final String email() {
        return this.email;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APIKeyConnectionMetadata)) {
            return false;
        }
        APIKeyConnectionMetadata other = (APIKeyConnectionMetadata)obj;
        return Objects.equals(this.baseEndpoint(), other.baseEndpoint()) && Objects.equals(this.apiKey(), other.apiKey()) && Objects.equals(this.email(), other.email());
    }

    public final String toString() {
        return ToString.builder((String)"APIKeyConnectionMetadata").add("BaseEndpoint", (Object)this.baseEndpoint()).add("ApiKey", (Object)(this.apiKey() == null ? null : "*** Sensitive Data Redacted ***")).add("Email", (Object)(this.email() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseEndpoint": {
                return Optional.ofNullable(clazz.cast(this.baseEndpoint()));
            }
            case "ApiKey": {
                return Optional.ofNullable(clazz.cast(this.apiKey()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BaseEndpoint", BASE_ENDPOINT_FIELD);
        map.put("ApiKey", API_KEY_FIELD);
        map.put("Email", EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<APIKeyConnectionMetadata, T> g) {
        return obj -> g.apply((APIKeyConnectionMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String baseEndpoint;
        private String apiKey;
        private String email;

        private BuilderImpl() {
        }

        private BuilderImpl(APIKeyConnectionMetadata model) {
            this.baseEndpoint(model.baseEndpoint);
            this.apiKey(model.apiKey);
            this.email(model.email);
        }

        public final String getBaseEndpoint() {
            return this.baseEndpoint;
        }

        public final void setBaseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
        }

        @Override
        public final Builder baseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
            return this;
        }

        public final String getApiKey() {
            return this.apiKey;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public APIKeyConnectionMetadata build() {
            return new APIKeyConnectionMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, APIKeyConnectionMetadata> {
        public Builder baseEndpoint(String var1);

        public Builder apiKey(String var1);

        public Builder email(String var1);
    }
}

