/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.FlowPublishState;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFlowMetadataResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, GetFlowMetadataResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetFlowMetadataResponse.getter(GetFlowMetadataResponse::arn)).setter(GetFlowMetadataResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowId").getter(GetFlowMetadataResponse.getter(GetFlowMetadataResponse::flowId)).setter(GetFlowMetadataResponse.setter(Builder::flowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetFlowMetadataResponse.getter(GetFlowMetadataResponse::name)).setter(GetFlowMetadataResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetFlowMetadataResponse.getter(GetFlowMetadataResponse::description)).setter(GetFlowMetadataResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PUBLISH_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublishState").getter(GetFlowMetadataResponse.getter(GetFlowMetadataResponse::publishStateAsString)).setter(GetFlowMetadataResponse.setter(Builder::publishState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishState").build()}).build();
    private static final SdkField<Integer> USER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UserCount").getter(GetFlowMetadataResponse.getter(GetFlowMetadataResponse::userCount)).setter(GetFlowMetadataResponse.setter(Builder::userCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCount").build()}).build();
    private static final SdkField<Integer> RUN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RunCount").getter(GetFlowMetadataResponse.getter(GetFlowMetadataResponse::runCount)).setter(GetFlowMetadataResponse.setter(Builder::runCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunCount").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(GetFlowMetadataResponse.getter(GetFlowMetadataResponse::createdTime)).setter(GetFlowMetadataResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(GetFlowMetadataResponse.getter(GetFlowMetadataResponse::lastUpdatedTime)).setter(GetFlowMetadataResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(GetFlowMetadataResponse.getter(GetFlowMetadataResponse::requestId)).setter(GetFlowMetadataResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(GetFlowMetadataResponse.getter(GetFlowMetadataResponse::status)).setter(GetFlowMetadataResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, FLOW_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, PUBLISH_STATE_FIELD, USER_COUNT_FIELD, RUN_COUNT_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFlowMetadataResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String flowId;
    private final String name;
    private final String description;
    private final String publishState;
    private final Integer userCount;
    private final Integer runCount;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final String requestId;
    private final Integer status;

    private GetFlowMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.flowId = builder.flowId;
        this.name = builder.name;
        this.description = builder.description;
        this.publishState = builder.publishState;
        this.userCount = builder.userCount;
        this.runCount = builder.runCount;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String flowId() {
        return this.flowId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final FlowPublishState publishState() {
        return FlowPublishState.fromValue(this.publishState);
    }

    public final String publishStateAsString() {
        return this.publishState;
    }

    public final Integer userCount() {
        return this.userCount;
    }

    public final Integer runCount() {
        return this.runCount;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.runCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFlowMetadataResponse)) {
            return false;
        }
        GetFlowMetadataResponse other = (GetFlowMetadataResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.flowId(), other.flowId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.publishStateAsString(), other.publishStateAsString()) && Objects.equals(this.userCount(), other.userCount()) && Objects.equals(this.runCount(), other.runCount()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"GetFlowMetadataResponse").add("Arn", (Object)this.arn()).add("FlowId", (Object)this.flowId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("PublishState", (Object)this.publishStateAsString()).add("UserCount", (Object)this.userCount()).add("RunCount", (Object)this.runCount()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "FlowId": {
                return Optional.ofNullable(clazz.cast(this.flowId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PublishState": {
                return Optional.ofNullable(clazz.cast(this.publishStateAsString()));
            }
            case "UserCount": {
                return Optional.ofNullable(clazz.cast(this.userCount()));
            }
            case "RunCount": {
                return Optional.ofNullable(clazz.cast(this.runCount()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("FlowId", FLOW_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("PublishState", PUBLISH_STATE_FIELD);
        map.put("UserCount", USER_COUNT_FIELD);
        map.put("RunCount", RUN_COUNT_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFlowMetadataResponse, T> g) {
        return obj -> g.apply((GetFlowMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String flowId;
        private String name;
        private String description;
        private String publishState;
        private Integer userCount;
        private Integer runCount;
        private Instant createdTime;
        private Instant lastUpdatedTime;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFlowMetadataResponse model) {
            super(model);
            this.arn(model.arn);
            this.flowId(model.flowId);
            this.name(model.name);
            this.description(model.description);
            this.publishState(model.publishState);
            this.userCount(model.userCount);
            this.runCount(model.runCount);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getFlowId() {
            return this.flowId;
        }

        public final void setFlowId(String flowId) {
            this.flowId = flowId;
        }

        @Override
        public final Builder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPublishState() {
            return this.publishState;
        }

        public final void setPublishState(String publishState) {
            this.publishState = publishState;
        }

        @Override
        public final Builder publishState(String publishState) {
            this.publishState = publishState;
            return this;
        }

        @Override
        public final Builder publishState(FlowPublishState publishState) {
            this.publishState(publishState == null ? null : publishState.toString());
            return this;
        }

        public final Integer getUserCount() {
            return this.userCount;
        }

        public final void setUserCount(Integer userCount) {
            this.userCount = userCount;
        }

        @Override
        public final Builder userCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public final Integer getRunCount() {
            return this.runCount;
        }

        public final void setRunCount(Integer runCount) {
            this.runCount = runCount;
        }

        @Override
        public final Builder runCount(Integer runCount) {
            this.runCount = runCount;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public GetFlowMetadataResponse build() {
            return new GetFlowMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFlowMetadataResponse> {
        public Builder arn(String var1);

        public Builder flowId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder publishState(String var1);

        public Builder publishState(FlowPublishState var1);

        public Builder userCount(Integer var1);

        public Builder runCount(Integer var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

