/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClientCredentialsSource {
    PLAIN_CREDENTIALS("PLAIN_CREDENTIALS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClientCredentialsSource> VALUE_MAP;
    private final String value;

    private ClientCredentialsSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClientCredentialsSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClientCredentialsSource> knownValues() {
        EnumSet<ClientCredentialsSource> knownValues = EnumSet.allOf(ClientCredentialsSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClientCredentialsSource.class, ClientCredentialsSource::toString);
    }
}

