/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizationCodeGrantDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthorizationCodeGrantDetails> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(AuthorizationCodeGrantDetails.getter(AuthorizationCodeGrantDetails::clientId)).setter(AuthorizationCodeGrantDetails.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientSecret").getter(AuthorizationCodeGrantDetails.getter(AuthorizationCodeGrantDetails::clientSecret)).setter(AuthorizationCodeGrantDetails.setter(Builder::clientSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSecret").build()}).build();
    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TokenEndpoint").getter(AuthorizationCodeGrantDetails.getter(AuthorizationCodeGrantDetails::tokenEndpoint)).setter(AuthorizationCodeGrantDetails.setter(Builder::tokenEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenEndpoint").build()}).build();
    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizationEndpoint").getter(AuthorizationCodeGrantDetails.getter(AuthorizationCodeGrantDetails::authorizationEndpoint)).setter(AuthorizationCodeGrantDetails.setter(Builder::authorizationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, CLIENT_SECRET_FIELD, TOKEN_ENDPOINT_FIELD, AUTHORIZATION_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthorizationCodeGrantDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clientId;
    private final String clientSecret;
    private final String tokenEndpoint;
    private final String authorizationEndpoint;

    private AuthorizationCodeGrantDetails(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.authorizationEndpoint = builder.authorizationEndpoint;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String clientSecret() {
        return this.clientSecret;
    }

    public final String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public final String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizationCodeGrantDetails)) {
            return false;
        }
        AuthorizationCodeGrantDetails other = (AuthorizationCodeGrantDetails)obj;
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.clientSecret(), other.clientSecret()) && Objects.equals(this.tokenEndpoint(), other.tokenEndpoint()) && Objects.equals(this.authorizationEndpoint(), other.authorizationEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizationCodeGrantDetails").add("ClientId", (Object)this.clientId()).add("ClientSecret", (Object)(this.clientSecret() == null ? null : "*** Sensitive Data Redacted ***")).add("TokenEndpoint", (Object)this.tokenEndpoint()).add("AuthorizationEndpoint", (Object)this.authorizationEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "ClientSecret": {
                return Optional.ofNullable(clazz.cast(this.clientSecret()));
            }
            case "TokenEndpoint": {
                return Optional.ofNullable(clazz.cast(this.tokenEndpoint()));
            }
            case "AuthorizationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.authorizationEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("ClientSecret", CLIENT_SECRET_FIELD);
        map.put("TokenEndpoint", TOKEN_ENDPOINT_FIELD);
        map.put("AuthorizationEndpoint", AUTHORIZATION_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizationCodeGrantDetails, T> g) {
        return obj -> g.apply((AuthorizationCodeGrantDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientId;
        private String clientSecret;
        private String tokenEndpoint;
        private String authorizationEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizationCodeGrantDetails model) {
            this.clientId(model.clientId);
            this.clientSecret(model.clientSecret);
            this.tokenEndpoint(model.tokenEndpoint);
            this.authorizationEndpoint(model.authorizationEndpoint);
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return this.clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public AuthorizationCodeGrantDetails build() {
            return new AuthorizationCodeGrantDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthorizationCodeGrantDetails> {
        public Builder clientId(String var1);

        public Builder clientSecret(String var1);

        public Builder tokenEndpoint(String var1);

        public Builder authorizationEndpoint(String var1);
    }
}

