/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.PivotTableMetricPlacement;
import software.amazon.awssdk.services.quicksight.model.PivotTableRowsLabelOptions;
import software.amazon.awssdk.services.quicksight.model.PivotTableRowsLayout;
import software.amazon.awssdk.services.quicksight.model.RowAlternateColorOptions;
import software.amazon.awssdk.services.quicksight.model.TableCellStyle;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PivotTableOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PivotTableOptions> {
    private static final SdkField<String> METRIC_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricPlacement").getter(PivotTableOptions.getter(PivotTableOptions::metricPlacementAsString)).setter(PivotTableOptions.setter(Builder::metricPlacement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricPlacement").build()}).build();
    private static final SdkField<String> SINGLE_METRIC_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SingleMetricVisibility").getter(PivotTableOptions.getter(PivotTableOptions::singleMetricVisibilityAsString)).setter(PivotTableOptions.setter(Builder::singleMetricVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleMetricVisibility").build()}).build();
    private static final SdkField<String> COLUMN_NAMES_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnNamesVisibility").getter(PivotTableOptions.getter(PivotTableOptions::columnNamesVisibilityAsString)).setter(PivotTableOptions.setter(Builder::columnNamesVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnNamesVisibility").build()}).build();
    private static final SdkField<String> TOGGLE_BUTTONS_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ToggleButtonsVisibility").getter(PivotTableOptions.getter(PivotTableOptions::toggleButtonsVisibilityAsString)).setter(PivotTableOptions.setter(Builder::toggleButtonsVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToggleButtonsVisibility").build()}).build();
    private static final SdkField<TableCellStyle> COLUMN_HEADER_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColumnHeaderStyle").getter(PivotTableOptions.getter(PivotTableOptions::columnHeaderStyle)).setter(PivotTableOptions.setter(Builder::columnHeaderStyle)).constructor(TableCellStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnHeaderStyle").build()}).build();
    private static final SdkField<TableCellStyle> ROW_HEADER_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RowHeaderStyle").getter(PivotTableOptions.getter(PivotTableOptions::rowHeaderStyle)).setter(PivotTableOptions.setter(Builder::rowHeaderStyle)).constructor(TableCellStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowHeaderStyle").build()}).build();
    private static final SdkField<TableCellStyle> CELL_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CellStyle").getter(PivotTableOptions.getter(PivotTableOptions::cellStyle)).setter(PivotTableOptions.setter(Builder::cellStyle)).constructor(TableCellStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellStyle").build()}).build();
    private static final SdkField<TableCellStyle> ROW_FIELD_NAMES_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RowFieldNamesStyle").getter(PivotTableOptions.getter(PivotTableOptions::rowFieldNamesStyle)).setter(PivotTableOptions.setter(Builder::rowFieldNamesStyle)).constructor(TableCellStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowFieldNamesStyle").build()}).build();
    private static final SdkField<RowAlternateColorOptions> ROW_ALTERNATE_COLOR_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RowAlternateColorOptions").getter(PivotTableOptions.getter(PivotTableOptions::rowAlternateColorOptions)).setter(PivotTableOptions.setter(Builder::rowAlternateColorOptions)).constructor(RowAlternateColorOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowAlternateColorOptions").build()}).build();
    private static final SdkField<String> COLLAPSED_ROW_DIMENSIONS_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollapsedRowDimensionsVisibility").getter(PivotTableOptions.getter(PivotTableOptions::collapsedRowDimensionsVisibilityAsString)).setter(PivotTableOptions.setter(Builder::collapsedRowDimensionsVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollapsedRowDimensionsVisibility").build()}).build();
    private static final SdkField<String> ROWS_LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RowsLayout").getter(PivotTableOptions.getter(PivotTableOptions::rowsLayoutAsString)).setter(PivotTableOptions.setter(Builder::rowsLayout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowsLayout").build()}).build();
    private static final SdkField<PivotTableRowsLabelOptions> ROWS_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RowsLabelOptions").getter(PivotTableOptions.getter(PivotTableOptions::rowsLabelOptions)).setter(PivotTableOptions.setter(Builder::rowsLabelOptions)).constructor(PivotTableRowsLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowsLabelOptions").build()}).build();
    private static final SdkField<String> DEFAULT_CELL_WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultCellWidth").getter(PivotTableOptions.getter(PivotTableOptions::defaultCellWidth)).setter(PivotTableOptions.setter(Builder::defaultCellWidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCellWidth").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_PLACEMENT_FIELD, SINGLE_METRIC_VISIBILITY_FIELD, COLUMN_NAMES_VISIBILITY_FIELD, TOGGLE_BUTTONS_VISIBILITY_FIELD, COLUMN_HEADER_STYLE_FIELD, ROW_HEADER_STYLE_FIELD, CELL_STYLE_FIELD, ROW_FIELD_NAMES_STYLE_FIELD, ROW_ALTERNATE_COLOR_OPTIONS_FIELD, COLLAPSED_ROW_DIMENSIONS_VISIBILITY_FIELD, ROWS_LAYOUT_FIELD, ROWS_LABEL_OPTIONS_FIELD, DEFAULT_CELL_WIDTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PivotTableOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metricPlacement;
    private final String singleMetricVisibility;
    private final String columnNamesVisibility;
    private final String toggleButtonsVisibility;
    private final TableCellStyle columnHeaderStyle;
    private final TableCellStyle rowHeaderStyle;
    private final TableCellStyle cellStyle;
    private final TableCellStyle rowFieldNamesStyle;
    private final RowAlternateColorOptions rowAlternateColorOptions;
    private final String collapsedRowDimensionsVisibility;
    private final String rowsLayout;
    private final PivotTableRowsLabelOptions rowsLabelOptions;
    private final String defaultCellWidth;

    private PivotTableOptions(BuilderImpl builder) {
        this.metricPlacement = builder.metricPlacement;
        this.singleMetricVisibility = builder.singleMetricVisibility;
        this.columnNamesVisibility = builder.columnNamesVisibility;
        this.toggleButtonsVisibility = builder.toggleButtonsVisibility;
        this.columnHeaderStyle = builder.columnHeaderStyle;
        this.rowHeaderStyle = builder.rowHeaderStyle;
        this.cellStyle = builder.cellStyle;
        this.rowFieldNamesStyle = builder.rowFieldNamesStyle;
        this.rowAlternateColorOptions = builder.rowAlternateColorOptions;
        this.collapsedRowDimensionsVisibility = builder.collapsedRowDimensionsVisibility;
        this.rowsLayout = builder.rowsLayout;
        this.rowsLabelOptions = builder.rowsLabelOptions;
        this.defaultCellWidth = builder.defaultCellWidth;
    }

    public final PivotTableMetricPlacement metricPlacement() {
        return PivotTableMetricPlacement.fromValue(this.metricPlacement);
    }

    public final String metricPlacementAsString() {
        return this.metricPlacement;
    }

    public final Visibility singleMetricVisibility() {
        return Visibility.fromValue(this.singleMetricVisibility);
    }

    public final String singleMetricVisibilityAsString() {
        return this.singleMetricVisibility;
    }

    public final Visibility columnNamesVisibility() {
        return Visibility.fromValue(this.columnNamesVisibility);
    }

    public final String columnNamesVisibilityAsString() {
        return this.columnNamesVisibility;
    }

    public final Visibility toggleButtonsVisibility() {
        return Visibility.fromValue(this.toggleButtonsVisibility);
    }

    public final String toggleButtonsVisibilityAsString() {
        return this.toggleButtonsVisibility;
    }

    public final TableCellStyle columnHeaderStyle() {
        return this.columnHeaderStyle;
    }

    public final TableCellStyle rowHeaderStyle() {
        return this.rowHeaderStyle;
    }

    public final TableCellStyle cellStyle() {
        return this.cellStyle;
    }

    public final TableCellStyle rowFieldNamesStyle() {
        return this.rowFieldNamesStyle;
    }

    public final RowAlternateColorOptions rowAlternateColorOptions() {
        return this.rowAlternateColorOptions;
    }

    public final Visibility collapsedRowDimensionsVisibility() {
        return Visibility.fromValue(this.collapsedRowDimensionsVisibility);
    }

    public final String collapsedRowDimensionsVisibilityAsString() {
        return this.collapsedRowDimensionsVisibility;
    }

    public final PivotTableRowsLayout rowsLayout() {
        return PivotTableRowsLayout.fromValue(this.rowsLayout);
    }

    public final String rowsLayoutAsString() {
        return this.rowsLayout;
    }

    public final PivotTableRowsLabelOptions rowsLabelOptions() {
        return this.rowsLabelOptions;
    }

    public final String defaultCellWidth() {
        return this.defaultCellWidth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleMetricVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnNamesVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.toggleButtonsVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnHeaderStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowHeaderStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.cellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowFieldNamesStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowAlternateColorOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.collapsedRowDimensionsVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowsLayoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowsLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCellWidth());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableOptions)) {
            return false;
        }
        PivotTableOptions other = (PivotTableOptions)obj;
        return Objects.equals(this.metricPlacementAsString(), other.metricPlacementAsString()) && Objects.equals(this.singleMetricVisibilityAsString(), other.singleMetricVisibilityAsString()) && Objects.equals(this.columnNamesVisibilityAsString(), other.columnNamesVisibilityAsString()) && Objects.equals(this.toggleButtonsVisibilityAsString(), other.toggleButtonsVisibilityAsString()) && Objects.equals(this.columnHeaderStyle(), other.columnHeaderStyle()) && Objects.equals(this.rowHeaderStyle(), other.rowHeaderStyle()) && Objects.equals(this.cellStyle(), other.cellStyle()) && Objects.equals(this.rowFieldNamesStyle(), other.rowFieldNamesStyle()) && Objects.equals(this.rowAlternateColorOptions(), other.rowAlternateColorOptions()) && Objects.equals(this.collapsedRowDimensionsVisibilityAsString(), other.collapsedRowDimensionsVisibilityAsString()) && Objects.equals(this.rowsLayoutAsString(), other.rowsLayoutAsString()) && Objects.equals(this.rowsLabelOptions(), other.rowsLabelOptions()) && Objects.equals(this.defaultCellWidth(), other.defaultCellWidth());
    }

    public final String toString() {
        return ToString.builder((String)"PivotTableOptions").add("MetricPlacement", (Object)this.metricPlacementAsString()).add("SingleMetricVisibility", (Object)this.singleMetricVisibilityAsString()).add("ColumnNamesVisibility", (Object)this.columnNamesVisibilityAsString()).add("ToggleButtonsVisibility", (Object)this.toggleButtonsVisibilityAsString()).add("ColumnHeaderStyle", (Object)this.columnHeaderStyle()).add("RowHeaderStyle", (Object)this.rowHeaderStyle()).add("CellStyle", (Object)this.cellStyle()).add("RowFieldNamesStyle", (Object)this.rowFieldNamesStyle()).add("RowAlternateColorOptions", (Object)this.rowAlternateColorOptions()).add("CollapsedRowDimensionsVisibility", (Object)this.collapsedRowDimensionsVisibilityAsString()).add("RowsLayout", (Object)this.rowsLayoutAsString()).add("RowsLabelOptions", (Object)this.rowsLabelOptions()).add("DefaultCellWidth", (Object)this.defaultCellWidth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricPlacement": {
                return Optional.ofNullable(clazz.cast(this.metricPlacementAsString()));
            }
            case "SingleMetricVisibility": {
                return Optional.ofNullable(clazz.cast(this.singleMetricVisibilityAsString()));
            }
            case "ColumnNamesVisibility": {
                return Optional.ofNullable(clazz.cast(this.columnNamesVisibilityAsString()));
            }
            case "ToggleButtonsVisibility": {
                return Optional.ofNullable(clazz.cast(this.toggleButtonsVisibilityAsString()));
            }
            case "ColumnHeaderStyle": {
                return Optional.ofNullable(clazz.cast(this.columnHeaderStyle()));
            }
            case "RowHeaderStyle": {
                return Optional.ofNullable(clazz.cast(this.rowHeaderStyle()));
            }
            case "CellStyle": {
                return Optional.ofNullable(clazz.cast(this.cellStyle()));
            }
            case "RowFieldNamesStyle": {
                return Optional.ofNullable(clazz.cast(this.rowFieldNamesStyle()));
            }
            case "RowAlternateColorOptions": {
                return Optional.ofNullable(clazz.cast(this.rowAlternateColorOptions()));
            }
            case "CollapsedRowDimensionsVisibility": {
                return Optional.ofNullable(clazz.cast(this.collapsedRowDimensionsVisibilityAsString()));
            }
            case "RowsLayout": {
                return Optional.ofNullable(clazz.cast(this.rowsLayoutAsString()));
            }
            case "RowsLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.rowsLabelOptions()));
            }
            case "DefaultCellWidth": {
                return Optional.ofNullable(clazz.cast(this.defaultCellWidth()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricPlacement", METRIC_PLACEMENT_FIELD);
        map.put("SingleMetricVisibility", SINGLE_METRIC_VISIBILITY_FIELD);
        map.put("ColumnNamesVisibility", COLUMN_NAMES_VISIBILITY_FIELD);
        map.put("ToggleButtonsVisibility", TOGGLE_BUTTONS_VISIBILITY_FIELD);
        map.put("ColumnHeaderStyle", COLUMN_HEADER_STYLE_FIELD);
        map.put("RowHeaderStyle", ROW_HEADER_STYLE_FIELD);
        map.put("CellStyle", CELL_STYLE_FIELD);
        map.put("RowFieldNamesStyle", ROW_FIELD_NAMES_STYLE_FIELD);
        map.put("RowAlternateColorOptions", ROW_ALTERNATE_COLOR_OPTIONS_FIELD);
        map.put("CollapsedRowDimensionsVisibility", COLLAPSED_ROW_DIMENSIONS_VISIBILITY_FIELD);
        map.put("RowsLayout", ROWS_LAYOUT_FIELD);
        map.put("RowsLabelOptions", ROWS_LABEL_OPTIONS_FIELD);
        map.put("DefaultCellWidth", DEFAULT_CELL_WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotTableOptions, T> g) {
        return obj -> g.apply((PivotTableOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricPlacement;
        private String singleMetricVisibility;
        private String columnNamesVisibility;
        private String toggleButtonsVisibility;
        private TableCellStyle columnHeaderStyle;
        private TableCellStyle rowHeaderStyle;
        private TableCellStyle cellStyle;
        private TableCellStyle rowFieldNamesStyle;
        private RowAlternateColorOptions rowAlternateColorOptions;
        private String collapsedRowDimensionsVisibility;
        private String rowsLayout;
        private PivotTableRowsLabelOptions rowsLabelOptions;
        private String defaultCellWidth;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableOptions model) {
            this.metricPlacement(model.metricPlacement);
            this.singleMetricVisibility(model.singleMetricVisibility);
            this.columnNamesVisibility(model.columnNamesVisibility);
            this.toggleButtonsVisibility(model.toggleButtonsVisibility);
            this.columnHeaderStyle(model.columnHeaderStyle);
            this.rowHeaderStyle(model.rowHeaderStyle);
            this.cellStyle(model.cellStyle);
            this.rowFieldNamesStyle(model.rowFieldNamesStyle);
            this.rowAlternateColorOptions(model.rowAlternateColorOptions);
            this.collapsedRowDimensionsVisibility(model.collapsedRowDimensionsVisibility);
            this.rowsLayout(model.rowsLayout);
            this.rowsLabelOptions(model.rowsLabelOptions);
            this.defaultCellWidth(model.defaultCellWidth);
        }

        public final String getMetricPlacement() {
            return this.metricPlacement;
        }

        public final void setMetricPlacement(String metricPlacement) {
            this.metricPlacement = metricPlacement;
        }

        @Override
        public final Builder metricPlacement(String metricPlacement) {
            this.metricPlacement = metricPlacement;
            return this;
        }

        @Override
        public final Builder metricPlacement(PivotTableMetricPlacement metricPlacement) {
            this.metricPlacement(metricPlacement == null ? null : metricPlacement.toString());
            return this;
        }

        public final String getSingleMetricVisibility() {
            return this.singleMetricVisibility;
        }

        public final void setSingleMetricVisibility(String singleMetricVisibility) {
            this.singleMetricVisibility = singleMetricVisibility;
        }

        @Override
        public final Builder singleMetricVisibility(String singleMetricVisibility) {
            this.singleMetricVisibility = singleMetricVisibility;
            return this;
        }

        @Override
        public final Builder singleMetricVisibility(Visibility singleMetricVisibility) {
            this.singleMetricVisibility(singleMetricVisibility == null ? null : singleMetricVisibility.toString());
            return this;
        }

        public final String getColumnNamesVisibility() {
            return this.columnNamesVisibility;
        }

        public final void setColumnNamesVisibility(String columnNamesVisibility) {
            this.columnNamesVisibility = columnNamesVisibility;
        }

        @Override
        public final Builder columnNamesVisibility(String columnNamesVisibility) {
            this.columnNamesVisibility = columnNamesVisibility;
            return this;
        }

        @Override
        public final Builder columnNamesVisibility(Visibility columnNamesVisibility) {
            this.columnNamesVisibility(columnNamesVisibility == null ? null : columnNamesVisibility.toString());
            return this;
        }

        public final String getToggleButtonsVisibility() {
            return this.toggleButtonsVisibility;
        }

        public final void setToggleButtonsVisibility(String toggleButtonsVisibility) {
            this.toggleButtonsVisibility = toggleButtonsVisibility;
        }

        @Override
        public final Builder toggleButtonsVisibility(String toggleButtonsVisibility) {
            this.toggleButtonsVisibility = toggleButtonsVisibility;
            return this;
        }

        @Override
        public final Builder toggleButtonsVisibility(Visibility toggleButtonsVisibility) {
            this.toggleButtonsVisibility(toggleButtonsVisibility == null ? null : toggleButtonsVisibility.toString());
            return this;
        }

        public final TableCellStyle.Builder getColumnHeaderStyle() {
            return this.columnHeaderStyle != null ? this.columnHeaderStyle.toBuilder() : null;
        }

        public final void setColumnHeaderStyle(TableCellStyle.BuilderImpl columnHeaderStyle) {
            this.columnHeaderStyle = columnHeaderStyle != null ? columnHeaderStyle.build() : null;
        }

        @Override
        public final Builder columnHeaderStyle(TableCellStyle columnHeaderStyle) {
            this.columnHeaderStyle = columnHeaderStyle;
            return this;
        }

        public final TableCellStyle.Builder getRowHeaderStyle() {
            return this.rowHeaderStyle != null ? this.rowHeaderStyle.toBuilder() : null;
        }

        public final void setRowHeaderStyle(TableCellStyle.BuilderImpl rowHeaderStyle) {
            this.rowHeaderStyle = rowHeaderStyle != null ? rowHeaderStyle.build() : null;
        }

        @Override
        public final Builder rowHeaderStyle(TableCellStyle rowHeaderStyle) {
            this.rowHeaderStyle = rowHeaderStyle;
            return this;
        }

        public final TableCellStyle.Builder getCellStyle() {
            return this.cellStyle != null ? this.cellStyle.toBuilder() : null;
        }

        public final void setCellStyle(TableCellStyle.BuilderImpl cellStyle) {
            this.cellStyle = cellStyle != null ? cellStyle.build() : null;
        }

        @Override
        public final Builder cellStyle(TableCellStyle cellStyle) {
            this.cellStyle = cellStyle;
            return this;
        }

        public final TableCellStyle.Builder getRowFieldNamesStyle() {
            return this.rowFieldNamesStyle != null ? this.rowFieldNamesStyle.toBuilder() : null;
        }

        public final void setRowFieldNamesStyle(TableCellStyle.BuilderImpl rowFieldNamesStyle) {
            this.rowFieldNamesStyle = rowFieldNamesStyle != null ? rowFieldNamesStyle.build() : null;
        }

        @Override
        public final Builder rowFieldNamesStyle(TableCellStyle rowFieldNamesStyle) {
            this.rowFieldNamesStyle = rowFieldNamesStyle;
            return this;
        }

        public final RowAlternateColorOptions.Builder getRowAlternateColorOptions() {
            return this.rowAlternateColorOptions != null ? this.rowAlternateColorOptions.toBuilder() : null;
        }

        public final void setRowAlternateColorOptions(RowAlternateColorOptions.BuilderImpl rowAlternateColorOptions) {
            this.rowAlternateColorOptions = rowAlternateColorOptions != null ? rowAlternateColorOptions.build() : null;
        }

        @Override
        public final Builder rowAlternateColorOptions(RowAlternateColorOptions rowAlternateColorOptions) {
            this.rowAlternateColorOptions = rowAlternateColorOptions;
            return this;
        }

        public final String getCollapsedRowDimensionsVisibility() {
            return this.collapsedRowDimensionsVisibility;
        }

        public final void setCollapsedRowDimensionsVisibility(String collapsedRowDimensionsVisibility) {
            this.collapsedRowDimensionsVisibility = collapsedRowDimensionsVisibility;
        }

        @Override
        public final Builder collapsedRowDimensionsVisibility(String collapsedRowDimensionsVisibility) {
            this.collapsedRowDimensionsVisibility = collapsedRowDimensionsVisibility;
            return this;
        }

        @Override
        public final Builder collapsedRowDimensionsVisibility(Visibility collapsedRowDimensionsVisibility) {
            this.collapsedRowDimensionsVisibility(collapsedRowDimensionsVisibility == null ? null : collapsedRowDimensionsVisibility.toString());
            return this;
        }

        public final String getRowsLayout() {
            return this.rowsLayout;
        }

        public final void setRowsLayout(String rowsLayout) {
            this.rowsLayout = rowsLayout;
        }

        @Override
        public final Builder rowsLayout(String rowsLayout) {
            this.rowsLayout = rowsLayout;
            return this;
        }

        @Override
        public final Builder rowsLayout(PivotTableRowsLayout rowsLayout) {
            this.rowsLayout(rowsLayout == null ? null : rowsLayout.toString());
            return this;
        }

        public final PivotTableRowsLabelOptions.Builder getRowsLabelOptions() {
            return this.rowsLabelOptions != null ? this.rowsLabelOptions.toBuilder() : null;
        }

        public final void setRowsLabelOptions(PivotTableRowsLabelOptions.BuilderImpl rowsLabelOptions) {
            this.rowsLabelOptions = rowsLabelOptions != null ? rowsLabelOptions.build() : null;
        }

        @Override
        public final Builder rowsLabelOptions(PivotTableRowsLabelOptions rowsLabelOptions) {
            this.rowsLabelOptions = rowsLabelOptions;
            return this;
        }

        public final String getDefaultCellWidth() {
            return this.defaultCellWidth;
        }

        public final void setDefaultCellWidth(String defaultCellWidth) {
            this.defaultCellWidth = defaultCellWidth;
        }

        @Override
        public final Builder defaultCellWidth(String defaultCellWidth) {
            this.defaultCellWidth = defaultCellWidth;
            return this;
        }

        public PivotTableOptions build() {
            return new PivotTableOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PivotTableOptions> {
        public Builder metricPlacement(String var1);

        public Builder metricPlacement(PivotTableMetricPlacement var1);

        public Builder singleMetricVisibility(String var1);

        public Builder singleMetricVisibility(Visibility var1);

        public Builder columnNamesVisibility(String var1);

        public Builder columnNamesVisibility(Visibility var1);

        public Builder toggleButtonsVisibility(String var1);

        public Builder toggleButtonsVisibility(Visibility var1);

        public Builder columnHeaderStyle(TableCellStyle var1);

        default public Builder columnHeaderStyle(Consumer<TableCellStyle.Builder> columnHeaderStyle) {
            return this.columnHeaderStyle((TableCellStyle)((TableCellStyle.Builder)TableCellStyle.builder().applyMutation(columnHeaderStyle)).build());
        }

        public Builder rowHeaderStyle(TableCellStyle var1);

        default public Builder rowHeaderStyle(Consumer<TableCellStyle.Builder> rowHeaderStyle) {
            return this.rowHeaderStyle((TableCellStyle)((TableCellStyle.Builder)TableCellStyle.builder().applyMutation(rowHeaderStyle)).build());
        }

        public Builder cellStyle(TableCellStyle var1);

        default public Builder cellStyle(Consumer<TableCellStyle.Builder> cellStyle) {
            return this.cellStyle((TableCellStyle)((TableCellStyle.Builder)TableCellStyle.builder().applyMutation(cellStyle)).build());
        }

        public Builder rowFieldNamesStyle(TableCellStyle var1);

        default public Builder rowFieldNamesStyle(Consumer<TableCellStyle.Builder> rowFieldNamesStyle) {
            return this.rowFieldNamesStyle((TableCellStyle)((TableCellStyle.Builder)TableCellStyle.builder().applyMutation(rowFieldNamesStyle)).build());
        }

        public Builder rowAlternateColorOptions(RowAlternateColorOptions var1);

        default public Builder rowAlternateColorOptions(Consumer<RowAlternateColorOptions.Builder> rowAlternateColorOptions) {
            return this.rowAlternateColorOptions((RowAlternateColorOptions)((RowAlternateColorOptions.Builder)RowAlternateColorOptions.builder().applyMutation(rowAlternateColorOptions)).build());
        }

        public Builder collapsedRowDimensionsVisibility(String var1);

        public Builder collapsedRowDimensionsVisibility(Visibility var1);

        public Builder rowsLayout(String var1);

        public Builder rowsLayout(PivotTableRowsLayout var1);

        public Builder rowsLabelOptions(PivotTableRowsLabelOptions var1);

        default public Builder rowsLabelOptions(Consumer<PivotTableRowsLabelOptions.Builder> rowsLabelOptions) {
            return this.rowsLabelOptions((PivotTableRowsLabelOptions)((PivotTableRowsLabelOptions.Builder)PivotTableRowsLabelOptions.builder().applyMutation(rowsLabelOptions)).build());
        }

        public Builder defaultCellWidth(String var1);
    }
}

